/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigStepTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperationSettings;
import org.eclipse.statet.ecommons.databinding.core.conversion.ClassTypedConverter;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class AbstractLaunchConfigOperationSettings
extends DocProcessingOperationSettings {
    private static final Class<@Nullable ILaunchConfiguration> Nullable_LaunchConfiguration_TYPE = ILaunchConfiguration.class;
    private final String launchConfigTypeId;
    private final String launchConfigNameAttrName;
    private ILaunchManager launchManager;
    private ILaunchConfigurationType launchConfigType;
    private ILaunchConfigurationListener launchConfigListener;
    private List<ILaunchConfiguration> availablelaunchConfigs;
    private IObservableValue<@Nullable String> launchConfigNameValue;
    private TableViewer launchConfigViewer;
    private Button launchConfigNewControl;

    public AbstractLaunchConfigOperationSettings(String launchConfigTypeId) {
        this.launchConfigTypeId = launchConfigTypeId;
        this.launchConfigNameAttrName = this.getId() + "/LaunchConfig.name";
    }

    @Override
    public String getInfo() {
        String label = this.getLabel();
        String name = (String)this.launchConfigNameValue.getValue();
        return label + ":  " + (name != null ? this.limitInfo(name) : "?");
    }

    @Override
    protected void init(DocProcessingConfigStepTab tab) {
        super.init(tab);
        Realm realm = this.getRealm();
        this.launchConfigNameValue = new WritableValue(realm, null, String.class);
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigType = this.launchManager.getLaunchConfigurationType(this.launchConfigTypeId);
        if (launchConfigType == null) {
            throw new RuntimeException("Launch configuration type is missing: id= " + this.launchConfigTypeId);
        }
        this.launchConfigType = launchConfigType;
        this.launchConfigListener = new ILaunchConfigurationListener(){

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
                AbstractLaunchConfigOperationSettings.this.updateAvailableConfigs();
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                AbstractLaunchConfigOperationSettings.this.updateAvailableConfigs();
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                AbstractLaunchConfigOperationSettings.this.updateAvailableConfigs();
            }
        };
        this.launchManager.addLaunchConfigurationListener(this.launchConfigListener);
        this.updateAvailableConfigs();
    }

    @Override
    protected void dispose() {
        if (this.launchManager != null) {
            this.launchManager.removeLaunchConfigurationListener(this.launchConfigListener);
        }
        super.dispose();
    }

    @Override
    protected Composite createControl(Composite parent) {
        Composite composite = super.createControl(parent);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        Label label = new Label(composite, 0);
        label.setText(Messages.ProcessingOperation_RunLaunchConfigSettings_List_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        TableViewer viewer = new TableViewer(composite, 68356);
        viewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput(new Object());
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = LayoutUtils.hintHeight((Table)viewer.getTable(), (int)5);
        viewer.getControl().setLayoutData((Object)gd);
        this.launchConfigViewer = viewer;
        Button button = new Button(composite, 8);
        button.setText(Messages.ProcessingOperation_RunLaunchConfigSettings_New_label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLaunchConfigOperationSettings.this.createNewLaunchConfig();
            }
        });
        gd = new GridData(4, 128, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Button)button);
        button.setLayoutData((Object)gd);
        this.launchConfigNewControl = button;
        return composite;
    }

    @Override
    protected void addBindings(DataBindingContext dbc) {
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection(ILaunchConfiguration.class).observe((Viewer)this.launchConfigViewer), this.launchConfigNameValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new IValidator<ILaunchConfiguration>(){

            public IStatus validate(@Nullable ILaunchConfiguration value) {
                if (value == null) {
                    return ValidationStatus.error((String)NLS.bind((String)Messages.ProcessingOperation_RunLaunchConfigSettings_error_NoConfigSelected_message, (Object)AbstractLaunchConfigOperationSettings.this.getLabel()));
                }
                return ValidationStatus.ok();
            }
        }).setConverter((IConverter)ClassTypedConverter.create(Nullable_LaunchConfiguration_TYPE, (Class)ObjectUtils.Nullable_String_TYPE, fromObject -> fromObject != null ? fromObject.getName() : null)), new UpdateValueStrategy().setConverter((IConverter)ClassTypedConverter.create((Class)ObjectUtils.Nullable_String_TYPE, Nullable_LaunchConfiguration_TYPE, this::findLaunchConfig)));
    }

    private @Nullable ILaunchConfiguration findLaunchConfig(@Nullable String name) {
        if (name != null) {
            for (ILaunchConfiguration config : this.availablelaunchConfigs) {
                if (!config.getName().equals(name)) continue;
                return config;
            }
        }
        return null;
    }

    private void updateAvailableConfigs() {
        try {
            @NonNull ILaunchConfiguration[] allConfigs = this.launchManager.getLaunchConfigurations(this.launchConfigType);
            ArrayList<ILaunchConfiguration> filteredConfigs = new ArrayList<ILaunchConfiguration>(allConfigs.length);
            ILaunchConfiguration[] iLaunchConfigurationArray = allConfigs;
            int n = allConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (this.includeLaunchConfig(config)) {
                    filteredConfigs.add(config);
                }
                ++n2;
            }
            this.availablelaunchConfigs = filteredConfigs;
            if (UIAccess.isOkToUse((Viewer)this.launchConfigViewer)) {
                this.launchConfigViewer.setInput(this.availablelaunchConfigs);
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"An error occurred while updating list of launch configurations for ''{0}''.", (Object)this.getLabel()), (Throwable)e));
        }
    }

    protected boolean includeLaunchConfig(ILaunchConfiguration config) {
        return true;
    }

    protected void createNewLaunchConfig() {
        try {
            String name = this.getLaunchConfigurationDialog().generateName(this.getNewLaunchConfigName());
            ILaunchConfigurationWorkingCopy newConfig = this.launchConfigType.newInstance(null, name);
            this.initializeNewLaunchConfig(newConfig);
            this.launchConfigNameValue.setValue((Object)name);
            newConfig.doSave();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)Messages.ProcessingOperation_RunLaunchConfigSettings_error_NewConfigFailed_message, (Object)this.getLabel()), (Throwable)e), 3);
        }
    }

    protected @Nullable String getNewLaunchConfigName() {
        return null;
    }

    protected void initializeNewLaunchConfig(ILaunchConfigurationWorkingCopy config) {
    }

    @Override
    protected void load(Map<String, String> config) {
        String name = config.get(this.launchConfigNameAttrName);
        this.launchConfigNameValue.setValue((Object)name);
    }

    @Override
    protected void save(Map<String, String> config) {
        String name = (String)this.launchConfigNameValue.getValue();
        AbstractLaunchConfigOperationSettings.set(config, this.launchConfigNameAttrName, name);
    }
}

