/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.views.documentation;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sphinx.platform.ui.internal.Activator;
import org.eclipse.sphinx.platform.ui.views.documentation.IDocumentationViewFormatter;
import org.eclipse.sphinx.platform.util.ExtensionClassDescriptor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class DocumentationViewFormatterDescriptor
extends ExtensionClassDescriptor<IDocumentationViewFormatter> {
    private static final String NODE_INSTANCEOF = "instanceof";
    private static final String ATTR_PRIORITY = "priority";
    private int priority = 0;
    private IConfigurationElement instanceOfConfigElement;

    public DocumentationViewFormatterDescriptor(IConfigurationElement configurationElement) {
        super(configurationElement);
        IConfigurationElement[] instanceOfConfigElements;
        String priorityAttributeValue = configurationElement.getAttribute(ATTR_PRIORITY);
        if (priorityAttributeValue != null && !priorityAttributeValue.isEmpty()) {
            try {
                this.priority = Integer.valueOf(priorityAttributeValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((instanceOfConfigElements = configurationElement.getChildren(NODE_INSTANCEOF)).length > 0) {
            this.instanceOfConfigElement = instanceOfConfigElements[0];
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isApplicableFor(Object selectedObject) {
        if (this.instanceOfConfigElement != null) {
            try {
                Expression expression = ExpressionConverter.getDefault().perform(this.instanceOfConfigElement);
                EvaluationResult evaluate = expression.evaluate((IEvaluationContext)new EvaluationContext(null, selectedObject));
                return evaluate.equals(EvaluationResult.TRUE);
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
                return false;
            }
        }
        return false;
    }
}

