/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.lib;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.set.browser.cef.win32.CEFResource;

public class CEFLibrary {
    private static final String CHROME_ELF = "chrome_elf";
    private static final String CHROMIUM_SUBPROCESS = "chromium_subp.exe";
    private static final String JNI_LIB = "chromium_jni";
    private static final String LIBCEF = "libcef";

    public static String getSubprocessExePath() {
        URI uri = CEFLibrary.getResourceFileURI(CHROMIUM_SUBPROCESS);
        return Paths.get(uri).toAbsolutePath().toString();
    }

    public static String getTempPath() {
        return CEFLibrary.getTempPathBase().resolve(Long.toString(ProcessHandle.current().pid())).toString();
    }

    public static Path getTempPathBase() {
        return Paths.get(System.getenv("APPDATA"), "Eclipse SET", "cef_temp").toAbsolutePath();
    }

    public static void cleanTempPath() throws IOException {
        Path path = CEFLibrary.getTempPathBase();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> files = Files.list(path);){
            files.filter(p -> {
                if (!p.toFile().isDirectory()) {
                    return false;
                }
                try {
                    long pid = Long.parseLong(p.getFileName().toString());
                    return ProcessHandle.current().pid() == pid || ProcessHandle.of(pid).isEmpty();
                }
                catch (NumberFormatException e) {
                    return true;
                }
            }).forEach(p -> {
                try {
                    FileUtils.deleteDirectory((File)p.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void loadLibraries() {
        System.load(CEFLibrary.getCEFLibraryFile(CHROME_ELF).getAbsolutePath());
        System.load(CEFLibrary.getCEFLibraryFile(LIBCEF).getAbsolutePath());
        System.load(CEFLibrary.getLibraryFile(JNI_LIB).getAbsolutePath());
    }

    private static File getCEFLibraryFile(String library) {
        String mapLibraryName = System.mapLibraryName(library);
        return CEFResource.getPath().resolve(mapLibraryName).toFile();
    }

    private static File getLibraryFile(String library) {
        String mapLibraryName = System.mapLibraryName(library);
        return new File(CEFLibrary.getResourceFileURI(mapLibraryName));
    }

    private static URI getResourceFileURI(String name) {
        URL url = CEFLibrary.class.getClassLoader().getResource(name);
        try {
            URL fileUrl = FileLocator.toFileURL((URL)url);
            return new URI(fileUrl.getProtocol(), fileUrl.getUserInfo(), fileUrl.getHost(), fileUrl.getPort(), fileUrl.getPath(), fileUrl.getQuery(), fileUrl.getRef());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

