/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.set.basis.extensions.ICharacterScannerExtensions;

public class TagRule
implements IRule {
    private boolean isOpen = false;
    private final IToken successToken;

    public TagRule(IToken successToken) {
        this.successToken = successToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (ICharacterScannerExtensions.read((ICharacterScanner)scanner, (String)">")) {
            this.isOpen = false;
            return this.successToken;
        }
        if (ICharacterScannerExtensions.read((ICharacterScanner)scanner, (String)"?>")) {
            this.isOpen = false;
            return this.successToken;
        }
        if (ICharacterScannerExtensions.read((ICharacterScanner)scanner, (String)"/>")) {
            this.isOpen = false;
            return this.successToken;
        }
        if (ICharacterScannerExtensions.read((ICharacterScanner)scanner, (String)"-->")) {
            this.isOpen = false;
            return this.successToken;
        }
        if (ICharacterScannerExtensions.read((ICharacterScanner)scanner, (String)"<")) {
            this.findEnd(scanner);
            return this.successToken;
        }
        return Token.UNDEFINED;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private void findEnd(ICharacterScanner scanner) {
        int c = scanner.read();
        while (!this.isEnd(c)) {
            c = scanner.read();
        }
    }

    private boolean isEnd(int c) {
        if (c == -1) {
            this.isOpen = true;
            return true;
        }
        if (c == 62) {
            this.isOpen = false;
            return true;
        }
        if (Character.isWhitespace(c)) {
            this.isOpen = true;
            return true;
        }
        this.isOpen = true;
        return false;
    }
}

