/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.set.basis.geometry.Chord;
import org.eclipse.set.basis.geometry.IllegalLineStringDistance;
import org.eclipse.set.basis.geometry.SegmentPosition;
import org.eclipse.set.basis.graph.DirectedElementImpl;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.AffineTransformationFactory;

public class Geometries {
    private static final double ACCURACY = 0.1;

    public static LineSegment clone(LineSegment original) {
        return new LineSegment(original.p0.x, original.p0.y, original.p1.x, original.p1.y);
    }

    public static LineString createArc(GeometryFactory geometryFactory, Chord chord) {
        double[] data = chord.linearize();
        CoordinateSequence cs = geometryFactory.getCoordinateSequenceFactory().create(data.length / 2, 2);
        int i = 0;
        while (i < cs.size()) {
            cs.setOrdinate(i, 0, data[i * 2]);
            cs.setOrdinate(i, 1, data[i * 2 + 1]);
            ++i;
        }
        return new LineString(cs, geometryFactory);
    }

    public static double getRotationToVertical(LineSegment segment) {
        double angle = Angle.angleBetweenOriented((Coordinate)segment.p1, (Coordinate)segment.p0, (Coordinate)new Coordinate(segment.p0.x, segment.p0.y + 1.0));
        return Angle.toDegrees((double)angle);
    }

    public static SegmentPosition getSegmentPosition(LineString lineString, Coordinate start, BigDecimal distance) throws IllegalLineStringDistance {
        List<SegmentWithDistance> segments = Geometries.getSegments(DirectedElementImpl.forwards(lineString), start);
        SegmentPosition position = Geometries.getSegmentPosition(segments, distance);
        if (position == null) {
            throw new IllegalLineStringDistance(lineString, distance.doubleValue());
        }
        return position;
    }

    public static void scale(LineSegment segment, double length) {
        Coordinate start = segment.p0;
        AffineTransformation moveStartToOrigin = AffineTransformation.translationInstance((double)(-start.x), (double)(-start.y));
        double segmentAngle = segment.angle();
        AffineTransformation rotateToXAxis = AffineTransformation.rotationInstance((double)(-segmentAngle));
        double xScale = 0.0;
        if (segment.getLength() != 0.0) {
            xScale = length / segment.getLength();
        }
        AffineTransformation scaleAlongXAxis = AffineTransformation.scaleInstance((double)xScale, (double)1.0);
        AffineTransformation rotateToOriginalAngle = AffineTransformation.rotationInstance((double)segmentAngle);
        AffineTransformation moveOriginToStart = AffineTransformation.translationInstance((double)start.x, (double)start.y);
        AffineTransformation transformation = moveStartToOrigin.compose(rotateToXAxis).compose(scaleAlongXAxis).compose(rotateToOriginalAngle).compose(moveOriginToStart);
        transformation.transform(segment.p0, segment.p0);
        transformation.transform(segment.p1, segment.p1);
    }

    public static void translate(LineSegment segment, Coordinate source, Coordinate destination) {
        AffineTransformation transformation = AffineTransformationFactory.createFromControlVectors((Coordinate)source, (Coordinate)destination);
        transformation.transform(segment.p0, segment.p0);
        transformation.transform(segment.p1, segment.p1);
    }

    public static void turn(LineSegment segment, double angle) {
        Coordinate start = segment.p0;
        AffineTransformation moveStartToOrigin = AffineTransformation.translationInstance((double)(-start.x), (double)(-start.y));
        AffineTransformation rotate = AffineTransformation.rotationInstance((double)Angle.toRadians((double)angle));
        AffineTransformation moveOriginToStart = AffineTransformation.translationInstance((double)start.x, (double)start.y);
        AffineTransformation transformation = moveStartToOrigin.compose(rotate).compose(moveOriginToStart);
        transformation.transform(segment.p0, segment.p0);
        transformation.transform(segment.p1, segment.p1);
    }

    private static DirectedElementImpl<LineString> getLineStringAtStart(DirectedElementImpl<LineString> directedLineString, Coordinate start) {
        LineString lineString = directedLineString.getElement();
        Coordinate lineStringStart = lineString.getCoordinateN(0);
        if (lineStringStart.distance(start) < 0.1) {
            return directedLineString;
        }
        LineString reverseLineString = lineString.reverse();
        Coordinate lineStringEnd = reverseLineString.getCoordinateN(0);
        if (lineStringEnd.distance(start) < 0.1) {
            return DirectedElementImpl.backwards(reverseLineString);
        }
        throw new IllegalArgumentException(String.format("Coordinate %s is not start or end of line string %s", start, directedLineString));
    }

    private static SegmentPosition getSegmentPosition(List<SegmentWithDistance> segments, BigDecimal distance) {
        int left = 0;
        int right = segments.size();
        while (left <= right) {
            int mid = left + (right - left) / 2;
            SegmentWithDistance midSegment = segments.get(mid);
            if (midSegment.contains(distance)) {
                return new SegmentPosition(midSegment.segment, distance.subtract(midSegment.startDistance));
            }
            if (midSegment.startDistance().compareTo(distance) >= 0) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return null;
    }

    private static List<SegmentWithDistance> getSegments(DirectedElementImpl<LineString> directedLineString, Coordinate start) {
        LinkedList<SegmentWithDistance> result = new LinkedList<SegmentWithDistance>();
        DirectedElementImpl<LineString> directedLineStringAtStart = Geometries.getLineStringAtStart(directedLineString, start);
        CoordinateSequence sequence = directedLineStringAtStart.getElement().getCoordinateSequence();
        int size = sequence.size();
        if (size < 2) {
            return result;
        }
        Coordinate segmentStart = sequence.getCoordinate(0);
        BigDecimal distanceToStart = BigDecimal.ZERO;
        int i = 1;
        while (i < size) {
            Coordinate segmentEnd = sequence.getCoordinate(i);
            DirectedElementImpl<LineSegment> segment = new DirectedElementImpl<LineSegment>(new LineSegment(segmentStart, segmentEnd), directedLineStringAtStart.isForwards());
            result.add(new SegmentWithDistance(segment, distanceToStart));
            distanceToStart = distanceToStart.add(BigDecimal.valueOf(segment.getElement().getLength()));
            segmentStart = segmentEnd;
            ++i;
        }
        return result;
    }

    private record SegmentWithDistance(DirectedElementImpl<LineSegment> segment, BigDecimal startDistance) {
        public BigDecimal endDistance() {
            return this.startDistance.add(this.segmentLength());
        }

        public BigDecimal segmentLength() {
            return BigDecimal.valueOf(this.segment.getElement().getLength());
        }

        public boolean contains(BigDecimal distance) {
            return this.startDistance.compareTo(distance) <= 0 && this.endDistance().compareTo(distance) >= 0;
        }
    }
}

