/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.registry.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.rap.http.registry.HttpContextExtensionService;
import org.eclipse.rap.http.registry.internal.HttpRegistryManager;
import org.eclipse.rap.service.http.HttpContext;
import org.eclipse.rap.service.http.HttpService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class HttpServiceTracker
extends ServiceTracker<HttpService, HttpService> {
    private PackageAdmin packageAdmin;
    private IExtensionRegistry registry;
    private ServiceRegistration<?> registration;
    Map<ServiceReference<HttpService>, HttpRegistryManager> httpRegistryManagers = new HashMap<ServiceReference<HttpService>, HttpRegistryManager>();

    public HttpServiceTracker(BundleContext context, PackageAdmin packageAdmin, IExtensionRegistry registry) {
        super(context, HttpService.class, null);
        this.packageAdmin = packageAdmin;
        this.registry = registry;
    }

    public void open() {
        super.open();
        this.registration = this.context.registerService(HttpContextExtensionService.class.getName(), (Object)new HttpContextExtensionServiceFactory(), null);
    }

    public void close() {
        this.registration.unregister();
        this.registration = null;
        super.close();
    }

    public synchronized HttpService addingService(ServiceReference<HttpService> reference) {
        HttpService httpService = (HttpService)super.addingService(reference);
        if (httpService == null) {
            return null;
        }
        HttpRegistryManager httpRegistryManager = new HttpRegistryManager(reference, httpService, this.packageAdmin, this.registry);
        httpRegistryManager.start();
        this.httpRegistryManagers.put(reference, httpRegistryManager);
        return httpService;
    }

    public void modifiedService(ServiceReference<HttpService> reference, HttpService service) {
    }

    public synchronized void removedService(ServiceReference<HttpService> reference, HttpService service) {
        HttpRegistryManager httpRegistryManager = this.httpRegistryManagers.remove(reference);
        if (httpRegistryManager != null) {
            httpRegistryManager.stop();
        }
        super.removedService(reference, (Object)service);
    }

    public class HttpContextExtensionServiceFactory
    implements ServiceFactory<HttpContextExtensionService> {
        public HttpContextExtensionService getService(Bundle bundle, ServiceRegistration<HttpContextExtensionService> r) {
            return new HttpContextExtensionServiceImpl(bundle);
        }

        public void ungetService(Bundle bundle, ServiceRegistration<HttpContextExtensionService> r, HttpContextExtensionService service) {
        }
    }

    public class HttpContextExtensionServiceImpl
    implements HttpContextExtensionService {
        private Bundle bundle;

        public HttpContextExtensionServiceImpl(Bundle bundle) {
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HttpContext getHttpContext(ServiceReference<HttpService> httpServiceReference, String httpContextId) {
            HttpServiceTracker httpServiceTracker = HttpServiceTracker.this;
            synchronized (httpServiceTracker) {
                HttpRegistryManager httpRegistryManager;
                block4: {
                    httpRegistryManager = HttpServiceTracker.this.httpRegistryManagers.get(httpServiceReference);
                    if (httpRegistryManager != null) break block4;
                    return null;
                }
                return httpRegistryManager.getHttpContext(httpContextId, this.bundle);
            }
        }
    }
}

