/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SharedInstanceBuffer<K, I>
implements Serializable {
    private final Lock readLock;
    private final Lock writeLock;
    private final Map<K, I> store;

    public SharedInstanceBuffer() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.store = new HashMap<K, I>();
    }

    public I get(K key, InstanceCreator<K, I> instanceCreator) {
        I result = this.getInstance(key);
        if (result == null) {
            result = this.createInstance(key, instanceCreator);
        }
        return result;
    }

    public I remove(K key) {
        this.writeLock.lock();
        try {
            I i = this.store.remove(key);
            return i;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private I getInstance(K key) {
        this.readLock.lock();
        try {
            I i = this.store.get(key);
            return i;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private I createInstance(K key, InstanceCreator<K, I> instanceCreator) {
        this.writeLock.lock();
        try {
            I result = this.store.get(key);
            if (result == null) {
                result = instanceCreator.createInstance(key);
                this.store.put(key, result);
            }
            I i = result;
            return i;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static interface InstanceCreator<K, T>
    extends Serializable {
        public T createInstance(K var1);
    }
}

