/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IToolItemAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

final class ToolItemLCAUtil {
    private static final String TYPE = "rwt.widgets.ToolItem";
    private static final String[] ALLOWED_STYLES = new String[]{"PUSH", "CHECK", "RADIO", "SEPARATOR", "DROP_DOWN"};
    private static final String PROP_VISIBLE = "visible";
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_HOT_IMAGE = "hotImage";
    private static final String PROP_CONTROL = "control";
    static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_LISTENER = "Selection";

    private ToolItemLCAUtil() {
    }

    static void preserveValues(ToolItem toolItem) {
        WidgetLCAUtil.preserveBounds(toolItem, toolItem.getBounds());
        WidgetLCAUtil.preserveEnabled(toolItem, toolItem.getEnabled());
        WidgetLCAUtil.preserveToolTipText(toolItem, toolItem.getToolTipText());
        WidgetLCAUtil.preserveCustomVariant(toolItem);
        WidgetLCAUtil.preserveData(toolItem);
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_VISIBLE, ToolItemLCAUtil.isVisible(toolItem));
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_TEXT, toolItem.getText());
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_IMAGE, ToolItemLCAUtil.getImage(toolItem));
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_HOT_IMAGE, toolItem.getHotImage());
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_CONTROL, toolItem.getControl());
        WidgetLCAUtil.preserveProperty((Widget)toolItem, PROP_SELECTION, toolItem.getSelection());
        WidgetLCAUtil.preserveListener(toolItem, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(toolItem, 13));
    }

    static void renderInitialization(ToolItem toolItem) {
        ToolBar toolBar = toolItem.getParent();
        IClientObject clientObject = ClientObjectFactory.getClientObject(toolItem);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(toolItem.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(toolItem, ALLOWED_STYLES)));
        clientObject.set("index", toolBar.indexOf(toolItem));
    }

    static void renderChanges(ToolItem toolItem) {
        WidgetLCAUtil.renderBounds(toolItem, toolItem.getBounds());
        WidgetLCAUtil.renderEnabled(toolItem, toolItem.getEnabled());
        WidgetLCAUtil.renderToolTip(toolItem, toolItem.getToolTipText());
        WidgetLCAUtil.renderCustomVariant(toolItem);
        WidgetLCAUtil.renderData(toolItem);
        ToolItemLCAUtil.renderText(toolItem);
        ToolItemLCAUtil.renderMnemonicIndex(toolItem);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_VISIBLE, ToolItemLCAUtil.isVisible(toolItem), true);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_IMAGE, ToolItemLCAUtil.getImage(toolItem), null);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_HOT_IMAGE, toolItem.getHotImage(), null);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_CONTROL, toolItem.getControl(), null);
        WidgetLCAUtil.renderProperty((Widget)toolItem, PROP_SELECTION, toolItem.getSelection(), false);
        WidgetLCAUtil.renderListener(toolItem, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(toolItem, 13), false);
    }

    static void processSelection(ToolItem toolItem) {
        String eventName = PROP_SELECTION_LISTENER;
        if (WidgetLCAUtil.wasEventSent(toolItem, eventName)) {
            Event event = new Event();
            event.stateMask = EventLCAUtil.readStateMask(toolItem, eventName);
            toolItem.notifyListeners(13, event);
        }
    }

    private static boolean isVisible(ToolItem toolItem) {
        return toolItem.getAdapter(IToolItemAdapter.class).getVisible();
    }

    private static void renderText(ToolItem toolItem) {
        String newValue = toolItem.getText();
        if (WidgetLCAUtil.hasChanged(toolItem, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            ClientObjectFactory.getClientObject(toolItem).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(ToolItem toolItem) {
        int mnemonicIndex;
        String text = toolItem.getText();
        if (WidgetLCAUtil.hasChanged(toolItem, PROP_TEXT, text, "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            ClientObjectFactory.getClientObject(toolItem).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }

    static Image getImage(ToolItem toolItem) {
        Image result;
        if (toolItem.getEnabled() && toolItem.getParent().getEnabled()) {
            result = toolItem.getImage();
        } else {
            result = toolItem.getDisabledImage();
            if (result == null) {
                result = toolItem.getImage();
            }
        }
        return result;
    }
}

