/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tabitemkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class TabItemLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.TabItem";
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_CONTROL = "control";

    public void preserveValues(Widget widget) {
        TabItem item = (TabItem)widget;
        WidgetLCAUtil.preserveCustomVariant(item);
        WidgetLCAUtil.preserveData(item);
        WidgetLCAUtil.preserveToolTipText(item, item.getToolTipText());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXT, item.getText());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGE, item.getImage());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_CONTROL, item.getControl());
    }

    public void readData(Widget widget) {
    }

    public void renderInitialization(Widget widget) throws IOException {
        TabItem item = (TabItem)widget;
        TabFolder parent = item.getParent();
        IClientObject clientObject = ClientObjectFactory.getClientObject(item);
        clientObject.create(TYPE);
        clientObject.set("id", WidgetUtil.getId(item));
        clientObject.set("parent", WidgetUtil.getId(parent));
        clientObject.set("index", parent.indexOf(item));
    }

    public void renderChanges(Widget widget) throws IOException {
        TabItem item = (TabItem)widget;
        WidgetLCAUtil.renderCustomVariant(item);
        WidgetLCAUtil.renderData(item);
        WidgetLCAUtil.renderToolTip(item, item.getToolTipText());
        TabItemLCA.renderText(item);
        TabItemLCA.renderMnemonicIndex(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGE, item.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_CONTROL, item.getControl(), null);
    }

    private static void renderText(TabItem item) {
        String newValue = item.getText();
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            IClientObject clientObject = ClientObjectFactory.getClientObject(item);
            clientObject.set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(TabItem item) {
        int mnemonicIndex;
        String text = item.getText();
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, text, "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(item);
            clientObject.set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }
}

