/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class MenuItemLCAUtil {
    private static final String TYPE = "rwt.widgets.MenuItem";
    private static final String[] ALLOWED_STYLES = new String[]{"CHECK", "CASCADE", "PUSH", "RADIO", "SEPARATOR"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_MENU = "menu";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_LISTENER = "Selection";

    MenuItemLCAUtil() {
    }

    static void preserveValues(MenuItem item) {
        WidgetLCAUtil.preserveCustomVariant(item);
        WidgetLCAUtil.preserveData(item);
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_TEXT, item.getText());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_IMAGE, item.getImage());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_MENU, item.getMenu());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_ENABLED, item.getEnabled());
        WidgetLCAUtil.preserveProperty((Widget)item, PROP_SELECTION, item.getSelection());
        WidgetLCAUtil.preserveListener(item, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(item, 13));
        WidgetLCAUtil.preserveHelpListener(item);
    }

    static void renderInitialization(MenuItem item) {
        IClientObject clientObject = ClientObjectFactory.getClientObject(item);
        clientObject.create(TYPE);
        Menu parent = item.getParent();
        clientObject.set("parent", WidgetUtil.getId(parent));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(item, ALLOWED_STYLES)));
        clientObject.set("index", parent.indexOf(item));
    }

    static void renderChanges(MenuItem item) {
        WidgetLCAUtil.renderCustomVariant(item);
        WidgetLCAUtil.renderData(item);
        MenuItemLCAUtil.renderText(item);
        MenuItemLCAUtil.renderMnemonicIndex(item);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_IMAGE, item.getImage(), null);
        WidgetLCAUtil.renderMenu(item, item.getMenu());
        WidgetLCAUtil.renderProperty((Widget)item, PROP_ENABLED, item.getEnabled(), true);
        WidgetLCAUtil.renderProperty((Widget)item, PROP_SELECTION, item.getSelection(), false);
        WidgetLCAUtil.renderListener(item, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(item, 13), false);
        WidgetLCAUtil.renderListenHelp(item);
    }

    static void processArmEvent(MenuItem item) {
        Menu menu = item.getParent();
        if (WidgetLCAUtil.wasEventSent(menu, "Show")) {
            item.notifyListeners(30, new Event());
        }
    }

    private static void renderText(MenuItem item) {
        String newValue = item.getText();
        if (WidgetLCAUtil.hasChanged(item, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            ClientObjectFactory.getClientObject(item).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(MenuItem item) {
        int mnemonicIndex;
        String text;
        if ((item.getStyle() & 2) == 0 && WidgetLCAUtil.hasChanged(item, PROP_TEXT, text = item.getText(), "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            ClientObjectFactory.getClientObject(item).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }
}

