/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.buttonkit;

import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

final class ButtonLCAUtil {
    private static final String TYPE = "rwt.widgets.Button";
    private static final String[] ALLOWED_STYLES = new String[]{"ARROW", "CHECK", "PUSH", "RADIO", "TOGGLE", "FLAT", "WRAP", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_GRAYED = "grayed";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_SELECTION_LISTENERS = "Selection";
    private static final String PARAM_SELECTION = "selection";
    private static final String DEFAULT_ALIGNMENT = "center";

    private ButtonLCAUtil() {
    }

    static void preserveValues(Button button) {
        ControlLCAUtil.preserveValues(button);
        WidgetLCAUtil.preserveCustomVariant(button);
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_TEXT, button.getText());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_IMAGE, button.getImage());
        WidgetLCAUtil.preserveProperty((Widget)button, "selection", (Object)button.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_GRAYED, (Object)button.getGrayed());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_ALIGNMENT, ButtonLCAUtil.getAlignment(button));
        WidgetLCAUtil.preserveListener(button, PROP_SELECTION_LISTENERS, EventLCAUtil.isListening(button, 13));
    }

    static void renderInitialization(Button button) {
        IClientObject clientObject = ClientObjectFactory.getClientObject(button);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(button.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(button, ALLOWED_STYLES)));
    }

    static void renderChanges(Button button) {
        ControlLCAUtil.renderChanges(button);
        WidgetLCAUtil.renderCustomVariant(button);
        ButtonLCAUtil.renderText(button);
        ButtonLCAUtil.renderMnemonicIndex(button);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_IMAGE, button.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_ALIGNMENT, ButtonLCAUtil.getAlignment(button), DEFAULT_ALIGNMENT);
        WidgetLCAUtil.renderProperty((Widget)button, "selection", button.getSelection(), false);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_GRAYED, button.getGrayed(), false);
        WidgetLCAUtil.renderListener(button, PROP_SELECTION_LISTENERS, EventLCAUtil.isListening(button, 13), false);
    }

    static boolean readSelection(Button button) {
        String value = WidgetLCAUtil.readPropertyValue(button, "selection");
        if (value != null) {
            button.setSelection(Boolean.valueOf(value));
        }
        return value != null;
    }

    private static String getAlignment(Button button) {
        int alignment = button.getAlignment();
        String result = (alignment & 0x4000) != 0 ? "left" : ((alignment & 0x1000000) != 0 ? DEFAULT_ALIGNMENT : ((alignment & 0x20000) != 0 ? "right" : ((alignment & 0x80) != 0 ? "up" : ((alignment & 0x400) != 0 ? "down" : "left"))));
        return result;
    }

    private static void renderText(Button button) {
        String newValue = button.getText();
        if (WidgetLCAUtil.hasChanged(button, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            IClientObject clientObject = ClientObjectFactory.getClientObject(button);
            clientObject.set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(Button button) {
        int mnemonicIndex;
        String text = button.getText();
        if (WidgetLCAUtil.hasChanged(button, PROP_TEXT, text, "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(button);
            clientObject.set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }
}

