/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.browser.browserkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.PhaseEvent;
import org.eclipse.rap.rwt.lifecycle.PhaseId;
import org.eclipse.rap.rwt.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.widgets.Widget;

public final class BrowserLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Browser";
    private static final String[] ALLOWED_STYLES = new String[]{"BORDER"};
    static final String BLANK_HTML = "<html><script></script><body style=\"background-color: transparent;\"></body></html>";
    public static final String EVENT_PROGRESS = "Progress";
    private static final String PARAM_EXECUTE_RESULT = "executeResult";
    private static final String PARAM_EVALUATE_RESULT = "evaluateResult";
    static final String PARAM_EXECUTE_FUNCTION = "executeFunction";
    static final String PARAM_EXECUTE_ARGUMENTS = "executeArguments";
    private static final String PARAM_PROGRESS_LISTENER = "Progress";
    private static final String PARAM_SCRIPT = "script";
    private static final String METHOD_EVALUATE = "evaluate";
    private static final String PARAM_FUNCTIONS = "functions";
    private static final String METHOD_CREATE_FUNCTIONS = "createFunctions";
    private static final String METHOD_DESTROY_FUNCTIONS = "destroyFunctions";
    private static final String PARAM_FUNCTION_RESULT = "functionResult";
    static final String EXECUTED_FUNCTION_NAME = String.valueOf(Browser.class.getName()) + "#executedFunctionName.";
    static final String EXECUTED_FUNCTION_RESULT = String.valueOf(Browser.class.getName()) + "#executedFunctionResult.";
    static final String EXECUTED_FUNCTION_ERROR = String.valueOf(Browser.class.getName()) + "#executedFunctionError.";
    private static final String FUNCTIONS_TO_CREATE = String.valueOf(Browser.class.getName()) + "#functionsToCreate.";
    private static final String FUNCTIONS_TO_DESTROY = String.valueOf(Browser.class.getName()) + "#functionsToDestroy.";

    public void preserveValues(Widget widget) {
        Browser browser = (Browser)widget;
        ControlLCAUtil.preserveValues(browser);
        WidgetLCAUtil.preserveCustomVariant(browser);
        WidgetLCAUtil.preserveListener(browser, "Progress", this.hasProgressListener(browser));
    }

    public void readData(Widget widget) {
        Browser browser = (Browser)widget;
        BrowserLCA.readExecuteResult(browser);
        BrowserLCA.executeFunction(browser);
        BrowserLCA.fireProgressEvent(browser);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Browser browser = (Browser)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(browser);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(browser.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(browser, ALLOWED_STYLES)));
    }

    public void renderChanges(Widget widget) throws IOException {
        Browser browser = (Browser)widget;
        ControlLCAUtil.renderChanges(browser);
        WidgetLCAUtil.renderCustomVariant(browser);
        BrowserLCA.destroyBrowserFunctions(browser);
        BrowserLCA.renderUrl(browser);
        BrowserLCA.createBrowserFunctions(browser);
        BrowserLCA.renderEvaluate(browser);
        BrowserLCA.renderFunctionResult(browser);
        WidgetLCAUtil.renderListener(browser, "Progress", this.hasProgressListener(browser), false);
    }

    private static void fireProgressEvent(Browser browser) {
        if (WidgetLCAUtil.wasEventSent(browser, "Progress")) {
            IBrowserAdapter browserAdapter = browser.getAdapter(IBrowserAdapter.class);
            browserAdapter.sendProgressCompletedEvent();
        }
    }

    private static void readExecuteResult(Browser browser) {
        String executeValue = WidgetLCAUtil.readPropertyValue(browser, PARAM_EXECUTE_RESULT);
        if (executeValue != null) {
            JsonValue value = ProtocolUtil.readPropertyValue(WidgetUtil.getId(browser), PARAM_EVALUATE_RESULT);
            Object evalValue = JsonUtil.jsonToJava(value);
            boolean executeResult = Boolean.valueOf(executeValue);
            Object evalResult = null;
            if (evalValue != null && evalValue instanceof Object[]) {
                evalResult = ((Object[])evalValue)[0];
            }
            browser.getAdapter(IBrowserAdapter.class).setExecuteResult(executeResult, evalResult);
        }
    }

    private static void renderUrl(Browser browser) throws IOException {
        if (BrowserLCA.hasUrlChanged(browser)) {
            ClientObjectFactory.getClientObject(browser).set("url", BrowserLCA.getUrl(browser));
            browser.getAdapter(IBrowserAdapter.class).resetUrlChanged();
        }
    }

    static boolean hasUrlChanged(Browser browser) {
        boolean initialized = WidgetUtil.getAdapter(browser).isInitialized();
        return !initialized || browser.getAdapter(IBrowserAdapter.class).hasUrlChanged();
    }

    static String getUrl(Browser browser) throws IOException {
        String text = BrowserLCA.getText(browser);
        String url = browser.getUrl();
        String result = !"".equals(text.trim()) ? BrowserLCA.registerHtml(text) : (!"".equals(url.trim()) ? url : BrowserLCA.registerHtml(BLANK_HTML));
        return result;
    }

    private static void renderEvaluate(final Browser browser) {
        IBrowserAdapter adapter = browser.getAdapter(IBrowserAdapter.class);
        final String executeScript = adapter.getExecuteScript();
        boolean executePending = adapter.getExecutePending();
        if (executeScript != null && !executePending) {
            final LifeCycle lifeCycle = ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle();
            lifeCycle.addPhaseListener(new PhaseListener(){

                public void beforePhase(PhaseEvent event) {
                }

                public void afterPhase(PhaseEvent event) {
                    if (browser.getDisplay() == LifeCycleUtil.getSessionDisplay()) {
                        try {
                            JsonObject parameters = new JsonObject().add(BrowserLCA.PARAM_SCRIPT, executeScript);
                            ClientObjectFactory.getClientObject(browser).call(BrowserLCA.METHOD_EVALUATE, parameters);
                        }
                        finally {
                            lifeCycle.removePhaseListener(this);
                        }
                    }
                }

                public PhaseId getPhaseId() {
                    return PhaseId.RENDER;
                }
            });
            adapter.setExecutePending(true);
        }
    }

    private static String registerHtml(String html) throws IOException {
        String name = BrowserLCA.createUrlFromHtml(html);
        byte[] bytes = html.getBytes("UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ResourceManager resourceManager = RWT.getResourceManager();
        resourceManager.register(name, inputStream);
        return resourceManager.getLocation(name);
    }

    private static String createUrlFromHtml(String html) {
        StringBuilder result = new StringBuilder();
        result.append("org.eclipse.swt.browser/text");
        result.append(String.valueOf(html.hashCode()));
        result.append(".html");
        return result.toString();
    }

    private static String getText(Browser browser) {
        IBrowserAdapter adapter;
        IBrowserAdapter browserAdapter = adapter = browser.getAdapter(IBrowserAdapter.class);
        return browserAdapter.getText();
    }

    private static void createBrowserFunctions(Browser browser) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        String id = WidgetUtil.getId(browser);
        String[] functions = (String[])serviceStore.getAttribute(String.valueOf(FUNCTIONS_TO_CREATE) + id);
        if (functions != null) {
            JsonObject parameters = new JsonObject().add(PARAM_FUNCTIONS, JsonUtil.createJsonArray(functions));
            ClientObjectFactory.getClientObject(browser).call(METHOD_CREATE_FUNCTIONS, parameters);
        }
    }

    private static void destroyBrowserFunctions(Browser browser) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        String id = WidgetUtil.getId(browser);
        String[] functions = (String[])serviceStore.getAttribute(String.valueOf(FUNCTIONS_TO_DESTROY) + id);
        if (functions != null) {
            JsonObject parameters = new JsonObject().add(PARAM_FUNCTIONS, JsonUtil.createJsonArray(functions));
            ClientObjectFactory.getClientObject(browser).call(METHOD_DESTROY_FUNCTIONS, parameters);
        }
    }

    private static void executeFunction(final Browser browser) {
        String function = WidgetLCAUtil.readPropertyValue(browser, PARAM_EXECUTE_FUNCTION);
        JsonValue value = ProtocolUtil.readPropertyValue(WidgetUtil.getId(browser), PARAM_EXECUTE_ARGUMENTS);
        final Object[] arguments = (Object[])JsonUtil.jsonToJava(value);
        if (function != null) {
            IBrowserAdapter adapter = browser.getAdapter(IBrowserAdapter.class);
            BrowserFunction[] functions = adapter.getBrowserFunctions();
            boolean found = false;
            int i = 0;
            while (i < functions.length && !found) {
                final BrowserFunction current = functions[i];
                if (current.getName().equals(function)) {
                    ProcessActionRunner.add(new Runnable(){

                        public void run() {
                            try {
                                Object executedFunctionResult = current.function(arguments);
                                BrowserLCA.setExecutedFunctionResult(browser, executedFunctionResult);
                            }
                            catch (Exception e) {
                                BrowserLCA.setExecutedFunctionError(browser, e.getMessage());
                            }
                            BrowserLCA.setExecutedFunctionName(browser, current.getName());
                        }
                    });
                    found = true;
                }
                ++i;
            }
        }
    }

    private static void renderFunctionResult(Browser browser) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        String id = WidgetUtil.getId(browser);
        String name = (String)serviceStore.getAttribute(String.valueOf(EXECUTED_FUNCTION_NAME) + id);
        if (name != null) {
            Object result = serviceStore.getAttribute(String.valueOf(EXECUTED_FUNCTION_RESULT) + id);
            String error = (String)serviceStore.getAttribute(String.valueOf(EXECUTED_FUNCTION_ERROR) + id);
            Object[] value = new Object[]{name, result, error};
            ClientObjectFactory.getClientObject(browser).set(PARAM_FUNCTION_RESULT, JsonUtil.createJsonArray(value));
        }
    }

    private static void setExecutedFunctionName(Browser browser, String name) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(EXECUTED_FUNCTION_NAME) + WidgetUtil.getId(browser), name);
    }

    private static void setExecutedFunctionResult(Browser browser, Object result) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(EXECUTED_FUNCTION_RESULT) + WidgetUtil.getId(browser), result);
    }

    private static void setExecutedFunctionError(Browser browser, String error) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(EXECUTED_FUNCTION_ERROR) + WidgetUtil.getId(browser), error);
    }

    private boolean hasProgressListener(Browser browser) {
        return EventLCAUtil.isListening(browser, 5021) || EventLCAUtil.isListening(browser, 5022);
    }
}

