/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientMessage {
    public static final String PROP_HEAD = "head";
    public static final String PROP_OPERATIONS = "operations";
    public static final String OPERATION_SET = "set";
    public static final String OPERATION_NOTIFY = "notify";
    public static final String OPERATION_CALL = "call";
    private final JsonObject message;
    private final JsonObject head;
    private final HashMap<String, List<Operation>> operationsMap;
    private final List<Operation> operationsList;

    public ClientMessage(JsonObject json) {
        JsonArray operations;
        ParamCheck.notNull(json, "json");
        this.message = json;
        try {
            this.head = this.message.get(PROP_HEAD).asObject();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Missing header object: " + json);
        }
        try {
            operations = this.message.get(PROP_OPERATIONS).asArray();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Missing operations array: " + json);
        }
        try {
            this.operationsMap = new HashMap();
            this.operationsList = new ArrayList<Operation>();
            this.processOperations(operations);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new IllegalArgumentException("Invalid operations array: " + json);
        }
    }

    public JsonValue getHeader(String key) {
        return this.head.get(key);
    }

    public List<Operation> getAllOperations() {
        return Collections.unmodifiableList(this.operationsList);
    }

    public List<Operation> getAllOperationsFor(String target) {
        List<Operation> operations = this.operationsMap.get(target);
        if (operations == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(operations);
    }

    public List<CallOperation> getAllCallOperationsFor(String target, String methodName) {
        List<Operation> operations;
        ArrayList<CallOperation> result = new ArrayList<CallOperation>();
        List<Operation> list = operations = target == null ? this.operationsList : this.operationsMap.get(target);
        if (operations != null) {
            for (Operation operation : operations) {
                if (!(operation instanceof CallOperation)) continue;
                CallOperation currentOperation = (CallOperation)operation;
                if (methodName != null && !currentOperation.getMethodName().equals(methodName)) continue;
                result.add(currentOperation);
            }
        }
        return result;
    }

    public SetOperation getLastSetOperationFor(String target, String property) {
        List<Operation> operations;
        SetOperation result = null;
        List<Operation> list = operations = target == null ? this.operationsList : this.operationsMap.get(target);
        if (operations != null) {
            for (Operation operation : operations) {
                if (!(operation instanceof SetOperation)) continue;
                SetOperation currentOperation = (SetOperation)operation;
                if (property != null && !operation.getPropertyNames().contains(property)) continue;
                result = currentOperation;
            }
        }
        return result;
    }

    public NotifyOperation getLastNotifyOperationFor(String target, String eventName) {
        List<Operation> operations;
        NotifyOperation result = null;
        List<Operation> list = operations = target == null ? this.operationsList : this.operationsMap.get(target);
        if (operations != null) {
            for (Operation operation : operations) {
                if (!(operation instanceof NotifyOperation)) continue;
                NotifyOperation currentOperation = (NotifyOperation)operation;
                if (eventName != null && !currentOperation.getEventName().equals(eventName)) continue;
                result = currentOperation;
            }
        }
        return result;
    }

    public String toString() {
        return this.message.toString();
    }

    private void processOperations(JsonArray operations) {
        int i = 0;
        while (i < operations.size()) {
            Operation operation = this.createOperation(operations.get(i).asArray());
            this.appendOperation(operation);
            ++i;
        }
    }

    private Operation createOperation(JsonArray data) {
        Operation result = null;
        String action = this.getOperationAction(data);
        if (action.equals(OPERATION_SET)) {
            result = new SetOperation(data);
        } else if (action.equals(OPERATION_NOTIFY)) {
            result = new NotifyOperation(data);
        } else if (action.equals(OPERATION_CALL)) {
            result = new CallOperation(data);
        } else {
            throw new IllegalArgumentException("Unknown operation action: " + action);
        }
        return result;
    }

    private void appendOperation(Operation operation) {
        String target = operation.getTarget();
        List<Operation> targetOperations = this.operationsMap.get(target);
        if (targetOperations == null) {
            targetOperations = new ArrayList<Operation>();
        }
        targetOperations.add(operation);
        this.operationsMap.put(target, targetOperations);
        this.operationsList.add(operation);
    }

    private String getOperationAction(JsonArray operation) {
        String result;
        try {
            result = operation.get(0).asString();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find action for operation " + operation);
        }
        return result;
    }

    public final class CallOperation
    extends Operation {
        private final String methodName;
        private final JsonObject properties;

        private CallOperation(JsonArray operation) {
            super(operation);
            try {
                this.methodName = operation.get(2).asString();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Method name missing in operation", e);
            }
            try {
                this.properties = operation.get(3).asObject();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Properties object missing in operation", e);
            }
        }

        public String getMethodName() {
            return this.methodName;
        }

        public JsonObject getProperties() {
            return this.properties;
        }
    }

    public final class NotifyOperation
    extends Operation {
        private final String eventName;
        private final JsonObject properties;

        private NotifyOperation(JsonArray operation) {
            super(operation);
            try {
                this.eventName = operation.get(2).asString();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Event type missing in operation", e);
            }
            try {
                this.properties = operation.get(3).asObject();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Properties object missing in operation", e);
            }
        }

        public String getEventName() {
            return this.eventName;
        }

        public JsonObject getProperties() {
            return this.properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Operation {
        private final String target;

        private Operation(JsonArray operation) {
            try {
                this.target = operation.get(1).asString();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid operation target", e);
            }
        }

        public String getTarget() {
            return this.target;
        }

        public List<String> getPropertyNames() {
            return this.getProperties().names();
        }

        public JsonValue getProperty(String key) {
            return this.getProperties().get(key);
        }

        public abstract JsonObject getProperties();
    }

    public final class SetOperation
    extends Operation {
        private final JsonObject properties;

        private SetOperation(JsonArray operation) {
            super(operation);
            try {
                this.properties = operation.get(2).asObject();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Properties object missing in operation", e);
            }
        }

        public JsonObject getProperties() {
            return this.properties;
        }
    }
}

