/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.examples.pages.internal.ImageUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class InputExamplePage
implements IExamplePage {
    protected Image errorImage;
    protected Image warningImage;

    public void createControl(Composite parent) {
        this.createImages();
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)2));
        Composite upperWestSide = this.createPart(parent);
        Composite upperEastSide = this.createPart(parent);
        Composite lowerWestSide = this.createPart(parent);
        Composite lowerEastSide = this.createPart(parent);
        this.createInputForm(upperWestSide);
        this.createControlDecoratorsForm(upperEastSide);
        this.createMultiline(upperEastSide);
        this.createPushButtons(lowerWestSide);
        this.createRadioAndCheckButtons(lowerEastSide);
    }

    private void createImages() {
        this.errorImage = InputExamplePage.getDecorationImage("DEC_ERROR");
        this.warningImage = InputExamplePage.getDecorationImage("DEC_WARNING");
    }

    private Composite createPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        return composite;
    }

    private void createInputForm(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)composite, (String)"Simple Input Widgets", (int)2);
        final Text firstNameText = this.createFirstNameField(composite);
        final Text lastNameText = this.createLastNameField(composite);
        final Text passwordText = this.createPasswordField(composite);
        final Spinner spinner = this.createSpinner(composite);
        final Combo countryCombo = this.createCountryCombo(composite);
        final Combo classCombo = this.createReadOnlyCombo(composite);
        final DateTime dateTime = this.createDateField(composite);
        final Button enabledCheckbox = new Button(composite, 32);
        enabledCheckbox.setText("Enabled");
        enabledCheckbox.setSelection(true);
        enabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editable = enabledCheckbox.getSelection();
                firstNameText.setEnabled(editable);
                lastNameText.setEnabled(editable);
                passwordText.setEnabled(editable);
                spinner.setEnabled(editable);
                countryCombo.setEnabled(editable);
                classCombo.setEnabled(editable);
                dateTime.setEnabled(editable);
            }
        });
    }

    private void createControlDecoratorsForm(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)composite, (String)"Control Decorators", (int)2);
        this.createVerifiedText(composite);
        this.createMandatoryText(composite);
    }

    private void createVerifiedText(Composite formComp) {
        new Label(formComp, 0).setText("Digits Only:");
        final Text text = new Text(formComp, 2052);
        GridData gridData1 = ExampleUtil.createHorzFillData();
        gridData1.minimumWidth = 250;
        text.setLayoutData((Object)gridData1);
        final ControlDecoration decoration = new ControlDecoration((Control)text, 16512);
        decoration.setImage(this.errorImage);
        decoration.hide();
        text.setText("4711");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String content = text.getText();
                if (!InputExamplePage.isNumbers(content)) {
                    text.setBackground(new Color((Device)text.getDisplay(), 250, 200, 150));
                    decoration.show();
                    decoration.setDescriptionText("Illegal content: " + content);
                } else {
                    text.setBackground(null);
                    decoration.hide();
                }
            }
        });
    }

    private void createMandatoryText(Composite formComp) {
        new Label(formComp, 0).setText("Mandatory:");
        final Text text = new Text(formComp, 2052);
        GridData gridData1 = ExampleUtil.createHorzFillData();
        gridData1.minimumWidth = 250;
        text.setLayoutData((Object)gridData1);
        final ControlDecoration decoration = new ControlDecoration((Control)text, 16512);
        decoration.setImage(this.warningImage);
        decoration.hide();
        final Color mandatoryColor = new Color((Device)text.getDisplay(), 200, 200, 250);
        text.setText("foo");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String content = text.getText();
                if (content.trim().length() == 0) {
                    text.setBackground(mandatoryColor);
                    decoration.show();
                    decoration.setDescriptionText("This field is mandatory");
                } else {
                    text.setBackground(null);
                    decoration.hide();
                }
            }
        });
    }

    private Text createFirstNameField(Composite formComp) {
        new Label(formComp, 0).setText("First Name:");
        Text firstNameText = new Text(formComp, 2052);
        GridData gridData1 = ExampleUtil.createHorzFillData();
        gridData1.minimumWidth = 250;
        firstNameText.setLayoutData((Object)gridData1);
        return firstNameText;
    }

    private Text createLastNameField(Composite formComp) {
        new Label(formComp, 0).setText("Last Name:");
        Text lastNameText = new Text(formComp, 2052);
        GridData gridData2 = ExampleUtil.createHorzFillData();
        lastNameText.setLayoutData((Object)gridData2);
        return lastNameText;
    }

    private Text createPasswordField(Composite formComp) {
        new Label(formComp, 0).setText("Passphrase:");
        Text passwordText = new Text(formComp, 0x400800);
        GridData gridData3 = ExampleUtil.createHorzFillData();
        passwordText.setLayoutData((Object)gridData3);
        passwordText.setText("Password");
        return passwordText;
    }

    private Spinner createSpinner(Composite formComp) {
        new Label(formComp, 0).setText("Age:");
        Spinner spinner = new Spinner(formComp, 2048);
        GridData gridData4 = ExampleUtil.createHorzFillData();
        spinner.setLayoutData((Object)gridData4);
        spinner.setSelection(23);
        return spinner;
    }

    private Combo createCountryCombo(Composite formComp) {
        new Label(formComp, 0).setText("Country:");
        Combo combo = new Combo(formComp, 2048);
        String[] countries = new String[]{"Germany", "Canada", "USA", "Bulgaria"};
        combo.setItems(countries);
        GridData gridData = ExampleUtil.createHorzFillData();
        combo.setLayoutData((Object)gridData);
        combo.select(0);
        return combo;
    }

    private Combo createReadOnlyCombo(Composite formComp) {
        new Label(formComp, 0).setText("Class:");
        Combo classCombo = new Combo(formComp, 2056);
        String[] classes = new String[]{"Business", "Economy", "Economy Plus"};
        classCombo.setItems(classes);
        GridData gridData = ExampleUtil.createHorzFillData();
        classCombo.setLayoutData((Object)gridData);
        classCombo.select(0);
        return classCombo;
    }

    private DateTime createDateField(Composite formComp) {
        new Label(formComp, 0).setText("Date:");
        int dateTimeStyle = 2056;
        DateTime dateTime = new DateTime(formComp, dateTimeStyle);
        return dateTime;
    }

    private void createMultiline(Composite parent) {
        Composite multiComp = new Composite(parent, 0);
        ExampleUtil.createHeading((Composite)multiComp, (String)"Multiline Texts", (int)2);
        multiComp.setLayoutData((Object)ExampleUtil.createHorzFillData());
        multiComp.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)true));
        String text = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. ";
        text = String.valueOf(text) + text;
        new Label(multiComp, 0).setText("This text box wraps:");
        int wrapStyle = 2626;
        Text wrapText = new Text(multiComp, wrapStyle);
        wrapText.setText(text);
        GridData wrapTextData = ExampleUtil.createFillData();
        wrapTextData.minimumHeight = 50;
        wrapText.setLayoutData((Object)wrapTextData);
        new Label(multiComp, 0).setText("And this one doesn't:");
        int nowrapStyle = 2818;
        Text nowrapText = new Text(multiComp, nowrapStyle);
        nowrapText.setText(text);
        GridData nowrapData = ExampleUtil.createFillData();
        nowrapData.minimumHeight = 50;
        nowrapText.setLayoutData((Object)nowrapData);
    }

    private void createPushButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        ExampleUtil.createHeading((Composite)composite, (String)"Push and Toggle Buttons", (int)2);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        Composite compositeL1 = new Composite(composite, 0);
        compositeL1.setLayout((Layout)InputExamplePage.createRowLayout(256));
        Composite compositeR = new Composite(composite, 0);
        compositeR.setLayout((Layout)new FillLayout());
        Composite compositeL2 = new Composite(composite, 0);
        compositeL2.setLayout((Layout)InputExamplePage.createRowLayout(256));
        GridData rData = new GridData(128, 131072, true, false);
        rData.verticalSpan = 2;
        compositeR.setLayoutData((Object)rData);
        Button button = new Button(compositeL1, 8);
        button.setText("Cancel");
        Button button1 = new Button(compositeL1, 8);
        button1.setText("Add");
        Display display = parent.getDisplay();
        Image imgAdd = ImageUtil.getImage((Device)display, "add_obj.gif");
        button1.setImage(imgAdd);
        Button button2 = new Button(compositeL1, 8);
        button2.setText("Delete");
        Image imgDelete = ImageUtil.getImage((Device)display, "delete_obj.gif");
        button2.setImage(imgDelete);
        Button button3 = new Button(compositeR, 8);
        Image imageDownload = ImageUtil.getImage((Device)display, "go-bottom.png");
        button3.setImage(imageDownload);
        button3.setToolTipText("Download");
        Button toggle1 = new Button(compositeL2, 2);
        Image imgSynced = ImageUtil.getImage((Device)display, "synced.gif");
        toggle1.setImage(imgSynced);
        toggle1.setToolTipText("Keep in sync");
        final Button toggle2 = new Button(compositeL2, 16386);
        toggle2.setText("Unlocked");
        final Image imgLocked = ImageUtil.getImage((Device)display, "lockedstate.gif");
        final Image imgUnlocked = ImageUtil.getImage((Device)display, "unlockedstate.gif");
        toggle2.setImage(imgUnlocked);
        toggle2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = toggle2.getSelection();
                toggle2.setText(selected ? "Locked" : "Unlocked");
                toggle2.setImage(selected ? imgLocked : imgUnlocked);
            }
        });
    }

    private void createRadioAndCheckButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        ExampleUtil.createHeading((Composite)composite, (String)"Checkboxes and Radiobuttons", (int)2);
        Composite radioComp = new Composite(composite, 0);
        radioComp.setLayoutData((Object)new GridData(4, 128, true, false));
        RowLayout radioLayout = InputExamplePage.createRowLayout(512);
        radioComp.setLayout((Layout)radioLayout);
        Button radio1 = new Button(radioComp, 16);
        radio1.setText("Salami");
        radio1.setSelection(true);
        Button radio2 = new Button(radioComp, 16);
        radio2.setText("Funghi");
        Button radio3 = new Button(radioComp, 16);
        radio3.setText("Calzone");
        Composite checkComp = new Composite(composite, 0);
        checkComp.setLayoutData((Object)new GridData(4, 128, true, false));
        RowLayout checkLayout = InputExamplePage.createRowLayout(512);
        checkComp.setLayout((Layout)checkLayout);
        Button check1 = new Button(checkComp, 32);
        check1.setText("Extra Cheese");
        Button check2 = new Button(checkComp, 32);
        check2.setText("Extra Hot");
        Button check3 = new Button(checkComp, 32);
        check3.setText("King Size");
        check3.setSelection(true);
    }

    private static boolean isNumbers(String content) {
        int length = content.length();
        int i = 0;
        while (i < length) {
            char ch = content.charAt(i);
            if (!Character.isDigit(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static RowLayout createRowLayout(int style) {
        RowLayout layout = new RowLayout(style);
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        layout.spacing = 10;
        layout.fill = true;
        layout.wrap = false;
        return layout;
    }

    private static Image getDecorationImage(String id) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration decoration = registry.getFieldDecoration(id);
        return decoration.getImage();
    }
}

