/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ControlDecorationTab
extends ExampleTab {
    private static final String PROP_SELECTION_LISTENER = "selectionListener";
    private boolean showOnlyOnFocus;
    private boolean showHover = true;
    private String description = "Description";
    private final ControlDecoration[] decorations = new ControlDecoration[2];
    private final SelectionListener listener = new LoggingSelectionListener();

    public ControlDecorationTab() {
        super("ControlDecoration");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("TOP", 128);
        this.createStyleButton("BOTTOM", 1024);
        this.createStyleButton("LEFT", 16384);
        this.createStyleButton("RIGHT", 131072);
        this.createChangeDescriptionButton(parent);
        this.createShowOnlyOnFocus(parent);
        this.createShowHover(parent);
        this.createPropertyCheckbox("Add Selection Listener", PROP_SELECTION_LISTENER);
    }

    protected void createExampleControls(Composite parent) {
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.horizontalSpacing = 10;
        groupLayout.marginRight = 10;
        parent.setLayout((Layout)groupLayout);
        this.decorations[0] = this.createStaticExample(parent);
        this.decorations[1] = this.createDynamicExample(parent);
        this.configureDecorations();
    }

    private ControlDecoration createStaticExample(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Static decoration: ");
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.widthHint = 100;
        text.setLayoutData((Object)data);
        text.setText("some text");
        ControlDecoration staticDecoration = new ControlDecoration((Control)text, this.getStyle());
        Image icon = ControlDecorationTab.getDecorationImage("DEC_INFORMATION");
        staticDecoration.setImage(icon);
        staticDecoration.setMarginWidth(3);
        staticDecoration.show();
        return staticDecoration;
    }

    private ControlDecoration createDynamicExample(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Dynamic decoration: ");
        final Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.widthHint = 100;
        text.setLayoutData((Object)data);
        text.setText("remove me");
        final ControlDecoration dynDecoration = new ControlDecoration((Control)text, this.getStyle());
        Image icon = ControlDecorationTab.getDecorationImage("DEC_ERROR");
        dynDecoration.setImage(icon);
        dynDecoration.setMarginWidth(3);
        dynDecoration.hide();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (text.getText().length() > 0) {
                    dynDecoration.hide();
                } else {
                    dynDecoration.show();
                }
            }
        });
        return dynDecoration;
    }

    private void createChangeDescriptionButton(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(group, 0);
        label.setText("Description text: ");
        final Text descriptionText = new Text(group, 2052);
        GridData data = new GridData();
        data.widthHint = 100;
        descriptionText.setLayoutData((Object)data);
        descriptionText.setText(this.description);
        Button button = new Button(group, 8);
        button.setText("Set");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ControlDecorationTab.this.description = descriptionText.getText();
                ControlDecorationTab.this.configureDecorations();
            }
        });
    }

    private void createShowOnlyOnFocus(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Show only on focus");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ControlDecorationTab.this.showOnlyOnFocus = button.getSelection();
                ControlDecorationTab.this.configureDecorations();
            }
        });
    }

    private void createShowHover(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Show hover");
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ControlDecorationTab.this.showHover = button.getSelection();
                ControlDecorationTab.this.configureDecorations();
            }
        });
    }

    private void configureDecorations() {
        this.configureDecoration(this.decorations[0]);
        this.configureDecoration(this.decorations[1]);
    }

    private void configureDecoration(ControlDecoration decoration) {
        decoration.setShowHover(this.showHover);
        decoration.setShowOnlyOnFocus(this.showOnlyOnFocus);
        decoration.setDescriptionText(this.description);
        if (this.hasCreateProperty(PROP_SELECTION_LISTENER)) {
            decoration.addSelectionListener(this.listener);
        } else {
            decoration.removeSelectionListener(this.listener);
        }
    }

    private static Image getDecorationImage(String image) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        return registry.getFieldDecoration(image).getImage();
    }

    private final class LoggingSelectionListener
    implements SelectionListener {
        private LoggingSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            ControlDecorationTab.this.log("widgetSelected: " + event.toString());
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            ControlDecorationTab.this.log("widgetDefaultSelected: " + event.toString());
        }
    }
}

