/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.model;

import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeValue;

public class CorruptValue
implements NativeValue {
    private static final long serialVersionUID = 8829067881854394802L;
    private final byte[] data;
    private volatile ValueStoreRevision revision;
    private volatile int internalID;

    public CorruptValue(ValueStoreRevision revision, int internalID, byte[] data) {
        this.setInternalID(internalID, revision);
        this.data = data;
    }

    @Override
    public void setInternalID(int internalID, ValueStoreRevision revision) {
        this.internalID = internalID;
        this.revision = revision;
    }

    @Override
    public ValueStoreRevision getValueStoreRevision() {
        return this.revision;
    }

    @Override
    public int getInternalID() {
        return this.internalID;
    }

    public String stringValue() {
        return "CorruptValue_with_ID_" + this.internalID;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CorruptValue && this.internalID != -1) {
            CorruptValue otherCorruptValue = (CorruptValue)o;
            if (otherCorruptValue.internalID != -1 && this.revision.equals(otherCorruptValue.revision)) {
                return this.internalID == otherCorruptValue.internalID;
            }
        }
        return super.equals(o);
    }

    static byte[] truncateData(byte[] data) {
        int j;
        int offset = data.length - 1;
        int limit = data.length;
        for (j = 0; j < data.length; ++j) {
            if (data[j] == 0) continue;
            offset = j;
            break;
        }
        j = offset;
        while (j + 2 < data.length) {
            if (data[j] == 0 && data[j + 1] == 0 && data[j + 2] == 0) {
                limit = j;
                break;
            }
            ++j;
        }
        byte[] truncated = new byte[limit - offset];
        System.arraycopy(data, offset, truncated, 0, limit - offset);
        data = truncated;
        if (data.length > 2048) {
            truncated = new byte[2048];
            System.arraycopy(data, 0, truncated, 0, 2048);
            data = truncated;
        }
        return data;
    }
}

