/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.rdf4j.common.concurrent.locks.StampedLongAdderLockManager;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.eclipse.rdf4j.sail.lmdb.Pool;
import org.eclipse.rdf4j.sail.lmdb.RecordIterator;
import org.eclipse.rdf4j.sail.lmdb.TripleStore;
import org.eclipse.rdf4j.sail.lmdb.TxnManager;
import org.eclipse.rdf4j.sail.lmdb.util.GroupMatcher;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBVal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LmdbRecordIterator
implements RecordIterator {
    private static final Logger log = LoggerFactory.getLogger(LmdbRecordIterator.class);
    private final Pool pool;
    private final TripleStore.TripleIndex index;
    private final long subj;
    private final long pred;
    private final long obj;
    private final long context;
    private final long cursor;
    private final MDBVal maxKey;
    private final boolean matchValues;
    private GroupMatcher groupMatcher;
    private final TxnManager.Txn txnRef;
    private long txnRefVersion;
    private final long txn;
    private final int dbi;
    private volatile boolean closed = false;
    private final MDBVal keyData;
    private final MDBVal valueData;
    private ByteBuffer minKeyBuf;
    private ByteBuffer maxKeyBuf;
    private int lastResult;
    private final long[] quad;
    private final long[] originalQuad;
    private boolean fetchNext = false;
    private final StampedLongAdderLockManager txnLockManager;
    private final Thread ownerThread = Thread.currentThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LmdbRecordIterator(TripleStore.TripleIndex index, boolean rangeSearch, long subj, long pred, long obj, long context, boolean explicit, TxnManager.Txn txnRef) throws IOException {
        long readStamp;
        this.subj = subj;
        this.pred = pred;
        this.obj = obj;
        this.context = context;
        this.originalQuad = new long[]{subj, pred, obj, context};
        this.quad = new long[]{subj, pred, obj, context};
        this.pool = Pool.get();
        this.keyData = this.pool.getVal();
        this.valueData = this.pool.getVal();
        this.index = index;
        if (rangeSearch) {
            this.minKeyBuf = this.pool.getKeyBuffer();
            index.getMinKey(this.minKeyBuf, subj, pred, obj, context);
            this.minKeyBuf.flip();
            this.maxKey = this.pool.getVal();
            this.maxKeyBuf = this.pool.getKeyBuffer();
            index.getMaxKey(this.maxKeyBuf, subj, pred, obj, context);
            this.maxKeyBuf.flip();
            this.maxKey.mv_data(this.maxKeyBuf);
        } else {
            this.minKeyBuf = null;
            this.maxKey = null;
        }
        this.matchValues = subj > 0L || pred > 0L || obj > 0L || context >= 0L;
        this.dbi = index.getDB(explicit);
        this.txnRef = txnRef;
        this.txnLockManager = txnRef.lockManager();
        try {
            readStamp = this.txnLockManager.readLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
        try {
            this.txnRefVersion = txnRef.version();
            this.txn = txnRef.get();
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                LmdbUtil.E(LMDB.mdb_cursor_open((long)this.txn, (int)this.dbi, (PointerBuffer)pp));
                this.cursor = pp.get(0);
            }
        }
        finally {
            this.txnLockManager.unlockRead(readStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] next() {
        long readStamp;
        try {
            readStamp = this.txnLockManager.readLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
        try {
            if (this.closed) {
                log.debug("Calling next() on an LmdbRecordIterator that is already closed, returning null");
                long[] lArray = null;
                return lArray;
            }
            if (this.txnRefVersion != this.txnRef.version()) {
                LMDB.mdb_cursor_renew((long)this.txn, (long)this.cursor);
                if (this.fetchNext) {
                    if (this.minKeyBuf == null) {
                        this.minKeyBuf = this.pool.getKeyBuffer();
                    }
                    this.minKeyBuf.clear();
                    this.index.toKey(this.minKeyBuf, this.quad[0], this.quad[1], this.quad[2], this.quad[3]);
                    this.minKeyBuf.flip();
                    this.keyData.mv_data(this.minKeyBuf);
                    this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)15);
                    if (this.lastResult != 0) {
                        this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17);
                    }
                    if (this.lastResult != 0) {
                        this.closeInternal(false);
                        long[] lArray = null;
                        return lArray;
                    }
                }
                this.txnRefVersion = this.txnRef.version();
            }
            if (this.fetchNext) {
                this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8);
                this.fetchNext = false;
            } else if (this.minKeyBuf != null) {
                this.keyData.mv_data(this.minKeyBuf);
                this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)17);
            } else {
                this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8);
            }
            while (this.lastResult == 0) {
                if (this.maxKey != null && LMDB.mdb_cmp((long)this.txn, (int)this.dbi, (MDBVal)this.keyData, (MDBVal)this.maxKey) > 0) {
                    this.lastResult = -30798;
                    continue;
                }
                if (this.matches()) {
                    this.lastResult = LMDB.mdb_cursor_get((long)this.cursor, (MDBVal)this.keyData, (MDBVal)this.valueData, (int)8);
                    continue;
                }
                this.index.keyToQuad(this.keyData.mv_data(), this.originalQuad, this.quad);
                this.fetchNext = true;
                long[] lArray = this.quad;
                return lArray;
            }
            this.closeInternal(false);
            long[] lArray = null;
            return lArray;
        }
        finally {
            this.txnLockManager.unlockRead(readStamp);
        }
    }

    private boolean matches() {
        if (this.groupMatcher != null) {
            return !this.groupMatcher.matches(this.keyData.mv_data());
        }
        if (this.matchValues) {
            this.groupMatcher = this.index.createMatcher(this.subj, this.pred, this.obj, this.context);
            return !this.groupMatcher.matches(this.keyData.mv_data());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean maybeCalledAsync) {
        if (!this.closed) {
            long writeStamp = 0L;
            boolean writeLocked = false;
            if (maybeCalledAsync && this.ownerThread != Thread.currentThread()) {
                try {
                    writeStamp = this.txnLockManager.writeLock();
                    writeLocked = true;
                }
                catch (InterruptedException e) {
                    throw new SailException(e);
                }
            }
            try {
                if (!this.closed) {
                    LMDB.mdb_cursor_close((long)this.cursor);
                    this.pool.free(this.keyData);
                    this.pool.free(this.valueData);
                    if (this.minKeyBuf != null) {
                        this.pool.free(this.minKeyBuf);
                    }
                    if (this.maxKey != null) {
                        this.pool.free(this.maxKeyBuf);
                        this.pool.free(this.maxKey);
                    }
                }
            }
            finally {
                this.closed = true;
                if (writeLocked) {
                    this.txnLockManager.unlockWrite(writeStamp);
                }
            }
        }
    }

    @Override
    public void close() {
        this.closeInternal(true);
    }
}

