/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.config;

import java.util.Optional;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.sail.config.SailRepositorySchema;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailConfigSchema;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.config.SailRegistry;

public class SailRepositoryConfig
extends AbstractRepositoryImplConfig {
    private SailImplConfig sailImplConfig;

    public SailRepositoryConfig() {
        super("openrdf:SailRepository");
    }

    public SailRepositoryConfig(SailImplConfig sailImplConfig) {
        this();
        this.setSailImplConfig(sailImplConfig);
    }

    public SailImplConfig getSailImplConfig() {
        return this.sailImplConfig;
    }

    public void setSailImplConfig(SailImplConfig sailImplConfig) {
        this.sailImplConfig = sailImplConfig;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.sailImplConfig == null) {
            throw new RepositoryConfigException("No Sail implementation specified for Sail repository");
        }
        try {
            this.sailImplConfig.validate();
        }
        catch (SailConfigException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }

    @Override
    public Resource export(Model model) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(model);
        }
        Resource repImplNode = super.export(model);
        if (this.sailImplConfig != null) {
            model.setNamespace(CONFIG.NS);
            Resource sailImplNode = this.sailImplConfig.export(model);
            model.add(repImplNode, CONFIG.Sail.impl, sailImplNode, new Resource[0]);
        }
        return repImplNode;
    }

    private Resource exportLegacy(Model model) {
        Resource repImplNode = super.export(model);
        if (this.sailImplConfig != null) {
            model.setNamespace("sr", "http://www.openrdf.org/config/repository/sail#");
            Resource sailImplNode = this.sailImplConfig.export(model);
            model.add(repImplNode, SailRepositorySchema.SAILIMPL, sailImplNode, new Resource[0]);
        }
        return repImplNode;
    }

    @Override
    public void parse(Model model, Resource repImplNode) throws RepositoryConfigException {
        try {
            Optional<Resource> sailImplNode = Configurations.getResourceValue(model, repImplNode, CONFIG.Sail.impl, SailRepositorySchema.SAILIMPL);
            if (sailImplNode.isPresent()) {
                Configurations.getLiteralValue(model, sailImplNode.get(), CONFIG.Sail.type, SailConfigSchema.SAILTYPE).ifPresent(typeLit -> {
                    SailFactory factory = (SailFactory)SailRegistry.getInstance().get(typeLit.getLabel()).orElseThrow(() -> new RepositoryConfigException("Unsupported Sail type: " + typeLit.getLabel()));
                    this.sailImplConfig = factory.getConfig();
                    this.sailImplConfig.parse(model, (Resource)sailImplNode.get());
                });
            }
        }
        catch (ModelException | SailConfigException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

