/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.join.JoinExecutorBase;
import org.eclipse.rdf4j.federated.evaluation.join.ParallelLeftJoinTask;
import org.eclipse.rdf4j.federated.evaluation.join.PhaserHandlingParallelExecutor;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlledWorkerLeftJoin
extends JoinExecutorBase<BindingSet> {
    private static final Logger log = LoggerFactory.getLogger(ControlledWorkerLeftJoin.class);
    protected final ControlledWorkerScheduler<BindingSet> scheduler;
    protected final Phaser phaser = new Phaser(1);
    protected final LeftJoin join;

    public ControlledWorkerLeftJoin(ControlledWorkerScheduler<BindingSet> scheduler, FederationEvalStrategy strategy, CloseableIteration<BindingSet, QueryEvaluationException> leftIter, LeftJoin join, BindingSet bindings, QueryInfo queryInfo) throws QueryEvaluationException {
        super(strategy, leftIter, join.getRightArg(), bindings, queryInfo);
        this.scheduler = scheduler;
        this.join = join;
    }

    @Override
    protected void handleBindings() throws Exception {
        int totalBindings = 0;
        Phaser currentPhaser = this.phaser;
        while (!this.isClosed() && this.leftIter.hasNext()) {
            if (++totalBindings % 10000 == 0) {
                currentPhaser = new Phaser(currentPhaser);
            }
            ParallelLeftJoinTask task = new ParallelLeftJoinTask(new PhaserHandlingParallelExecutor(this, currentPhaser), this.strategy, this.join, (BindingSet)this.leftIter.next());
            currentPhaser.register();
            this.scheduler.schedule(task);
        }
        this.leftIter.close();
        this.scheduler.informFinish(this);
        if (log.isDebugEnabled()) {
            log.debug("JoinStats: left iter of " + this.getDisplayId() + " had " + totalBindings + " results.");
        }
        this.phaser.awaitAdvanceInterruptibly(this.phaser.arrive(), this.queryInfo.getMaxRemainingTimeMS(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.phaser.forceTermination();
        }
    }
}

