/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.internal;

import java.util.EnumSet;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.internal.HTTP3Session;
import org.eclipse.jetty.http3.internal.HTTP3Stream;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3StreamClient
extends HTTP3Stream
implements Stream.Client {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3StreamClient.class);
    private Stream.Client.Listener listener;

    public HTTP3StreamClient(HTTP3Session session, QuicStreamEndPoint endPoint, boolean local) {
        super(session, endPoint, local);
    }

    public Stream.Client.Listener getListener() {
        return this.listener;
    }

    public void onOpen() {
        this.notifyNewStream();
    }

    public void setListener(Stream.Client.Listener listener) {
        this.listener = listener;
    }

    public void onResponse(HeadersFrame frame) {
        MetaData.Response response = (MetaData.Response)frame.getMetaData();
        boolean valid = response.getStatus() == 100 ? this.validateAndUpdate(EnumSet.of(HTTP3Stream.FrameState.INITIAL), HTTP3Stream.FrameState.INFORMATIONAL) : (response.getStatus() == 103 ? this.validateAndUpdate(EnumSet.of(HTTP3Stream.FrameState.INITIAL, HTTP3Stream.FrameState.HEADER, HTTP3Stream.FrameState.INFORMATIONAL), HTTP3Stream.FrameState.INFORMATIONAL) : this.validateAndUpdate(EnumSet.of(HTTP3Stream.FrameState.INITIAL, HTTP3Stream.FrameState.INFORMATIONAL), HTTP3Stream.FrameState.HEADER));
        if (valid) {
            this.notIdle();
            this.notifyResponse(frame);
            this.updateClose(frame.isLast(), false);
        }
    }

    private void notifyNewStream() {
        Stream.Client.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onNewStream((Stream.Client)this);
            }
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    private void notifyResponse(HeadersFrame frame) {
        Stream.Client.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onResponse((Stream.Client)this, frame);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    protected void notifyDataAvailable() {
        Stream.Client.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onDataAvailable((Stream.Client)this);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    protected void notifyTrailer(HeadersFrame frame) {
        Stream.Client.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onTrailer((Stream.Client)this, frame);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    protected boolean notifyIdleTimeout(TimeoutException timeout) {
        Stream.Client.Listener listener = this.getListener();
        try {
            if (listener != null) {
                return listener.onIdleTimeout((Stream.Client)this, (Throwable)timeout);
            }
            return true;
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            return true;
        }
    }

    protected void notifyFailure(long error, Throwable failure) {
        Stream.Client.Listener listener = this.getListener();
        try {
            if (listener != null) {
                listener.onFailure((Stream.Client)this, error, failure);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }
}

