/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPPublicKeyStore;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPSignatureVerifier;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.internal.provisional.p2.repository.DefaultPGPPublicKeyService;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.impl.RequirementImpl;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.EclipseIniTask;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.RedirectionTask;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.VariableType;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.WorkerPool;
import org.eclipse.oomph.util.XMLUtil;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProductCatalogGenerator
implements IApplication {
    private static final String JAVA_VERSION_PREFIX = "addJvmArg(jvmArg:-Dosgi.requiredJavaVersion=";
    private static final String HTTPS_PACKAGES = "https://download.eclipse.org/technology/epp/packages";
    private static final String HTTPS_PACKAGES_STAGING = "https://download.eclipse.org/technology/epp/staging/repository";
    private static final String RELEASES = "https://download.eclipse.org/releases";
    private static final String STAGING = "https://download.eclipse.org/staging/";
    private static final String ICON_URL_PREFIX = "https://www.eclipse.org/downloads/images/";
    private static final URI PACKAGES_URI = URI.createURI((String)"https://www.eclipse.org/downloads/packages/release/");
    private static final URI ECLIPSE_PROJECT_URI = URI.createURI((String)"https://download.eclipse.org/eclipse/updates");
    private static final String ICON_DEFAULT = "https://www.eclipse.org/downloads/images/committers.png";
    private static final Map<String, String> ICONS = new HashMap<String, String>();
    private static final String ECLIPSE_PLATFORM_SDK_PRODUCT_IDE_ID = "org.eclipse.sdk.ide";
    private static final String ECLIPSE_PLATFORM_SDK_PRODUCT_ID = "eclipse.platform.sdk";
    private static final List<String> PRODUCT_IDS = Arrays.asList("epp.package.java", "epp.package.jee", "epp.package.cpp", "epp.package.embedcpp", "epp.package.php", "epp.package.committers", "epp.package.dsl", "epp.package.rcp", "epp.package.modeling", "epp.package.scout", "org.eclipse.platform.ide", "org.eclipse.sdk.ide", "epp.package.parallel", "epp.package.rust", "epp.package.javascript", "epp.package.testing", "epp.package.reporting", "epp.package.android", "epp.package.automotive");
    private static final List<String> OBSOELETE_MYLYN_FEATURES = Arrays.asList("org.eclipse.mylyn.builds.feature.group", "org.eclipse.mylyn.bugzilla_feature.feature.group", "org.eclipse.mylyn.context_feature.feature.group", "org.eclipse.mylyn.commons.activity.feature.group", "org.eclipse.mylyn.commons.feature.group", "org.eclipse.mylyn.commons.notifications.feature.group", "org.eclipse.mylyn.commons.repositories.feature.group", "org.eclipse.mylyn.commons.repositories.http.feature.group", "org.eclipse.mylyn.discovery.feature.group", "org.eclipse.mylyn_feature.feature.group", "org.eclipse.mylyn.git.feature.group", "org.eclipse.mylyn.hudson.feature.group", "org.eclipse.mylyn.commons.identity.feature.group", "org.eclipse.mylyn.ide_feature.feature.group", "org.eclipse.mylyn.java_feature.feature.group", "org.eclipse.mylyn.monitor.feature.group", "org.eclipse.mylyn.pde_feature.feature.group", "org.eclipse.mylyn.team_feature.feature.group", "org.eclipse.mylyn.versions.feature.group");
    private static final List<String> OBSOELETE_MYLYN_FEATURES2 = Arrays.asList("org.eclipse.mylyn.wikitext_feature.feature.group");
    private static final String ALL_PRODUCT_ID = "all";
    private static final List<String> SPECIAL_PRODUCT_IDS = Arrays.asList("org.eclipse.platform.ide");
    private static final Set<String> EXCLUDED_IDS = new HashSet<String>(Arrays.asList("epp.package.mobile"));
    private static final Pattern EPP_INSTALL_ROOTS_FILTER_PATTERN = Pattern.compile("\\((org\\.eclipse\\.epp\\.install\\.roots=true|\\|\\(epp\\.package\\.[^.]+\\.install\\.mode\\.root=true\\)\\(org\\.eclipse\\.equinox\\.p2\\.install\\.mode\\.root=true\\))\\)");
    private static final Pattern ARCH_OS_FILTER_PATTERN = Pattern.compile("\\(\\&\\(osgi\\.arch=([^)]+)\\)\\(osgi\\.os=([^)]+)\\)\\)");
    private static final Pattern ARCH_OS_WS_FILTER_PATTERN = Pattern.compile("\\(\\&\\(osgi\\.arch=([^)]+)\\)\\(osgi\\.os=([^)]+)\\)\\(osgi\\.ws=([^)]+)\\)\\)");
    private static final boolean IS_RANGE_NARROW = Boolean.FALSE;
    private static final String JUSTJ_JRES = "https://download.eclipse.org/justj/jres";
    private static final Set<Integer> EXCLUDED_NON_LTS_JUSTJ_VERSIONS = Set.of(Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(15), Integer.valueOf(16), Integer.valueOf(18), Integer.valueOf(19), Integer.valueOf(20), Integer.valueOf(22));
    private static final Pattern PUB = Pattern.compile("pub:([^:]+):.*");
    private static final List<String> OLD_SIGNED_ARTIFACTS = Arrays.asList("https://download.eclipse.org/releases/2022-09/202208051000/plugins/javax.servlet.jsp_2.2.0.v201112011158.jar", "https://download.eclipse.org/releases/2022-06/202206151000/plugins/com.google.inject.assistedinject_3.0.0.v201402270930.jar");
    private static final String BIRT_ALL_IN_ONE_PRODUCT_ID = "org.eclipse.birt.report.designer.all";
    private URI outputLocation;
    private String stagingTrain;
    private boolean stagingEPPLocationIsActual;
    private boolean latestReleased;
    private boolean stagingUseComposite;
    private boolean brandingNotification;
    private List<String> compositeTrains = new ArrayList<String>();
    private URI stagingEPPLocation;
    private URI stagingTrainLocation;
    private URI stagingEclipePlatformLocation;
    private URI eppSiteURI;
    private boolean fakeNextRelease;
    private boolean updateCertificates;
    private final Map<String, Map<URI, Map<String, URI>>> sites = new LinkedHashMap<String, Map<URI, Map<String, URI>>>();
    private final PGPPublicKeyService keyService = this.getKeyService();
    private final Map<String, PGPPublicKey> pgpKeys = new TreeMap<String, PGPPublicKey>();
    private final IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
    private final IArtifactRepositoryManager artifactManager = this.getArtifactRepositoryManager();
    private final Map<String, IMetadataRepository> eppMetaDataRepositories = new HashMap<String, IMetadataRepository>();
    private final Map<String, IMetadataRepository> platformMetaDataRepositories = new HashMap<String, IMetadataRepository>();
    private final Map<String, List<TrainAndVersion>> trainsAndVersions = new HashMap<String, List<TrainAndVersion>>();
    private final Map<String, String> labels = new HashMap<String, String>();
    private final Map<String, Product> products = new LinkedHashMap<String, Product>();
    private final Map<String, Set<IInstallableUnit>> patches = new TreeMap<String, Set<IInstallableUnit>>();
    private String emfRepositoryLocation;
    private final String[] TRAINS = this.getTrains();
    private URI eclipseBrandingNotificationURI;
    private URIConverter uriConverter;
    private Agent agent;

    public Object start(IApplicationContext context) throws Exception {
        System.out.println("user.home=" + System.getProperty("user.home"));
        this.uriConverter = SetupCoreUtil.createResourceSet().getURIConverter();
        String[] arguments = (String[])context.getArguments().get("application.args");
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                String option = arguments[i];
                if ("-outputLocation".equals(option)) {
                    this.outputLocation = URI.createURI((String)arguments[++i]);
                } else if ("-staging".equals(option)) {
                    this.stagingTrain = arguments[++i];
                    this.stagingEPPLocation = URI.createURI((String)arguments[++i]);
                    this.stagingTrainLocation = URI.createURI((String)arguments[++i]);
                    if (i + 1 < arguments.length && !arguments[i + 1].startsWith("-")) {
                        this.stagingEclipePlatformLocation = URI.createURI((String)arguments[++i]);
                    }
                } else if ("-actual".equals(option)) {
                    this.stagingEPPLocationIsActual = true;
                } else if ("-latestReleased".equals(option)) {
                    this.latestReleased = true;
                } else if ("-useComposite".equals(option)) {
                    if (i + 1 < arguments.length && Arrays.asList(this.getTrains()).contains(arguments[i + 1])) {
                        do {
                            this.compositeTrains.add(arguments[++i]);
                        } while (i + 1 < arguments.length && Arrays.asList(this.getTrains()).contains(arguments[i + 1]));
                    } else {
                        this.stagingUseComposite = true;
                    }
                } else if ("-patches".equals(option)) {
                    if (i + 1 < arguments.length && !arguments[i + 1].startsWith("-")) {
                        this.patches.put(arguments[++i], new TreeSet());
                    }
                } else if ("-brandingNotification".equals(option)) {
                    this.brandingNotification = true;
                } else if ("-siteURI".equals(option)) {
                    this.eppSiteURI = URI.createURI((String)arguments[++i]);
                } else if ("-fakeNextRelease".equals(option)) {
                    this.compositeTrains.add(this.getMostRecentTrain());
                    this.fakeNextRelease = true;
                } else if ("-updateCertificates".equals(option)) {
                    this.updateCertificates = true;
                }
                ++i;
            }
        }
        this.computePatches();
        this.eclipseBrandingNotificationURI = URI.createURI((String)("https://www.eclipse.org/sponsor/ide/?scope=${scope}&campaign=" + this.getMostRecentReleasedTrain()));
        ICONS.put("reporting", "https://www.eclipse.org/downloads/images/birt-icon_48x48.png");
        ICONS.put("cpp", "https://www.eclipse.org/downloads/images/cdt.png");
        ICONS.put("automotive", "https://www.eclipse.org/downloads/images/classic.jpg");
        ICONS.put("standard", ICON_DEFAULT);
        ICONS.put("committers", ICON_DEFAULT);
        ICONS.put("android", ICON_DEFAULT);
        ICONS.put("dsl", "https://www.eclipse.org/downloads/images/dsl-package_42.png");
        ICONS.put("java", "https://www.eclipse.org/downloads/images/java.png");
        ICONS.put("jee", "https://www.eclipse.org/downloads/images/javaee.png");
        ICONS.put("modeling", "https://www.eclipse.org/downloads/images/modeling.png");
        ICONS.put("parallel", "https://www.eclipse.org/downloads/images/parallel.png");
        ICONS.put("php", "https://www.eclipse.org/downloads/images/php.png");
        ICONS.put("rcp", "https://www.eclipse.org/downloads/images/rcp.png");
        ICONS.put("scout", "https://www.eclipse.org/downloads/images/scout.jpg");
        ICONS.put("testing", "https://www.eclipse.org/downloads/images/testing.png");
        ICONS.put("mobile", "https://www.eclipse.org/downloads/images/mobile.jpg");
        ICONS.put("rust", "https://www.eclipse.org/downloads/images/corrosion.png");
        this.generate();
        this.generateBIRT();
        return null;
    }

    private void generateBIRT() throws Exception {
        Product product = SetupFactory.eINSTANCE.createProduct();
        product.setName("birt");
        product.setLabel("Eclipse BIRT Report Designer All-In-One");
        product.setDescription("This package provides all the tools needed to build high-quality reports quickly and easily.");
        BaseUtil.setAnnotation((ModelElement)product, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"imageURI", (String)"https://raw.githubusercontent.com/eclipse-birt/birt/master/core/org.eclipse.birt.branding/images/p48.png");
        BaseUtil.setAnnotation((ModelElement)product, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"notificationTooltip", (String)("Sponsor the " + product.getLabel()));
        BaseUtil.setAnnotation((ModelElement)product, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"siteURI", (String)"https://eclipse-birt.github.io/birt-website/");
        for (String type : List.of("Release", "Milestone", "Nightly")) {
            Object name;
            URI repositoryLocation = URI.createURI((String)("https://download.eclipse.org/birt/updates/" + type.toLowerCase() + "/latest"));
            IMetadataRepository latestRepository = this.loadLatestRepository(this.manager, repositoryLocation, true);
            Version javaVersion = this.getRequiredJavaVersion(latestRepository, "toolingorg.eclipse.birt.report.designer.all");
            System.out.println("Loaded " + String.valueOf(latestRepository.getLocation()) + " -> " + String.valueOf(javaVersion));
            Iterator iterator = P2Util.asIterable((IQueryResult)latestRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)BIRT_ALL_IN_ONE_PRODUCT_ID)), null)).iterator();
            if (!iterator.hasNext()) continue;
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            TreeSet<String> rootInstallIUs = new TreeSet<String>();
            TreeSet<String> unresolvedRequirements = new TreeSet<String>();
            for (IRequirement requirement : iu.getRequirements()) {
                String value;
                IRequiredCapability capability;
                IMatchExpression filter;
                if (!(requirement instanceof IRequiredCapability) || (filter = (capability = (IRequiredCapability)requirement).getFilter()) == null || !(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter)).contains("org.eclipse.equinox.p2.install.mode.root=true") || ((String)(name = capability.getName())).startsWith("org.eclipse.justj.") || ((String)name).equals("org.eclipse.oomph.setup.feature.group") || "JavaSE".equals(name)) continue;
                Set resolved = latestRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)name)), null).toSet();
                if (resolved.isEmpty()) {
                    unresolvedRequirements.add((String)name);
                    continue;
                }
                rootInstallIUs.add((String)name);
            }
            for (String unresolvedRequirement : unresolvedRequirements) {
                System.err.println("   <feature id=\"" + unresolvedRequirement + "\"/>");
            }
            Version productIUVersion = iu.getVersion();
            ProductVersion productVersion = SetupFactory.eINSTANCE.createProductVersion();
            productVersion.setName(type.toLowerCase());
            productVersion.setLabel(type + " (" + String.valueOf(productIUVersion.getSegment(0)) + "." + String.valueOf(productIUVersion.getSegment(1)) + ")");
            productVersion.setRequiredJavaVersion(javaVersion == null ? "21" : javaVersion.toString().replaceAll("\\.0", ""));
            BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"shortcut", (String)(product.getLabel().replaceAll(" \\(.+\\)", "").replace("/", " and ") + " - " + productVersion.getLabel().replaceAll(" \\(.+\\)", "")));
            product.getVersions().add((Object)productVersion);
            P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
            p2Task.setLabel("BIRT - " + productVersion.getLabel());
            productVersion.getSetupTasks().add((Object)p2Task);
            EList requirements = p2Task.getRequirements();
            requirements.add((Object)P2Factory.eINSTANCE.createRequirement(iu.getId()));
            name = rootInstallIUs.iterator();
            while (name.hasNext()) {
                String rootInstallIU = (String)name.next();
                requirements.add((Object)P2Factory.eINSTANCE.createRequirement(rootInstallIU));
            }
            String configurationFilter = this.getConfigurationFilter(latestRepository, "toolingorg.eclipse.birt.report.designer.all.configuration");
            ((Requirement)p2Task.getRequirements().get(0)).setFilter(configurationFilter);
            EList repositories = p2Task.getRepositories();
            repositories.add((Object)P2Factory.eINSTANCE.createRepository(repositoryLocation.toString()));
        }
        URI birtProductURI = this.outputLocation.trimSegments(1).appendSegment("org.eclipse.birt.product.setup");
        Resource birtProductResource = new BaseResourceFactoryImpl().createResource(birtProductURI);
        birtProductResource.getContents().add((Object)product);
        birtProductResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
    }

    private void updateCertificates() {
        BundleContext context = SetupInstallerPlugin.INSTANCE.getBundle().getBundleContext();
        ServiceReference contentFactoryRef = context.getServiceReference(SignedContentFactory.class);
        SignedContentFactory verifierFactory = (SignedContentFactory)context.getService(contentFactoryRef);
        try {
            try {
                Path certificatesDirectory = Path.of(this.outputLocation.trimSegments(1).appendSegment("certificates").toFileString(), new String[0]);
                Files.createDirectories(certificatesDirectory, new FileAttribute[0]);
                block5: for (String artifact : OLD_SIGNED_ARTIFACTS) {
                    SignerInfo[] signerInfos;
                    URI uri = URI.createURI((String)artifact);
                    this.uriConverter.createInputStream(uri, null).close();
                    File file = new File(ECFURIHandlerImpl.getCacheFile((URI)uri).toFileString());
                    SignedContent signedContent = verifierFactory.getSignedContent(file);
                    SignerInfo[] signerInfoArray = signerInfos = signedContent.getSignerInfos();
                    int n = signerInfos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Certificate[] certificateChain;
                        SignerInfo signerInfo = signerInfoArray[n2];
                        Certificate[] certificateArray = certificateChain = signerInfo.getCertificateChain();
                        int n3 = certificateChain.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Certificate certificate = certificateArray[n4];
                            if (certificate instanceof X509Certificate) {
                                byte[] encoded = certificate.getEncoded();
                                String sha1 = PGPPublicKeyService.toHex((byte[])IOUtil.getSHA1((InputStream)new ByteArrayInputStream(encoded)));
                                ArrayList<String> pemContent = new ArrayList<String>();
                                pemContent.add("-----BEGIN CERTIFICATE-----");
                                Base64.Encoder mimeEncoder = Base64.getMimeEncoder(64, "\n".getBytes(StandardCharsets.US_ASCII));
                                pemContent.addAll(Arrays.asList(new String(mimeEncoder.encode(encoded), StandardCharsets.US_ASCII).split("\n")));
                                pemContent.add("-----END CERTIFICATE-----");
                                Path pemOut = certificatesDirectory.resolve(sha1 + ".pem");
                                Files.write(pemOut, pemContent, new OpenOption[0]);
                                continue block5;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                context.ungetService(contentFactoryRef);
            }
        }
        finally {
            context.ungetService(contentFactoryRef);
        }
    }

    public void stop() {
    }

    private String[] getTrains() {
        return new String[]{"juno", "kepler", "luna", "mars", "neon", "oxygen", "photon", "2018-09", "2018-12", "2019-03", "2019-06", "2019-09", "2019-12", "2020-03", "2020-06", "2020-09", "2020-12", "2021-03", "2021-06", "2021-09", "2021-12", "2022-03", "2022-06", "2022-09", "2022-12", "2023-03", "2023-06", "2023-09", "2023-12", "2024-03", "2024-06", "2024-09", "2024-12", "2025-03", "2025-06", "2025-09"};
    }

    private String getStagingTrain() {
        String[] trains = this.getTrains();
        return trains[this.fakeNextRelease ? trains.length - 2 : trains.length - 1];
    }

    private String getCorrespondingTrain(String train) {
        return "staging".equals(train) ? this.getStagingTrain() : train;
    }

    private URI getEclipsePlatformSite(String train) {
        String[] trains = this.getTrains();
        int i = 0;
        while (i < trains.length) {
            if (trains[i].equals(train)) {
                if (train.equals(this.stagingTrain) && this.stagingEclipePlatformLocation != null) {
                    return this.stagingEclipePlatformLocation;
                }
                String versionSegment = "4." + (i + 2);
                if (i + 1 == trains.length && !this.isLatestReleased()) {
                    versionSegment = versionSegment + "-I-builds";
                }
                return ECLIPSE_PROJECT_URI.appendSegment(versionSegment);
            }
            ++i;
        }
        throw new RuntimeException("Invalid train: " + train);
    }

    private int compareTrains(String train1, String train2) {
        String[] trains = this.getTrains();
        int train1Index = -1;
        int train2Index = -1;
        int i = 0;
        while (i < trains.length) {
            String train = trains[i];
            if (train1.equals(train)) {
                train1Index = i;
            }
            if (train2.equals(train)) {
                train2Index = i;
            }
            ++i;
        }
        return train1Index - train2Index;
    }

    private String getMostRecentTrain() {
        String[] trains = this.getTrains();
        return trains[trains.length - 1];
    }

    private String getMostRecentReleasedTrain() {
        String[] trains = this.getTrains();
        return trains[trains.length - (this.isLatestReleased() ? 1 : 2)];
    }

    private String getMostRecentRealTrain() {
        String[] trains = this.getTrains();
        return trains[this.fakeNextRelease ? trains.length - 2 : trains.length - 1];
    }

    private String[] getRootIUs() {
        return new String[]{"org.eclipse.platform.feature.group", "org.eclipse.rcp.feature.group", "org.eclipse.jdt.feature.group", "org.eclipse.pde.feature.group"};
    }

    private boolean isLatestReleased() {
        return this.latestReleased;
    }

    public void generate() {
        if (this.updateCertificates) {
            this.updateCertificates();
        }
        this.getPackageBrandingSites();
        try {
            ProductCatalog productCatalog = SetupFactory.eINSTANCE.createProductCatalog();
            productCatalog.setName("org.eclipse.products");
            productCatalog.setLabel("Eclipse.org");
            productCatalog.setDescription("The catalog of products available as <a href='https://www.eclipse.org/downloads/'>packaged downloads</a> at Eclipse.org.");
            EMap<String, String> brandingInfos = this.getBrandingInfos((Scope)productCatalog);
            brandingInfos.put((Object)"readmePath", (Object)"readme/readme_eclipse.html");
            brandingInfos.put((Object)"appName", (Object)"Eclipse");
            Annotation statsSending = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/StatsSending");
            statsSending.getDetails().put((Object)"uri", (Object)"https://download.eclipse.org/stats/oomph");
            productCatalog.getAnnotations().add((Object)statsSending);
            InstallationTask installationTask = SetupFactory.eINSTANCE.createInstallationTask();
            installationTask.setID("installation");
            productCatalog.getSetupTasks().add((Object)installationTask);
            productCatalog.getSetupTasks().addAll(this.createOomphP2Task(null));
            this.emfRepositoryLocation = this.trimEmptyTrailingSegment(URI.createURI((String)this.loadLatestRepository(this.manager, URI.createURI((String)"https://download.eclipse.org/modeling/emf/emf/builds/release/latest"), true).getLocation().toString())).toString();
            RepositoryLoader repositoryLoader = new RepositoryLoader(this);
            repositoryLoader.perform("staging");
            repositoryLoader.perform(this.TRAINS);
            System.out.println("#################################################################################################################");
            System.out.println();
            ArrayList<String> ids = new ArrayList<String>(this.trainsAndVersions.keySet());
            Collections.sort(ids, new Comparator<String>(){

                @Override
                public int compare(String id1, String id2) {
                    int result = this.getLatestTrain(id2) - this.getLatestTrain(id1);
                    if (result == 0) {
                        String label1 = StringUtil.safe((String)ProductCatalogGenerator.this.labels.get(id1));
                        String label2 = StringUtil.safe((String)ProductCatalogGenerator.this.labels.get(id2));
                        result = label1.compareTo(label2);
                    }
                    return result;
                }

                private int getLatestTrain(String id) {
                    List<TrainAndVersion> list = ProductCatalogGenerator.this.trainsAndVersions.get(id);
                    TrainAndVersion lastEntry = list.get(list.size() - 1);
                    String lastTrain = lastEntry.getTrain();
                    int i = 0;
                    while (i < ProductCatalogGenerator.this.TRAINS.length) {
                        String train = ProductCatalogGenerator.this.TRAINS[i];
                        if (train == lastTrain) {
                            return i;
                        }
                        ++i;
                    }
                    throw new IllegalStateException();
                }
            });
            for (String id : ids) {
                this.products.put(id, null);
            }
            new ProductGenerator(this).perform(ids);
            EList products = productCatalog.getProducts();
            products.addAll(this.products.values());
            UniqueEList productIDs = new UniqueEList(PRODUCT_IDS);
            for (Product product : products) {
                productIDs.add(product.getName());
            }
            ECollections.sort((EList)products, (Comparator)new Comparator<Product>((List)productIDs){
                private final /* synthetic */ List val$productIDs;
                {
                    this.val$productIDs = list;
                }

                @Override
                public int compare(Product product1, Product product2) {
                    int index1 = this.val$productIDs.indexOf(product1.getName());
                    int index2 = this.val$productIDs.indexOf(product2.getName());
                    return index1 - index2;
                }
            });
            System.out.println("#################################################################################################################");
            System.out.println();
            if (IS_RANGE_NARROW) {
                this.checkVersionRanges(productCatalog);
            }
            this.postProcess(productCatalog);
            if (this.brandingNotification) {
                this.addBrandingNotificationAnnotations(productCatalog);
            }
            Resource resource = new BaseResourceFactoryImpl().createResource(this.outputLocation == null ? URI.createURI((String)"org.eclipse.products.setup") : this.outputLocation);
            resource.getContents().add((Object)productCatalog);
            if (this.outputLocation != null) {
                URI jresURI = this.outputLocation.trimSegments(1).appendSegment("org.eclipse.jres.setup");
                Resource jresResource = new BaseResourceFactoryImpl().createResource(jresURI);
                Macro jreMacro = this.getJREs();
                jresResource.getContents().add((Object)jreMacro);
                jresResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                for (Product product : new ArrayList(products)) {
                    EclipseIniTask eclipseIniTask;
                    if (ALL_PRODUCT_ID.equals(product.getName())) {
                        products.remove((Object)product);
                        URI allProductURI = this.outputLocation.trimSegments(1).appendSegment("org.eclipse.all.product.setup");
                        Resource allProductResource = new BaseResourceFactoryImpl().createResource(allProductURI);
                        eclipseIniTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                        eclipseIniTask.setVm(true);
                        eclipseIniTask.setOption("-Xmx");
                        eclipseIniTask.setValue("5g");
                        product.getSetupTasks().add((Object)eclipseIniTask);
                        allProductResource.getContents().add((Object)product);
                        allProductResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                    }
                    if (!ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(product.getName())) continue;
                    products.remove((Object)product);
                    URI eclipsePlatformSDKProductURI = this.outputLocation.trimSegments(1).appendSegment("org.eclipse.platform.sdk.product.setup");
                    Resource eclipsePlatformSDKProductResource = new BaseResourceFactoryImpl().createResource(eclipsePlatformSDKProductURI);
                    eclipseIniTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                    eclipseIniTask.setVm(true);
                    eclipseIniTask.setOption("-Xmx");
                    eclipseIniTask.setValue("3g");
                    product.getSetupTasks().add((Object)eclipseIniTask);
                    eclipsePlatformSDKProductResource.getContents().add((Object)product);
                    eclipsePlatformSDKProductResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                }
                resource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                this.savePGPKeys();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void computePatches() throws Exception {
        for (Map.Entry<String, Set<IInstallableUnit>> entry : this.patches.entrySet()) {
            URI uri = URI.createURI((String)entry.getKey());
            IMetadataRepository latestRepository = this.loadLatestRepository(this.manager, uri, true);
            for (IInstallableUnit iu : latestRepository.query(QueryUtil.createCompoundQuery(List.of(QueryUtil.createLatestIUQuery(), QueryUtil.createIUPatchQuery()), (boolean)true), null)) {
                entry.getValue().add(iu);
            }
        }
    }

    private void savePGPKeys() throws IOException {
        try {
            this.getPGPKeys(new java.net.URI(STAGING + this.getMostRecentRealTrain()));
            this.getPGPKeys(new java.net.URI("https://download.eclipse.org/wildwebdeveloper/releases/latest"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (PGPPublicKey pGPPublicKey : new ArrayList<PGPPublicKey>(this.pgpKeys.values())) {
            this.pgpKeys.putAll(this.keyService.getVerifiedCertifications(pGPPublicKey).stream().collect(Collectors.toMap(PGPPublicKeyService::toHexFingerprint, Function.identity())));
        }
        for (Map.Entry entry : new LinkedHashSet<Map.Entry<String, PGPPublicKey>>(this.pgpKeys.entrySet())) {
            String fingerprint = (String)entry.getKey();
            ArrayList<String> ids = new ArrayList<String>();
            Iterator userIDs = ((PGPPublicKey)entry.getValue()).getUserIDs();
            while (userIDs.hasNext()) {
                String userID = (String)userIDs.next();
                ids.add(userID);
            }
            System.out.println(fingerprint + " -> " + String.join((CharSequence)",", ids));
            String url = "https://keyserver.ubuntu.com/pks/lookup?search=0x" + fingerprint + "&fingerprint=on&options=mr&op=index";
            String pub = null;
            for (String line : IOUtil.readLines((InputStream)this.uriConverter.createInputStream(URI.createURI((String)url)), (String)"UTF-8")) {
                System.out.print("  ");
                System.out.println(line);
                Matcher matcher = PUB.matcher(line);
                if (!matcher.matches()) continue;
                pub = matcher.group(1).toLowerCase();
            }
            if (!pub.equals(fingerprint)) {
                System.out.println("  **removing this subkey**");
            }
            System.out.println();
        }
        URI uRI = this.outputLocation.trimSegments(1).appendSegment("keys").appendSegment("trusted-keys.asc");
        Object object = null;
        Object var3_9 = null;
        try (ArmoredOutputStream out = ArmoredOutputStream.builder().setVersion(null).build(this.uriConverter.createOutputStream(uRI));){
            for (PGPPublicKey key : this.pgpKeys.values()) {
                key.encode((OutputStream)out);
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPGPKeys(java.net.URI uri) throws ProvisionException {
        IArtifactRepository repository = this.artifactManager.loadRepository(uri, null);
        for (IArtifactKey key : repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null)) {
            IArtifactDescriptor[] iArtifactDescriptorArray = repository.getArtifactDescriptors(key);
            int n = iArtifactDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                PGPPublicKeyStore keys = PGPSignatureVerifier.getKeys((IArtifactDescriptor)descriptor);
                for (PGPPublicKey pgpKey : keys.all()) {
                    String fingerPrint = PGPPublicKeyService.toHexFingerprint((PGPPublicKey)pgpKey);
                    Map<String, PGPPublicKey> map = this.pgpKeys;
                    synchronized (map) {
                        this.pgpKeys.computeIfAbsent(fingerPrint, it -> this.keyService.addKey(pgpKey));
                    }
                }
                ++n2;
            }
        }
    }

    private List<SetupTask> createOomphP2Task(String emfRepository) {
        ArrayList<SetupTask> result = new ArrayList<SetupTask>();
        Requirement oomphRequirement = P2Factory.eINSTANCE.createRequirement("org.eclipse.oomph.setup.feature.group");
        Repository oomphRepository = P2Factory.eINSTANCE.createRepository("${oomph.update.url}");
        P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
        p2Task.getRequirements().add((Object)oomphRequirement);
        p2Task.getRepositories().add((Object)oomphRepository);
        result.add((SetupTask)p2Task);
        if (emfRepository != null) {
            VariableTask emfVariable = SetupFactory.eINSTANCE.createVariableTask();
            emfVariable.setName("oomph.emf.update.url");
            emfVariable.setValue(emfRepository);
            emfVariable.setLabel("Oomph's EMF Repository Location");
            emfVariable.setDescription("The location of the EMF repository for satisifying Oomph's dependencies on EMF");
            result.add((SetupTask)emfVariable);
            p2Task.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository("${oomph.emf.update.url}"));
        }
        return result;
    }

    private void generateProduct(String id) {
        String label = this.labels.get(id);
        String p2TaskLabel = this.stripIncubating(label);
        List<TrainAndVersion> list = this.trainsAndVersions.get(id);
        int size = list.size();
        TrainAndVersion latestTrainAndVersion = list.get(size - 1);
        String latestTrain = latestTrainAndVersion.getTrain();
        String latestTrainLabel = this.getTrainLabel(latestTrain);
        Version latestVersion = latestTrainAndVersion.getVersion();
        Map<String, Set<IInstallableUnit>> latestTrainsIUs = latestTrainAndVersion.getIUs();
        boolean discontinued = latestTrain != this.getMostRecentTrain() && latestTrain != this.getMostRecentReleasedTrain();
        boolean latestUnreleased = latestTrain == this.getMostRecentTrain() && !this.isLatestReleased();
        StringBuilder log = new StringBuilder();
        log.append(label).append(" (").append(id).append(')').append('\n');
        Product product = SetupFactory.eINSTANCE.createProduct();
        product.setName(id);
        this.setProductLabel(product, label);
        this.attachBrandingInfos(log, product, discontinued);
        this.products.put(id, product);
        if (ALL_PRODUCT_ID.equals(id) || ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id)) {
            product.getSetupTasks().addAll(this.createOomphP2Task(ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id) ? this.emfRepositoryLocation : null));
        }
        Object eclipseVersionPrefix = "";
        if (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id)) {
            Version version = latestTrainAndVersion.getIUs().values().iterator().next().iterator().next().getVersion();
            eclipseVersionPrefix = String.valueOf(version.getSegment(0)) + "." + String.valueOf(version.getSegment(1)) + " - ";
        }
        Map<String, Set<IInstallableUnit>> applicablePatches = ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id) ? this.getApplicablePatches(latestTrainAndVersion.getTrainURI()) : Map.of();
        this.addProductVersion(log, product, latestVersion, VersionSegment.MAJOR, latestTrainAndVersion.getTrainURI(), latestTrainAndVersion.getEPPURI(), latestTrain, "latest", "Latest (" + (String)eclipseVersionPrefix + latestTrainLabel + ")", p2TaskLabel + " (" + (String)eclipseVersionPrefix + latestTrainLabel + ")", latestTrainsIUs, this.emfRepositoryLocation, applicablePatches);
        if (!latestUnreleased || size != 1) {
            int offset = 1;
            if (latestUnreleased && size > 1) {
                ++offset;
            }
            TrainAndVersion releasedTrainAndVersion = list.get(size - offset);
            String releasedTrain = releasedTrainAndVersion.getTrain();
            String releasedTrainLabel = this.getTrainLabel(releasedTrain);
            Version releasedVersion = releasedTrainAndVersion.getVersion();
            if (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id)) {
                Version version = releasedTrainAndVersion.getIUs().values().iterator().next().iterator().next().getVersion();
                eclipseVersionPrefix = String.valueOf(version.getSegment(0)) + "." + String.valueOf(version.getSegment(1)) + " - ";
            }
            this.addProductVersion(log, product, releasedVersion, IS_RANGE_NARROW ? VersionSegment.MINOR : VersionSegment.MAJOR, releasedTrainAndVersion.getTrainURI(), releasedTrainAndVersion.getEPPURI(), releasedTrain, "latest.released", "Latest Release (" + (String)eclipseVersionPrefix + releasedTrainLabel + ")", p2TaskLabel + " (" + (String)eclipseVersionPrefix + releasedTrainLabel + ")", releasedTrainAndVersion.getIUs(), this.emfRepositoryLocation);
        }
        int i = 0;
        while (i < size) {
            TrainAndVersion entry = list.get(size - i - 1);
            String train = entry.getTrain();
            Object trainLabel = this.getTrainLabel(train);
            Version version = entry.getVersion();
            Object name = train;
            if (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id)) {
                Version eclipseVersion = entry.getIUs().values().iterator().next().iterator().next().getVersion();
                name = String.valueOf(eclipseVersion.getSegment(0)) + "." + String.valueOf(eclipseVersion.getSegment(1));
                trainLabel = (String)name + " - " + (String)trainLabel;
            }
            this.addProductVersion(log, product, version, IS_RANGE_NARROW ? VersionSegment.MINOR : VersionSegment.MAJOR, entry.getTrainURI(), entry.getEPPURI(), train, (String)name, (String)trainLabel, p2TaskLabel + " (" + (String)trainLabel + ")", entry.getIUs(), this.emfRepositoryLocation);
            ++i;
        }
        System.out.println(log);
    }

    private Map<String, Set<IInstallableUnit>> getApplicablePatches(URI trainURI) {
        TreeMap<String, Set<IInstallableUnit>> result = new TreeMap<String, Set<IInstallableUnit>>();
        try {
            IMetadataRepository repository = this.loadLatestRepository(this.manager, trainURI, false);
            for (Map.Entry<String, Set<IInstallableUnit>> entry : this.patches.entrySet()) {
                IMetadataRepository patchRepository = this.loadLatestRepository(this.manager, URI.createURI((String)entry.getKey()), false);
                for (IInstallableUnit iu : entry.getValue()) {
                    for (IRequirement requirement : iu.getRequirements()) {
                        Set set;
                        IQuery requirementQuery = QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]);
                        if (!patchRepository.query(requirementQuery, null).isEmpty() || (set = repository.query(requirementQuery, null).toSet()).isEmpty()) continue;
                        result.computeIfAbsent(entry.getKey(), key -> new TreeSet()).add(iu);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(String train) throws ProvisionException, URISyntaxException {
        Object value;
        String id;
        Object label;
        Object latestLocation;
        IMetadataRepository latestEPPMetaDataRepository;
        StringBuilder log = new StringBuilder();
        URI originalEPPURI = URI.createURI((String)("staging".equals(train) ? HTTPS_PACKAGES_STAGING : "https://download.eclipse.org/technology/epp/packages/" + train));
        URI eppURI = this.uriConverter.normalize(originalEPPURI);
        log.append(eppURI);
        boolean isStaging = train.equals(this.stagingTrain);
        boolean isFake = this.fakeNextRelease && train.equals(this.getMostRecentTrain());
        URI eppReplacementURI = null;
        if (isStaging) {
            log.append(" -> ").append(this.stagingEPPLocation);
        } else if (isFake) {
            eppReplacementURI = URI.createURI((String)("https://download.eclipse.org/technology/epp/packages/" + this.getMostRecentRealTrain()));
            log.append(" -> ").append(eppReplacementURI);
        }
        URI effectiveEPPURI = isStaging ? this.stagingEPPLocation : (isFake ? eppReplacementURI : eppURI);
        IMetadataRepository eppMetaDataRepository = this.manager.loadRepository(new java.net.URI(effectiveEPPURI.toString()), null);
        this.getPGPKeys(eppMetaDataRepository.getLocation());
        IMetadataRepository iMetadataRepository = latestEPPMetaDataRepository = isStaging && this.stagingUseComposite || this.compositeTrains.contains(train) || isFake ? eppMetaDataRepository : this.getLatestRepository(this.manager, eppMetaDataRepository);
        if (latestEPPMetaDataRepository != eppMetaDataRepository) {
            latestLocation = URI.createURI((String)latestEPPMetaDataRepository.getLocation().toString());
            log.append(" -> ").append(latestLocation);
            URI relativeLocation = URI.createURI((String)latestLocation.toString()).deresolve(URI.createURI((String)effectiveEPPURI.toString()).appendSegment(""));
            if (relativeLocation.isRelative()) {
                URI actualLatestEPPURI = URI.createURI((String)URI.createURI((String)eppURI.toString()).appendSegments(relativeLocation.segments()).toString());
                try {
                    this.manager.loadRepository(new java.net.URI(actualLatestEPPURI.toString()), null);
                    log.append(" -> ").append(actualLatestEPPURI);
                    eppURI = this.trimEmptyTrailingSegment(actualLatestEPPURI);
                }
                catch (Throwable throwable) {}
            }
        } else if (isStaging && this.stagingEPPLocationIsActual) {
            eppURI = this.stagingEPPLocation;
            log.append(" -> ").append(this.stagingEPPLocation);
        }
        log.append('\n');
        latestLocation = this.eppMetaDataRepositories;
        synchronized (latestLocation) {
            this.eppMetaDataRepositories.put(train, eppMetaDataRepository);
        }
        HashMap<String, IInstallableUnit> ius = new HashMap<String, IInstallableUnit>();
        URI releaseURI = URI.createURI((String)("staging".equals(train) ? STAGING + this.getStagingTrain() : "https://download.eclipse.org/releases/" + train));
        log.append(releaseURI);
        URI effectiveReleaseURI = isFake ? URI.createURI((String)("https://download.eclipse.org/releases/" + this.getMostRecentRealTrain())) : releaseURI;
        IMetadataRepository releaseMetaDataRepository = this.loadLatestRepository(this.manager, isStaging ? this.stagingTrainLocation : effectiveReleaseURI, !this.compositeTrains.contains(train) && (!isStaging || !this.stagingUseComposite));
        if (!isFake) {
            if (this.compositeTrains.contains(train) || isStaging && this.stagingUseComposite) {
                URI latestURI = this.trimEmptyTrailingSegment(URI.createURI((String)releaseMetaDataRepository.getLocation().toString()));
                if (!latestURI.equals(releaseURI)) {
                    releaseURI = latestURI.trimSegments(1);
                }
            } else {
                releaseURI = this.trimEmptyTrailingSegment(URI.createURI((String)releaseMetaDataRepository.getLocation().toString()));
            }
        }
        log.append(" -> ").append(releaseURI).append('\n');
        if (!"staging".equals(train)) {
            log.append(this.generateEclipsePlatformProduct(train));
        }
        this.generateFullTrainProduct(train, releaseMetaDataRepository, releaseURI);
        String mostRecentTrain = this.getMostRecentTrain();
        HashSet<String> requirements = new HashSet<String>();
        for (IInstallableUnit iInstallableUnit : P2Util.asIterable((IQueryResult)eppMetaDataRepository.query(QueryUtil.createLatestIUQuery(), null))) {
            IInstallableUnit existingIU;
            String fragment = iInstallableUnit.getProperty("org.eclipse.equinox.p2.type.fragment");
            if ("true".equals(fragment)) continue;
            label = iInstallableUnit.getProperty("org.eclipse.equinox.p2.name", null);
            if (label == null || ((String)label).startsWith("%") || ((String)label).equals("Uncategorized")) {
                requirements.add(iInstallableUnit.getId());
            }
            if ("epp.package.standard".equals(id = iInstallableUnit.getId())) {
                label = "Eclipse Standard";
            }
            if ((existingIU = (IInstallableUnit)ius.get(id)) != null) continue;
            ius.put(id, iInstallableUnit);
            Map<String, String> map = this.labels;
            synchronized (map) {
                String existingLabel = this.labels.get(id);
                if (existingLabel == null || train.equals(mostRecentTrain) || existingLabel.contains("PHP") && id.contains(".rust")) {
                    this.labels.put(id, (String)label);
                }
            }
        }
        for (IInstallableUnit iInstallableUnit : ius.values()) {
            for (IRequirement requirement : iInstallableUnit.getRequirements()) {
                IRequiredCapability capability;
                IMatchExpression filter;
                if (!(requirement instanceof IRequiredCapability) || (filter = (capability = (IRequiredCapability)requirement).getFilter()) != null && this.isEPPInstallRootFilter((String)(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter))) || !"org.eclipse.equinox.p2.iu".equals(capability.getNamespace())) continue;
                requirements.add(capability.getName());
            }
        }
        ius.keySet().removeAll(requirements);
        ius.keySet().remove("org.eclipse.epp.package.common.feature.feature.group");
        for (String string : SPECIAL_PRODUCT_IDS) {
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)releaseMetaDataRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)string)), null))) {
                id = iu.getId();
                String label2 = iu.getProperty("org.eclipse.equinox.p2.name", null);
                ius.put(id, iu);
                value = this.labels;
                synchronized (value) {
                    this.labels.put(id, label2);
                }
            }
        }
        block19: for (Map.Entry entry : ius.entrySet()) {
            String id2 = (String)entry.getKey();
            if (!PRODUCT_IDS.contains(id2) && !ALL_PRODUCT_ID.equals(id2) && !ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(id2) && !ECLIPSE_PLATFORM_SDK_PRODUCT_IDE_ID.equals(id2) && !SPECIAL_PRODUCT_IDS.contains(id2) && !"epp.package.standard".equals(id2)) continue;
            label = this.labels.get(id2);
            IInstallableUnit iu = (IInstallableUnit)entry.getValue();
            Version version = iu.getVersion();
            log.append("  ").append((String)label).append("  --  ").append(id2).append(" ").append(version).append('\n');
            HashMap<String, Set<IInstallableUnit>> versionIUs = new HashMap<String, Set<IInstallableUnit>>();
            this.gatherReleaseIUs(versionIUs, iu, releaseMetaDataRepository, eppMetaDataRepository);
            this.filterRoots(versionIUs);
            Map<String, List<TrainAndVersion>> map = this.trainsAndVersions;
            synchronized (map) {
                List<TrainAndVersion> list = this.trainsAndVersions.get(id2);
                if (list == null) {
                    list = new ArrayList<TrainAndVersion>();
                    this.trainsAndVersions.put(id2, list);
                }
                int i = 0;
                int size = list.size();
                while (i < size) {
                    TrainAndVersion trainAndVersion = list.get(i);
                    if (this.compareTrains(trainAndVersion.train, train) > 0) {
                        list.add(i, new TrainAndVersion(train, version, releaseURI, eppURI, versionIUs));
                        continue block19;
                    }
                    ++i;
                }
                list.add(new TrainAndVersion(train, version, releaseURI, eppURI, versionIUs));
            }
        }
        System.out.println(log.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateEclipsePlatformProduct(String train) throws ProvisionException, URISyntaxException {
        StringBuilder log = new StringBuilder();
        URI eclipsePlatformSite = this.getEclipsePlatformSite(train);
        log.append(String.valueOf(eclipsePlatformSite) + " -> ");
        IMetadataRepository repository = this.loadLatestRepository(this.manager, eclipsePlatformSite, true);
        log.append(String.valueOf(repository.getLocation()) + "\n");
        TreeMap<String, Set<IInstallableUnit>> versionIUs = new TreeMap<String, Set<IInstallableUnit>>();
        IQuery query = QueryUtil.createCompoundQuery(Arrays.asList(QueryUtil.createIUQuery((String)ECLIPSE_PLATFORM_SDK_PRODUCT_IDE_ID), QueryUtil.createLatestIUQuery()), (boolean)true);
        Object ide = null;
        for (Object iu : P2Util.asIterable((IQueryResult)repository.query(query, null))) {
            String id = iu.getId();
            CollectionUtil.add(versionIUs, (Object)id, (Object)iu);
            ide = iu;
        }
        if (ide != null) {
            Object iu;
            iu = this.labels;
            synchronized (iu) {
                this.labels.put(ECLIPSE_PLATFORM_SDK_PRODUCT_ID, "Eclipse SDK");
            }
            iu = this.platformMetaDataRepositories;
            synchronized (iu) {
                this.platformMetaDataRepositories.put(train, repository);
            }
            URI releaseURI = eclipsePlatformSite.toString().contains("I-builds") ? eclipsePlatformSite : URI.createURI((String)repository.getLocation().toString());
            Map<String, List<TrainAndVersion>> map = this.trainsAndVersions;
            synchronized (map) {
                List<TrainAndVersion> list = this.trainsAndVersions.get(ECLIPSE_PLATFORM_SDK_PRODUCT_ID);
                if (list == null) {
                    list = new ArrayList<TrainAndVersion>();
                    this.trainsAndVersions.put(ECLIPSE_PLATFORM_SDK_PRODUCT_ID, list);
                }
                TrainAndVersion newTrainAndVersion = new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs);
                boolean added = false;
                int i = 0;
                int size = list.size();
                while (i < size) {
                    TrainAndVersion trainAndVersion = list.get(i);
                    if (this.compareTrains(trainAndVersion.train, train) > 0) {
                        list.add(i, newTrainAndVersion);
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (!added) {
                    list.add(newTrainAndVersion);
                }
            }
        }
        return log.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFullTrainProduct(String train, IMetadataRepository releaseMetaDataRepository, URI releaseURI) {
        HashMap<String, IInstallableUnit> ius = new HashMap<String, IInstallableUnit>();
        HashSet<IInstallableUnit> categories = new HashSet<IInstallableUnit>();
        HashSet<Object> categorizedIUs = new HashSet<Object>();
        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)releaseMetaDataRepository.query(QueryUtil.createLatestIUQuery(), null))) {
            boolean isIncludedCategory;
            String id = iu.getId();
            IInstallableUnit existingIU = (IInstallableUnit)ius.get(id);
            if (existingIU == null) {
                ius.put(id, iu);
            }
            boolean bl = isIncludedCategory = "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category")) && !"EclipseRT Target Platform Components".equals(id);
            if (!isIncludedCategory) continue;
            categories.add(iu);
            categorizedIUs.add(id);
        }
        categorizedIUs.addAll(SPECIAL_PRODUCT_IDS);
        ius.keySet().retainAll(categorizedIUs);
        TreeMap<String, Set<IInstallableUnit>> versionIUs = new TreeMap<String, Set<IInstallableUnit>>();
        for (IInstallableUnit iu : ius.values()) {
            String id = iu.getId();
            CollectionUtil.add(versionIUs, (Object)id, (Object)iu);
        }
        Map<String, List<TrainAndVersion>> map = this.labels;
        synchronized (map) {
            this.labels.put(ALL_PRODUCT_ID, "Eclipse Eierlegende Wollmilchsau");
        }
        map = this.trainsAndVersions;
        synchronized (map) {
            List<TrainAndVersion> list = this.trainsAndVersions.get(ALL_PRODUCT_ID);
            if (list == null) {
                list = new ArrayList<TrainAndVersion>();
                this.trainsAndVersions.put(ALL_PRODUCT_ID, list);
            }
            for (String specialProductID : SPECIAL_PRODUCT_IDS) {
                IInstallableUnit ide = (IInstallableUnit)ius.get(specialProductID);
                boolean added = false;
                int i = 0;
                int size = list.size();
                while (i < size) {
                    TrainAndVersion trainAndVersion = list.get(i);
                    if (this.compareTrains(trainAndVersion.train, train) > 0) {
                        list.add(i, new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs));
                        added = true;
                        break;
                    }
                    ++i;
                }
                if (added) continue;
                list.add(new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs));
            }
        }
    }

    private URI trimEmptyTrailingSegment(URI uri) throws URISyntaxException {
        if (uri.hasTrailingPathSeparator()) {
            return uri.trimSegments(1);
        }
        return uri;
    }

    private Agent getAgent() {
        if (this.agent == null) {
            try {
                File agentLocation = File.createTempFile("test-", "-agent");
                agentLocation.delete();
                agentLocation.mkdirs();
                this.agent = new AgentImpl(null, agentLocation);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        return this.agent;
    }

    private PGPPublicKeyService getKeyService() {
        DefaultPGPPublicKeyService service = (DefaultPGPPublicKeyService)this.getAgent().getProvisioningAgent().getService(PGPPublicKeyService.class);
        service.setKeyServers(Set.of("keyserver.ubuntu.com"));
        return service;
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() {
        return this.getAgent().getMetadataRepositoryManager();
    }

    private IArtifactRepositoryManager getArtifactRepositoryManager() {
        return this.getAgent().getArtifactRepositoryManager();
    }

    private IMetadataRepository getLatestRepository(IMetadataRepositoryManager manager, IMetadataRepository repository) throws URISyntaxException, ProvisionException {
        IMetadataRepository result = repository;
        if (repository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)repository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository = manager.loadRepository(childURI = new java.net.URI(this.trimEmptyTrailingSegment(URI.createURI((String)childURI.toString().replace("http:", "https:"))).toString()), null);
                String value = (String)childRepository.getProperties().get("p2.timestamp");
                long timestamp = Long.parseLong(value);
                if (timestamp <= latest || childURI.toString().endsWith("categories")) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private IMetadataRepository loadLatestRepository(IMetadataRepositoryManager manager, URI releaseURI, boolean loadLatestChild) throws URISyntaxException, ProvisionException {
        IMetadataRepository releaseMetaDataRepository = manager.loadRepository(new java.net.URI(this.uriConverter.normalize(releaseURI).toString()), null);
        this.getPGPKeys(releaseMetaDataRepository.getLocation());
        IMetadataRepository result = releaseMetaDataRepository;
        if (loadLatestChild && releaseMetaDataRepository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)releaseMetaDataRepository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository;
                String value;
                long timestamp;
                String trimmedChildURI = this.trimEmptyTrailingSegment(URI.createURI((String)childURI.toString().replace("http:", "https:"))).toString();
                if (trimmedChildURI.startsWith(HTTPS_PACKAGES) || (timestamp = Long.parseLong(value = (String)(childRepository = manager.loadRepository(childURI = new java.net.URI(trimmedChildURI), null)).getProperties().get("p2.timestamp"))) <= latest) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private void addIntegrationVersions(ProductCatalog productCatalog) {
        List<String> trains = Arrays.asList(this.getTrains());
        int platformVersion = trains.indexOf(this.getMostRecentTrain()) - trains.indexOf("neon") + 6;
        for (Product product : productCatalog.getProducts()) {
            if (!SPECIAL_PRODUCT_IDS.contains(product.getName())) continue;
            EList versions = product.getVersions();
            ProductVersion version = (ProductVersion)versions.get(0);
            ProductVersion integrationVersion = (ProductVersion)EcoreUtil.copy((EObject)version);
            integrationVersion.setName("integration");
            integrationVersion.setLabel(version.getLabel().replace("Latest", "Integration"));
            P2Task p2Task = (P2Task)integrationVersion.getSetupTasks().get(0);
            p2Task.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository("https://download.eclipse.org/eclipse/updates/4." + platformVersion + "-I-builds"));
            versions.add(0, (Object)integrationVersion);
        }
    }

    private void checkVersionRanges(ProductCatalog productCatalog) {
        if (!this.isLatestReleased()) {
            for (Product product : productCatalog.getProducts()) {
                EList versions = product.getVersions();
                if (versions.size() <= 3) continue;
                ProductVersion latestReleaseVersion = (ProductVersion)versions.get(1);
                ProductVersion latestDevelopmentVersion = (ProductVersion)versions.get(2);
                if (!this.getMostRecentTrain().equals(latestDevelopmentVersion.getName())) continue;
                P2Task latestReleaseP2Task = (P2Task)latestReleaseVersion.getSetupTasks().get(0);
                P2Task latestDevelopmentP2Task = (P2Task)latestDevelopmentVersion.getSetupTasks().get(0);
                block1: for (Requirement developmentRequirement : latestDevelopmentP2Task.getRequirements()) {
                    String name = developmentRequirement.getName();
                    for (Requirement releaseRequirement : latestReleaseP2Task.getRequirements()) {
                        VersionRange releaseVersionRange;
                        if (!name.equals(releaseRequirement.getName())) continue;
                        VersionRange developmentVersionRange = developmentRequirement.getVersionRange();
                        if (!developmentVersionRange.equals((Object)(releaseVersionRange = releaseRequirement.getVersionRange()))) continue block1;
                        Version minimumVersion = developmentVersionRange.getMinimum();
                        Version maximumVersion = developmentVersionRange.getMaximum();
                        if (!(minimumVersion instanceof OSGiVersion) || !(maximumVersion instanceof OSGiVersion)) continue block1;
                        OSGiVersion minimum = (OSGiVersion)minimumVersion;
                        OSGiVersion maximum = (OSGiVersion)maximumVersion;
                        int major = minimum.getMajor();
                        if (major != maximum.getMajor()) continue block1;
                        developmentRequirement.setVersionRange(new VersionRange((Version)minimum, true, Version.createOSGi((int)major, (int)(maximum.getMinor() + 1), (int)0), false));
                        continue block1;
                    }
                }
            }
        }
    }

    private void postProcess(ProductCatalog productCatalog) {
        Iterator it = productCatalog.getProducts().iterator();
        while (it.hasNext()) {
            int last;
            EList versions;
            Product product = (Product)it.next();
            String id = product.getName();
            if (EXCLUDED_IDS.contains(id)) {
                it.remove();
            }
            if ("epp.package.standard".equals(id)) {
                for (ProductVersion version : product.getVersions()) {
                    if (!version.getLabel().contains("Mars")) continue;
                    P2Task task = (P2Task)version.getSetupTasks().get(0);
                    Requirement requirement = (Requirement)task.getRequirements().get(0);
                    requirement.setName("epp.package.committers");
                }
            }
            if (!"staging".equals(((ProductVersion)(versions = product.getVersions()).get(last = versions.size() - 1)).getName())) continue;
            versions.move(0, last);
        }
    }

    private void addBrandingNotificationAnnotations(ProductCatalog productCatalog) {
        EMap<String, String> productCatalogBrandingInfos = this.getBrandingInfos((Scope)productCatalog);
        productCatalogBrandingInfos.put((Object)"notificationURI", (Object)this.eclipseBrandingNotificationURI.toString());
        productCatalogBrandingInfos.put((Object)"notificationLabel", (Object)"SPONSOR");
        productCatalogBrandingInfos.put((Object)"notificationTooltip", (Object)"Sponsor the Eclipse IDE");
        productCatalogBrandingInfos.put((Object)"notificationAnimationStyle", (Object)"REPEAT");
        for (Product product : productCatalog.getProducts()) {
            String productName = product.getName();
            boolean foreignCatalog = ALL_PRODUCT_ID.equals(productName) || ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName);
            EMap<String, String> productBrandingInfos = this.getBrandingInfos((Scope)product);
            if (foreignCatalog) {
                productBrandingInfos.put((Object)"notificationURI", (Object)this.eclipseBrandingNotificationURI.toString());
                productBrandingInfos.put((Object)"notificationLabel", (Object)"SPONSOR");
                productBrandingInfos.put((Object)"notificationAnimationStyle", (Object)"REPEAT");
                productBrandingInfos.put((Object)"appName", (Object)"Eclipse");
            }
            productBrandingInfos.put((Object)"notificationTooltip", (Object)("Sponsor the " + product.getLabel()));
            if (!Boolean.FALSE.booleanValue()) continue;
            for (ProductVersion productVersion : product.getVersions()) {
                EMap<String, String> productVersionBrandingInfos = this.getBrandingInfos((Scope)productVersion);
                productVersionBrandingInfos.put((Object)"notificationColor", (Object)"color://rgb/12/184/198");
                productBrandingInfos.put((Object)"notificationScope", (Object)(product.getLabel() + " - " + productVersion.getLabel()));
            }
        }
    }

    private void gatherReleaseIUs(Map<String, Set<IInstallableUnit>> releaseIUs, IInstallableUnit iu, IMetadataRepository releaseMetaDataRepository, IMetadataRepository eppMetaDataRepository) {
        for (IRequirement requirement : iu.getRequirements()) {
            String value;
            IMatchExpression filter;
            IRequiredCapability capability;
            String capabilityName;
            if (!(requirement instanceof IRequiredCapability) || !(capabilityName = (capability = (IRequiredCapability)requirement).getName()).endsWith(".feature.group") || (filter = capability.getFilter()) != null && this.isEPPInstallRootFilter(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter))) continue;
            CompoundQueryable queriable = new CompoundQueryable(new IQueryable[]{releaseMetaDataRepository, eppMetaDataRepository});
            IQuery query = QueryUtil.createIUQuery((String)capabilityName, (VersionRange)capability.getRange());
            for (IInstallableUnit requiredIU : P2Util.asIterable((IQueryResult)queriable.query(query, null))) {
                if (!CollectionUtil.add(releaseIUs, (Object)capabilityName, (Object)requiredIU)) continue;
                this.gatherReleaseIUs(releaseIUs, requiredIU, releaseMetaDataRepository, eppMetaDataRepository);
            }
        }
    }

    private void filterRoots(Map<String, Set<IInstallableUnit>> releaseIUs) {
        Iterator<Map.Entry<String, Set<IInstallableUnit>>> it = releaseIUs.entrySet().iterator();
        while (it.hasNext()) {
            String id = it.next().getKey();
            if (id.endsWith("feature.group") && !id.startsWith("org.eclipse.epp") && !id.endsWith("epp.feature.group")) continue;
            it.remove();
        }
    }

    private void addProductVersion(StringBuilder log, Product product, Version version, VersionSegment versionSegment, URI trainURI, URI eppURI, String train, String name, String label, String p2TaskLabel, Map<String, Set<IInstallableUnit>> ius, String emfRepositoryLocation) {
        this.addProductVersion(log, product, version, versionSegment, trainURI, eppURI, train, name, label, p2TaskLabel, ius, emfRepositoryLocation, Map.of());
    }

    private void addProductVersion(StringBuilder log, Product product, Version version, VersionSegment versionSegment, URI trainURI, URI eppURI, String train, String name, String label, String p2TaskLabel, Map<String, Set<IInstallableUnit>> ius, String emfRepositoryLocation, Map<String, Set<IInstallableUnit>> applicablePatches) {
        log.append("  ").append((String)label);
        ProductVersion productVersion = SetupFactory.eINSTANCE.createProductVersion();
        productVersion.setName(name);
        if ("Staging".equals(label)) {
            label = (String)label + " (" + this.getStagingTrain() + ")";
        }
        productVersion.setLabel((String)label);
        product.getVersions().add((Object)productVersion);
        if (train == this.getMostRecentReleasedTrain() && !name.contains("latest")) {
            BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"status", (String)"current");
        } else if (train != this.getMostRecentTrain() && train != this.getMostRecentReleasedTrain() && !"staging".equals(train) && BaseUtil.getAnnotation((ModelElement)product, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"status") == null) {
            BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"status", (String)"outdated");
        }
        String productName = product.getName();
        VersionRange versionRange = this.createVersionRange(version, versionSegment);
        if (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) && version.compareTo((Object)Version.createOSGi((int)4, (int)23, (int)0)) < 0) {
            VariableTask oomphUpdateURLVariable = SetupFactory.eINSTANCE.createVariableTask();
            oomphUpdateURLVariable.setName("oomph.update.url");
            oomphUpdateURLVariable.setValue("https://download.eclipse.org/oomph/updates/release");
            productVersion.getSetupTasks().add((Object)oomphUpdateURLVariable);
        }
        boolean isFake = this.fakeNextRelease && this.getMostRecentTrain().equals(trainURI.lastSegment());
        Repository packageRepository = null;
        ArrayList additionalRepositories = new ArrayList();
        if (eppURI != null && !isFake) {
            packageRepository = P2Factory.eINSTANCE.createRepository();
            if (!ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) && !ALL_PRODUCT_ID.equals(productName) && !SPECIAL_PRODUCT_IDS.contains(productName) && train.equals(this.stagingTrain)) {
                boolean is_2025_03 = this.compareTrains(train, "2025-03") == 0;
                try {
                    IMetadataRepository eppMetadataRepository = this.manager.loadRepository(new java.net.URI(eppURI.toString()), null);
                    this.getPGPKeys(eppMetadataRepository.getLocation());
                    if (!eppMetadataRepository.query(QueryUtil.createIUQuery((String)productName), null).iterator().hasNext()) {
                        eppURI = eppURI.trimSegments(1);
                        trainURI = trainURI.trimSegments(1);
                        log.append(" {missing}");
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            URI actualEPPURI = this.uriConverter.getURIMap().values().contains(eppURI) ? URI.createURI((String)("https://download.eclipse.org/technology/epp/packages/" + this.getMostRecentReleasedTrain())) : eppURI;
            packageRepository.setURL(actualEPPURI.toString());
        }
        Repository releaseRepository = P2Factory.eINSTANCE.createRepository();
        releaseRepository.setURL(trainURI.toString());
        if (!ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName)) {
            releaseRepository.getAnnotations().add((Object)BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/ReleaseTrain"));
        }
        if (isFake) {
            RedirectionTask redirectionTask = SetupFactory.eINSTANCE.createRedirectionTask();
            redirectionTask.setSourceURL(trainURI.toString());
            redirectionTask.setTargetURL("https://download.eclipse.org/releases/" + this.getMostRecentRealTrain());
            productVersion.getSetupTasks().add((Object)redirectionTask);
        }
        P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
        p2Task.setLabel(p2TaskLabel);
        ArrayList<Requirement> obsoleteMylynRequirements = new ArrayList<Requirement>();
        if (!ALL_PRODUCT_ID.equals(productName) && !ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName)) {
            Requirement requirement = P2Factory.eINSTANCE.createRequirement();
            requirement.setName(productName);
            requirement.setVersionRange(versionRange);
            p2Task.getRequirements().add((Object)requirement);
            this.addRootIURequirements((EList<Requirement>)p2Task.getRequirements(), versionSegment, ius);
            this.addAdditionalInstallRootIURequirements((EList<Requirement>)p2Task.getRequirements(), productName, train);
            for (Object additionalRequirement : p2Task.getRequirements()) {
                boolean is_2024_03;
                String additionalRequirementName = additionalRequirement.getName();
                if ("org.eclipse.passage.ldc.feature.feature.group".equals(additionalRequirementName) && this.compareTrains(train, "2022-03") < 0) {
                    additionalRequirement.setVersionRange(new VersionRange(Version.create((String)"2.2.1"), true, Version.MAX_VERSION, true));
                    p2Task.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository("https://download.eclipse.org/passage/updates/release/2.2.1"));
                    if (this.compareTrains(train, "2021-12") < 0) {
                        p2Task.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository("https://download.eclipse.org/tools/orbit/downloads/drops2/R20211213173813/repository"));
                    }
                    break;
                }
                boolean is_2023_09 = this.compareTrains(train, "2023-09") == 0;
                boolean bl = is_2024_03 = this.compareTrains(train, "2024-03") == 0;
                if (!is_2023_09 && !is_2024_03 || !additionalRequirementName.startsWith("org.eclipse.mylyn") || additionalRequirementName.contains("mylyn.wiki") || !obsoleteMylynRequirements.isEmpty()) continue;
                for (String obsoleteMylynFeature : is_2024_03 ? OBSOELETE_MYLYN_FEATURES2 : OBSOELETE_MYLYN_FEATURES) {
                    Requirement obsoleteMylynRequirement = P2Factory.eINSTANCE.createRequirement();
                    obsoleteMylynRequirement.setName(obsoleteMylynFeature);
                    obsoleteMylynRequirement.setMin(0);
                    obsoleteMylynRequirement.setMax(0);
                    obsoleteMylynRequirements.add(obsoleteMylynRequirement);
                }
            }
        } else {
            EList requirements = p2Task.getRequirements();
            this.addAllRootIURequirements((EList<Requirement>)requirements, versionSegment, ius);
            requirements.move(0, requirements.size() - 1);
        }
        p2Task.getRequirements().addAll(obsoleteMylynRequirements);
        if (!SPECIAL_PRODUCT_IDS.contains(productName) && packageRepository != null) {
            p2Task.getRepositories().add((Object)packageRepository);
        }
        p2Task.getRepositories().add((Object)releaseRepository);
        p2Task.getRepositories().addAll(additionalRepositories);
        if (this.compareTrains(train, "luna") < 0) {
            Repository emfRepository = P2Factory.eINSTANCE.createRepository(emfRepositoryLocation);
            p2Task.getRepositories().add((Object)emfRepository);
        }
        if (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName)) {
            for (Repository repository : p2Task.getRepositories()) {
                if (!repository.getURL().contains("I-builds")) continue;
                Repository oomphNightlyBuildRepository = P2Factory.eINSTANCE.createRepository("https://download.eclipse.org/oomph/updates/latest");
                p2Task.getRepositories().add((Object)oomphNightlyBuildRepository);
                break;
            }
        }
        productVersion.getSetupTasks().add((Object)p2Task);
        if (Boolean.FALSE.booleanValue() && ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) && this.compareTrains(train, "2023-12") == 0) {
            Repository mpcRepository = P2Factory.eINSTANCE.createRepository("https://download.eclipse.org/mpc/drops/1.10.2/v20231116-1812");
            p2Task.getRepositories().add((Object)mpcRepository);
            if (!ALL_PRODUCT_ID.equals(productName)) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                requirement.setName("org.eclipse.ecf.filetransfer.httpclient5.feature.feature.group");
                requirement.setVersionRange(VersionRange.emptyRange);
                p2Task.getRequirements().add(1, (Object)requirement);
                EclipseIniTask eclipseIniTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                eclipseIniTask.setVm(true);
                eclipseIniTask.setOption("-Dorg.eclipse.ecf.provider.filetransfer.excludeContributors=");
                eclipseIniTask.setValue("org.eclipse.ecf.provider.filetransfer.httpclientjava");
                productVersion.getSetupTasks().add((Object)eclipseIniTask);
            }
        }
        Object idPrefix = "tooling" + (SPECIAL_PRODUCT_IDS.contains(productName) || ALL_PRODUCT_ID.equals(productName) ? "epp.package.java" : (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) ? "org.eclipse.platform.sdk" : productName)) + ".ini.";
        Version maxJavaVersion = null;
        if (train.compareTo("neon") >= 0) {
            maxJavaVersion = Version.create((String)"1.8.0");
        }
        IMetadataRepository metadataRepository = ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) ? this.platformMetaDataRepositories.get(train) : this.eppMetaDataRepositories.get(train);
        Object javaVersion = this.getRequiredJavaVersion(metadataRepository, (String)idPrefix);
        if (maxJavaVersion == null || javaVersion != null && maxJavaVersion.compareTo(javaVersion) < 0) {
            maxJavaVersion = javaVersion;
        }
        if (maxJavaVersion == null && ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName)) {
            idPrefix = "toolingepp.package.java.ini.";
            maxJavaVersion = this.getRequiredJavaVersion(this.eppMetaDataRepositories.get(train), (String)idPrefix);
        }
        if (maxJavaVersion != null) {
            javaVersion = maxJavaVersion.toString();
            while (((String)javaVersion).endsWith(".0")) {
                javaVersion = ((String)javaVersion).substring(0, ((String)javaVersion).length() - 2);
            }
            productVersion.setRequiredJavaVersion((String)javaVersion);
            log.append(" --> Java ").append((String)javaVersion);
        }
        Map<URI, Map<String, URI>> releases = this.sites.get(train);
        String productLabel = product.getLabel();
        String key = this.getKey(productLabel);
        URI siteURI = null;
        if (releases != null) {
            for (Map.Entry entry : releases.entrySet()) {
                Map productLocations = (Map)entry.getValue();
                siteURI = (URI)productLocations.get(key);
                if (siteURI != null) continue;
                siteURI = product.getName().startsWith("epp.") || ALL_PRODUCT_ID.equals(product.getName()) ? (URI)entry.getKey() : URI.createURI((String)"https://download.eclipse.org/eclipse/downloads/");
                log.append(" No version specific branding site -> ").append(siteURI);
            }
        }
        String string = "tooling" + (SPECIAL_PRODUCT_IDS.contains(productName) || ALL_PRODUCT_ID.equals(productName) ? "epp.package.java" : (ECLIPSE_PLATFORM_SDK_PRODUCT_ID.equals(productName) ? "org.eclipse.platform.ide" : productName)) + ".configuration";
        String applicationFilter = this.getConfigurationFilter(metadataRepository, string);
        ((Requirement)p2Task.getRequirements().get(0)).setFilter(applicationFilter);
        for (Map.Entry<String, Set<IInstallableUnit>> entry : applicablePatches.entrySet()) {
            for (IInstallableUnit iu : entry.getValue()) {
                VariableTask variableTask = SetupFactory.eINSTANCE.createVariableTask();
                variableTask.setType(VariableType.BOOLEAN);
                variableTask.setStorageURI(VariableTask.INSTALLATION_STORAGE_URI);
                String iuName = iu.getProperty("org.eclipse.equinox.p2.name", null);
                String iuDescription = iu.getProperty("org.eclipse.equinox.p2.description", null);
                String shortId = iu.getId().replaceAll("org.eclipse.(.*).feature.group", "$1");
                variableTask.setName("install." + shortId);
                variableTask.setDefaultValue("false");
                variableTask.setLabel("Install " + iuName);
                variableTask.setDescription(iuDescription);
                variableTask.getAnnotations().add((Object)BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/SimpleDefaultVariable"));
                productVersion.getSetupTasks().add((Object)variableTask);
                CompoundTask compoundTask = SetupFactory.eINSTANCE.createCompoundTask();
                compoundTask.setName(iuName);
                compoundTask.setFilter("(" + variableTask.getName() + "=true)");
                productVersion.getSetupTasks().add((Object)compoundTask);
                P2Task patchP2Task = SetupP2Factory.eINSTANCE.createP2Task();
                patchP2Task.setLabel(iuName);
                patchP2Task.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement(iu.getId(), P2Factory.eINSTANCE.createVersionRange(iu.getVersion(), VersionSegment.MINOR), true, true));
                patchP2Task.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(entry.getKey()));
                compoundTask.getSetupTasks().add((Object)patchP2Task);
            }
        }
        if (siteURI != null) {
            BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"siteURI", (String)siteURI.toString());
            if (this.isIncubating(siteURI)) {
                BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"incubating", (String)"true");
            }
        }
        BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"shortcut", (String)(product.getLabel().replaceAll(" \\(.+\\)", "").replace("/", " and ") + " - " + ((String)label).replaceAll(" \\(.+\\)", "")));
        log.append('\n');
    }

    private String getConfigurationFilter(IMetadataRepository metadataRepository, String configurationID) {
        Iterator configurationIUs = P2Util.asIterable((IQueryResult)metadataRepository.query(QueryUtil.createIUQuery((String)configurationID), null)).iterator();
        if (configurationIUs.hasNext()) {
            IInstallableUnit configurationIU = (IInstallableUnit)configurationIUs.next();
            TreeSet<String> filterValues = new TreeSet<String>();
            for (IRequirement requirement : configurationIU.getRequirements()) {
                String value;
                Matcher matcher;
                IMatchExpression filter = requirement.getFilter();
                if (filter == null || !(matcher = ARCH_OS_WS_FILTER_PATTERN.matcher(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter))).matches()) continue;
                filterValues.add(value);
            }
            if (!filterValues.isEmpty()) {
                StringBuilder compositeFilter = new StringBuilder("(|");
                for (String value : filterValues) {
                    compositeFilter.append(value);
                }
                String applicationFilter = compositeFilter.append(')').toString();
                return applicationFilter;
            }
            throw new RuntimeException("Configuration " + configurationID + " filters not found in " + String.valueOf(metadataRepository.getLocation()));
        }
        throw new RuntimeException("Configuration " + configurationID + " not found in " + String.valueOf(metadataRepository.getLocation()));
    }

    private Version getRequiredJavaVersion(IMetadataRepository metadataRepository, String idPrefix) {
        Version maxJavaVersion = null;
        if (metadataRepository != null) {
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)metadataRepository.query(QueryUtil.createIUAnyQuery(), null))) {
                String id = iu.getId();
                if (!id.startsWith(idPrefix)) continue;
                Version javaVersion = this.getRequiredJavaVersion(iu);
                if (maxJavaVersion != null && (javaVersion == null || maxJavaVersion.compareTo((Object)javaVersion) >= 0)) continue;
                maxJavaVersion = javaVersion;
            }
        }
        return maxJavaVersion;
    }

    private Version getRequiredJavaVersion(IInstallableUnit iu) {
        Version maxJavaVersion = null;
        Collection touchpointDatas = iu.getTouchpointData();
        if (touchpointDatas != null) {
            for (ITouchpointData touchpointData : touchpointDatas) {
                int pos;
                String body;
                ITouchpointInstruction instruction = touchpointData.getInstruction("configure");
                if (instruction == null || (body = instruction.getBody()) == null || (pos = body.indexOf(JAVA_VERSION_PREFIX)) == -1) continue;
                Version javaVersion = Version.parseVersion((String)body.substring(pos += JAVA_VERSION_PREFIX.length(), body.indexOf(41, pos)));
                if (maxJavaVersion != null && maxJavaVersion.compareTo((Object)javaVersion) >= 0) continue;
                maxJavaVersion = javaVersion;
            }
        }
        return maxJavaVersion;
    }

    private String getKey(String productLabel) {
        if (productLabel.contains("Eierlegende")) {
            return "All";
        }
        if (productLabel.contains("JavaScript")) {
            return "JavaScript";
        }
        if (productLabel.contains("Enterprise") || productLabel.contains(" EE ") || productLabel.contains("Web")) {
            return "EE";
        }
        if (productLabel.contains("Java Developer")) {
            return "Java";
        }
        if (productLabel.contains("Mobile")) {
            return "Mobile";
        }
        if (productLabel.contains("Embedded")) {
            return "EmbedC";
        }
        if (productLabel.contains("C/C++")) {
            return "C";
        }
        if (productLabel.contains("Scout")) {
            return "Scout";
        }
        if (productLabel.contains("Parallel")) {
            return "Parallel";
        }
        if (productLabel.contains(" Report ")) {
            return "Report";
        }
        if (productLabel.contains("Automotive")) {
            return "Automotive";
        }
        if (productLabel.contains("DSL")) {
            return "DSL";
        }
        if (productLabel.contains("Modeling")) {
            return "Modeling";
        }
        if (productLabel.contains("Testers")) {
            return "Testers";
        }
        if (productLabel.contains("RCP")) {
            return "RCP";
        }
        if (productLabel.contains("Standard") || productLabel.contains("Committers")) {
            return "Committers";
        }
        if (productLabel.contains("PHP")) {
            return "PHP";
        }
        if (productLabel.contains("Classic")) {
            return "Classic";
        }
        if (productLabel.contains("SOA")) {
            return "SOA";
        }
        if (productLabel.equals("Eclipse Platform")) {
            return "Platform";
        }
        if (productLabel.equals("Eclipse SDK")) {
            return "SDK";
        }
        if (productLabel.contains("Android")) {
            return "Android";
        }
        if (productLabel.contains("Rust")) {
            return "Rust";
        }
        if (productLabel.contains("Scientific")) {
            return "Scientific";
        }
        throw new RuntimeException("No key for " + productLabel);
    }

    private VersionRange createVersionRange(Version version, VersionSegment versionSegment) {
        VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment);
        if (versionSegment == VersionSegment.MAJOR) {
            VersionRange minorVersionRange = P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MINOR);
            versionRange = new VersionRange(minorVersionRange.getMinimum(), true, versionRange.getMaximum(), false);
        }
        return versionRange;
    }

    private void addRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, Map<String, Set<IInstallableUnit>> ius) {
        String[] stringArray = this.getRootIUs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String iu = stringArray[n2];
            Set<IInstallableUnit> rootIUs = ius.get(iu);
            if (rootIUs != null) {
                this.addRootIURequirements(requirements, versionSegment, iu, rootIUs);
            }
            ++n2;
        }
    }

    private void addAllRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, Map<String, Set<IInstallableUnit>> ius) {
        for (Map.Entry<String, Set<IInstallableUnit>> entry : ius.entrySet()) {
            this.addRootIURequirements(requirements, versionSegment, entry.getKey(), entry.getValue());
        }
    }

    private void addRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, String id, Set<IInstallableUnit> rootIUs) {
        VersionRange range = null;
        for (IInstallableUnit rootIU : rootIUs) {
            boolean isCategory = "true".equalsIgnoreCase(rootIU.getProperty("org.eclipse.equinox.p2.type.category"));
            if (isCategory) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                requirement.setName(id);
                requirement.setVersionRange(VersionRange.emptyRange);
                if (id.equals("Linux Tools")) {
                    requirement.setFilter("(osgi.os=linux)");
                }
                requirements.add((Object)requirement);
                return;
            }
            Version version = rootIU.getVersion();
            VersionRange versionRange = this.createVersionRange(version, versionSegment);
            if (range != null) continue;
            range = versionRange;
        }
        if (range != null) {
            Requirement requirement = P2Factory.eINSTANCE.createRequirement();
            requirement.setName(id);
            requirement.setVersionRange(range);
            requirements.add((Object)requirement);
        }
    }

    private void addAdditionalInstallRootIURequirements(EList<Requirement> requirements, String productName, String train) {
        IMetadataRepository eppMetadataRepository = this.eppMetaDataRepositories.get(train);
        IInstallableUnit maxProductIU = null;
        if (eppMetadataRepository != null) {
            for (IInstallableUnit productIU : eppMetadataRepository.query(QueryUtil.createIUQuery((String)productName), null)) {
                if (maxProductIU != null && productIU.getVersion().compareTo((Object)maxProductIU.getVersion()) <= 0) continue;
                maxProductIU = productIU;
            }
        }
        Set ids = requirements.stream().map(Requirement::getName).collect(Collectors.toSet());
        if (maxProductIU != null) {
            Set<String> rootInstallIUs = this.getRootInstallIUs(maxProductIU);
            if (rootInstallIUs != null) {
                for (String id : rootInstallIUs) {
                    if (ids.contains(id)) continue;
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                    if ("2022-12".equals(train) && "org.eclipse.emf.cdo.epp.feature.group".equals(id)) {
                        id = "org.eclipse.emf.cdo.sdk.feature.group";
                    }
                    requirement.setName(id);
                    requirements.add((Object)requirement);
                }
            }
            if (productName.startsWith("epp.package") && "2022-09".equals(train) && !requirements.stream().anyMatch(r -> {
                String name = r.getName();
                return "org.eclipse.jdt.feature.group".equals(name) || "org.eclipse.sdk.feature.group".equals(name);
            })) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                requirement.setName("org.eclipse.jdt.core");
                requirements.add((Object)requirement);
                requirement.setOptional(true);
            }
        }
    }

    private String getTrainLabel(String train) {
        return Character.toString(Character.toUpperCase(train.charAt(0))) + train.substring(1);
    }

    private void setProductLabel(Product product, String label) {
        product.setLabel(this.stripIncubating(label));
    }

    private String stripIncubating(String label) {
        return label.replaceFirst("(?i) \\(includes Incubating components\\)", "");
    }

    /*
     * Loose catch block
     */
    private void attachBrandingInfos(final StringBuilder log, final Product product, boolean discontinued) {
        String staticIconURL;
        String name = product.getName();
        if (discontinued) {
            this.getBrandingInfos((Scope)product).put((Object)"status", (Object)"discontinued");
        }
        if (name.equals("org.eclipse.platform.ide")) {
            product.setDescription("This package contains the absolute minimal IDE, suitable only as a base for installing other tools.");
            return;
        }
        if (name.equals(ECLIPSE_PLATFORM_SDK_PRODUCT_IDE_ID)) {
            product.setDescription("This package contains the IDE provided by the Eclipse project's platform build.");
            return;
        }
        if (name.equals(ALL_PRODUCT_ID)) {
            product.setDescription("This package contains all categorized features of the release train. It can do <a href='https://en.wiktionary.org/wiki/eierlegende_Wollmilchsau'>everything</a>, but it's not pretty.");
        }
        if (name.equals(ECLIPSE_PLATFORM_SDK_PRODUCT_ID)) {
            product.setDescription("This package contains the IDE provided by the Eclipse project's platform build.");
        }
        if (name.startsWith("epp.package.")) {
            name = name.substring("epp.package.".length());
        }
        if ((staticIconURL = ICONS.get(name)) != null) {
            this.addImageURI(product, staticIconURL);
        }
        final String[] trains = this.getTrains();
        int i = trains.length - 1;
        while (i >= 0) {
            InputStream in = null;
            final int trainIndex = i;
            final String branch = this.stagingTrain != null && i == trains.length - 1 || this.fakeNextRelease && i == trains.length - 2 ? "master" : (trains[i].startsWith("20") ? trains[i] + "_R" : trains[i].toUpperCase());
            String url = "https://raw.githubusercontent.com/eclipse-packaging/packages/" + branch + "/packages/org.eclipse.epp.package." + name + ".feature/epp.website.xml";
            try {
                in = this.uriConverter.createInputStream(URI.createURI((String)url));
                log.append(url).append('\n');
                DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)in);
                XMLUtil.handleElementsByTagName((Element)rootElement, (String)"packageMetaData", (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleElement(Element element) throws Exception {
                        String packageName;
                        if (staticIconURL != null) {
                            log.append(staticIconURL).append('\n');
                        } else {
                            String iconurl = element.getAttribute("iconurl");
                            if (iconurl != null) {
                                ProductCatalogGenerator.this.addImageURI(product, iconurl);
                                log.append(iconurl).append('\n');
                            }
                        }
                        if (!"epp.package.standard".equals(product.getName()) && (packageName = element.getAttribute("packageName")) != null) {
                            if (ProductCatalogGenerator.this.eppSiteURI != null && "master".equals(branch)) {
                                URI siteURI = URI.createURI((String)(String.valueOf(ProductCatalogGenerator.this.eppSiteURI) + "/" + packageName.replaceAll("[\\W&&[^ ]]", "").replace(" for ", " ").replaceAll(" +", "-").toLowerCase()));
                                String key = ProductCatalogGenerator.this.getKey(packageName);
                                Map<String, Map<URI, Map<String, URI>>> map = ProductCatalogGenerator.this.sites;
                                synchronized (map) {
                                    int j = ProductCatalogGenerator.this.fakeNextRelease && trainIndex == trains.length - 1 ? trainIndex - 1 : trainIndex;
                                    while (j < trains.length) {
                                        Map<String, URI> map2;
                                        String train = trains[j];
                                        Map<URI, Map<String, URI>> releaseLocations = ProductCatalogGenerator.this.sites.get(train);
                                        if (releaseLocations == null) {
                                            releaseLocations = new LinkedHashMap<URI, Map<String, URI>>();
                                            ProductCatalogGenerator.this.sites.put(train, releaseLocations);
                                        }
                                        if ((map2 = releaseLocations.get(ProductCatalogGenerator.this.eppSiteURI)) == null) {
                                            releaseLocations.clear();
                                            map2 = new LinkedHashMap<String, URI>();
                                            releaseLocations.put(ProductCatalogGenerator.this.eppSiteURI, map2);
                                            map2.put(key, siteURI);
                                        }
                                        map2.put(key, siteURI);
                                        ++j;
                                    }
                                }
                            }
                            ProductCatalogGenerator.this.setProductLabel(product, packageName);
                        }
                        XMLUtil.handleChildElements((Element)element, (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                            public void handleElement(Element childElement) throws Exception {
                                String description;
                                String localName = childElement.getLocalName();
                                if ("description".equals(localName) && (description = childElement.getTextContent()) != null) {
                                    product.setDescription(description.trim());
                                }
                            }
                        });
                    }
                });
            }
            catch (FileNotFoundException ex) {
                log.append(ex.getMessage()).append(" (FAILED)\n");
                IOUtil.closeSilent((Closeable)in);
            }
            catch (Exception ex2) {
                block16: {
                    if (ex2.getMessage().contains("File not found")) {
                        log.append(ex2.getMessage()).append(" (FAILED)\n");
                        break block16;
                    }
                    ex2.printStackTrace();
                    System.err.println("url=" + url);
                    {
                        catch (Throwable throwable) {
                            IOUtil.closeSilent(in);
                            throw throwable;
                        }
                    }
                }
                IOUtil.closeSilent((Closeable)in);
            }
            IOUtil.closeSilent((Closeable)in);
            return;
            --i;
        }
        if (staticIconURL != null) {
            log.append(staticIconURL).append('\n');
        }
    }

    private void addImageURI(Product product, String imageURI) {
        if (ICON_DEFAULT.equals(imageURI)) {
            return;
        }
        EMap<String, String> brandingInfos = this.getBrandingInfos((Scope)product);
        if (!brandingInfos.containsKey((Object)"imageURI")) {
            brandingInfos.put((Object)"imageURI", (Object)imageURI.replaceAll("^http:", "https:"));
        }
    }

    private EMap<String, String> getBrandingInfos(Scope scope) {
        Annotation annotation = scope.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
        if (annotation == null) {
            annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
            scope.getAnnotations().add((Object)annotation);
        }
        return annotation.getDetails();
    }

    /*
     * Unable to fully structure code
     */
    private void getPackageBrandingSites() {
        pattern = Pattern.compile("<li class=\"[0-9][^>]+><a href=\"([^\"]+)\"[^>]*>([\\w]+) Packages</a></li>");
        packageLocationLoader = new PackageLocationLoader(this);
        locations = new LinkedHashSet<URI>();
        var7_4 = this.getTrains();
        var6_5 = var7_4.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block11: {
                train = var7_4[var5_6];
                packages = null;
                alternativePackages = null;
                if (train.equals(this.getMostRecentTrain()) || "staging".equals(train)) ** GOTO lbl-1000
                siteURI = ProductCatalogGenerator.PACKAGES_URI.trimSegments(1).appendSegment(train).appendSegment("r");
                packagesURL = new URL(siteURI.toString());
                alternativePackages = packagesURL.openStream();
                System.out.println(train + " -> " + String.valueOf(siteURI));
                releaseLocations = new LinkedHashMap<URI, LinkedHashMap<K, V>>();
                packageLocations = new LinkedHashMap<K, V>();
                releaseLocations.put(siteURI, packageLocations);
                this.sites.put(train, releaseLocations);
                locations.add(siteURI);
                IOUtil.closeSilent((Closeable)packages);
                IOUtil.closeSilent((Closeable)alternativePackages);
                break block11;
                {
                    catch (Exception siteURI) {
                        try {
                            try lbl-1000:
                            // 2 sources

                            {
                                packagesURI = ProductCatalogGenerator.PACKAGES_URI.trimSegments(1).appendSegment(this.getCorrespondingTrain(train)).appendSegment("");
                                packagesURL = new URL(packagesURI.toString());
                                packages = packagesURL.openStream();
                                lines = IOUtil.readLines((InputStream)packages, (String)"UTF-8");
                                for (String line : lines) {
                                    matcher = pattern.matcher(line);
                                    if (!matcher.find()) continue;
                                    siteURI = URI.createURI((String)matcher.group(1)).resolve(ProductCatalogGenerator.PACKAGES_URI);
                                    System.out.println(train + " -> " + String.valueOf(siteURI));
                                    releaseLocations = new LinkedHashMap<URI, LinkedHashMap<K, V>>();
                                    packageLocations = new LinkedHashMap<K, V>();
                                    releaseLocations.put(siteURI, packageLocations);
                                    this.sites.put(train, releaseLocations);
                                    locations.add(siteURI);
                                }
                            }
                            catch (Exception ex) {
                                if (train.equals(this.getMostRecentTrain())) {
                                    ex.printStackTrace();
                                } else {
                                    ex.printStackTrace();
                                }
                                IOUtil.closeSilent(packages);
                                IOUtil.closeSilent(alternativePackages);
                                break block11;
                            }
                        }
                        catch (Throwable var19_21) {
                            IOUtil.closeSilent(packages);
                            IOUtil.closeSilent(alternativePackages);
                            throw var19_21;
                        }
                    }
                }
                IOUtil.closeSilent((Closeable)packages);
                IOUtil.closeSilent((Closeable)alternativePackages);
            }
            ++var5_6;
        }
        releasePackages = URI.createURI((String)"https://download.eclipse.org/eclipse/downloads/");
        this.getPlatformPackageBrandingSites(releasePackages);
        this.getPlatformPackageBrandingSites(URI.createURI((String)"https://archive.eclipse.org/eclipse/downloads/"));
        packageLocationLoader.perform(locations);
    }

    private boolean isIncubating(URI siteURI) {
        return Pattern.compile("incubat", 2).matcher(siteURI.toString()).find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGeneralPackageBrandingSites(URI releasePackages) {
        block12: {
            InputStream inputStream = null;
            try {
                try {
                    URL releasePackagesURL = new URL(releasePackages.toString());
                    inputStream = releasePackagesURL.openStream();
                    List lines = IOUtil.readLines((InputStream)inputStream, (String)"UTF-8");
                    Pattern pattern = Pattern.compile("^\\s+<a href=\"([^\"]+)\" title=[^>]*>([^<]+)</a>\\s*$");
                    for (String line : lines) {
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        String packageName = matcher.group(2);
                        String key = this.getKey(packageName);
                        URI packageURI = URI.createURI((String)matcher.group(1));
                        if (packageURI.isRelative()) {
                            packageURI = packageURI.resolve(releasePackages);
                        }
                        Map<String, Map<URI, Map<String, URI>>> map = this.sites;
                        synchronized (map) {
                            block8: for (Map.Entry<String, Map<URI, Map<String, URI>>> releaseEntry : this.sites.entrySet()) {
                                for (Map.Entry<URI, Map<String, URI>> productEntry : releaseEntry.getValue().entrySet()) {
                                    if (!releasePackages.equals(productEntry.getKey())) continue;
                                    System.out.println(releaseEntry.getKey() + " -> " + packageName + " -> " + String.valueOf(packageURI));
                                    URI oldURI = productEntry.getValue().put(key, packageURI);
                                    if (oldURI == null) break block8;
                                    System.err.println("Conflicting key");
                                    break block8;
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    IOUtil.closeSilent(inputStream);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPlatformPackageBrandingSites(URI releasePackages) {
        block11: {
            InputStream inputStream = null;
            try {
                try {
                    URL releasePackagesURL = new URL(releasePackages.toString());
                    inputStream = releasePackagesURL.openStream();
                    List lines = IOUtil.readLines((InputStream)inputStream, (String)"UTF-8");
                    Pattern pattern = Pattern.compile("<a href=\"([^\"]+)\"[^>]*>(4\\.[0-9.]+)[^<]*</a>");
                    for (String line : lines) {
                        int minorVersionIndex;
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        String packageVersion = matcher.group(2);
                        URI packageURI = URI.createURI((String)matcher.group(1));
                        if (packageURI.isRelative()) {
                            packageURI = packageURI.resolve(releasePackages);
                        }
                        int version = Integer.parseInt((minorVersionIndex = packageVersion.indexOf(46, 3)) == -1 ? packageVersion.substring(2) : packageVersion.substring(2, minorVersionIndex));
                        List<String> trains = Arrays.asList(this.getTrains());
                        int index = trains.indexOf("neon") - (6 - version);
                        if (index < 0 || index >= trains.size()) continue;
                        String train = trains.get(index);
                        Map<String, Map<URI, Map<String, URI>>> map = this.sites;
                        synchronized (map) {
                            Map<String, URI> packageLocations;
                            Iterator<Map<String, URI>> iterator;
                            Map<URI, Map<String, URI>> releaseLocations = this.sites.get(train);
                            if (releaseLocations != null && (iterator = releaseLocations.values().iterator()).hasNext() && !(packageLocations = iterator.next()).containsKey("Platform")) {
                                System.out.println(train + " -> " + packageVersion + " -> " + String.valueOf(packageURI));
                                packageLocations.put("Platform", packageURI);
                                packageLocations.put("SDK", packageURI);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    IOUtil.closeSilent(inputStream);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)inputStream);
        }
    }

    private Set<String> getRootInstallIUs(IInstallableUnit productIU) {
        TreeSet<String> rootInstallIUs = new TreeSet<String>();
        for (IRequirement requirement : productIU.getRequirements()) {
            String name;
            String value;
            IRequiredCapability capability;
            IMatchExpression filter;
            if (!(requirement instanceof IRequiredCapability) || (filter = (capability = (IRequiredCapability)requirement).getFilter()) == null || !this.isEPPInstallRootFilter(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter)) || (name = capability.getName()).startsWith("org.eclipse.justj.") || name.equals("org.eclipse.oomph.setup.feature.group") || "org.eclipse.platform.feature.group".contains(name)) continue;
            rootInstallIUs.add(name);
        }
        return rootInstallIUs;
    }

    private Macro getJREs() throws ProvisionException, URISyntaxException, SAXException, IOException, ParserConfigurationException {
        Macro jreMacro = SetupFactory.eINSTANCE.createMacro();
        jreMacro.setName("jre");
        jreMacro.setLabel("JRE");
        jreMacro.setDescription("The JRE macro provides tasks for installing JREs from JustJ's p2 update sites");
        IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
        IMetadataRepository jreRepository = manager.loadRepository(new java.net.URI(JUSTJ_JRES), null);
        IQueryResult features = jreRepository.query(QueryUtil.createIUGroupQuery(), null);
        TreeSet ius = new TreeSet(Collections.reverseOrder());
        for (IInstallableUnit iu : features) {
            if (!iu.getId().endsWith(".full.feature.group")) continue;
            ius.add(iu);
        }
        TreeMap<Version, IInstallableUnit> jreVersions = new TreeMap<Version, IInstallableUnit>();
        for (IInstallableUnit iu : ius) {
            Version jreVersion;
            OSGiVersion osgiVersion;
            int major;
            Version version = iu.getVersion();
            if (!(version instanceof OSGiVersion) || EXCLUDED_NON_LTS_JUSTJ_VERSIONS.contains(major = (osgiVersion = (OSGiVersion)version).getMajor()) || jreVersions.containsKey(jreVersion = Version.createOSGi((int)major, (int)osgiVersion.getMinor(), (int)0))) continue;
            jreVersions.put(jreVersion, iu);
        }
        for (IInstallableUnit iu : jreVersions.values()) {
            EclipseIniTask addOpensJavaLangTask;
            Annotation jreSpecificTasks;
            Object capability;
            IMetadataRepository childRepository = this.findRepository(jreRepository, iu);
            String model = iu.getProperty("org.eclipse.justj.model");
            Document document = XMLUtil.createDocumentBuilder().parse(new InputSource(new StringReader(model)));
            NodeList details = document.getElementsByTagNameNS("", "detail");
            String javaRuntimeVersion = null;
            int i = 0;
            while (i < details.getLength()) {
                Element element = (Element)details.item(i);
                if ("java.version".equals(element.getAttribute("key"))) {
                    javaRuntimeVersion = element.getElementsByTagNameNS("", "value").item(0).getTextContent();
                    break;
                }
                ++i;
            }
            System.out.println("jre=" + String.valueOf(iu) + " -> " + String.valueOf(childRepository.getLocation()));
            Requirement jreRequirement = P2Factory.eINSTANCE.createRequirement(iu.getId());
            TreeSet<String> filterValues = new TreeSet<String>();
            for (IRequirement requirement : iu.getRequirements()) {
                String value;
                Matcher matcher;
                IMatchExpression filter;
                if (!(requirement instanceof IRequiredCapability) || (filter = (capability = (IRequiredCapability)requirement).getFilter()) == null || !(matcher = ARCH_OS_FILTER_PATTERN.matcher(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter))).matches()) continue;
                filterValues.add(value);
            }
            if (!filterValues.isEmpty()) {
                StringBuilder compositeFilter = new StringBuilder("(|");
                capability = filterValues.iterator();
                while (capability.hasNext()) {
                    String value = (String)capability.next();
                    compositeFilter.append(value);
                }
                jreRequirement.setFilter(compositeFilter.append(')').toString());
            }
            URI childRepositoryURI = URI.createURI((String)childRepository.getLocation().toString());
            childRepositoryURI = childRepositoryURI.trimSegments(1).appendSegment("latest");
            Repository jreChildRepository = P2Factory.eINSTANCE.createRepository(childRepositoryURI.toString());
            P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
            p2Task.getRequirements().add((Object)jreRequirement);
            p2Task.getRepositories().add((Object)jreChildRepository);
            OSGiVersion osgiVersion = (OSGiVersion)iu.getVersion();
            Version jreVersion = Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro());
            p2Task.setLabel("JRE " + String.valueOf(javaRuntimeVersion != null ? Version.create((String)javaRuntimeVersion) : jreVersion));
            String description = iu.getProperty("org.eclipse.equinox.p2.description", null);
            p2Task.setDescription(description);
            if (osgiVersion.getMajor() >= 18) {
                jreSpecificTasks = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/JRESpecificTasks");
                addOpensJavaLangTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                addOpensJavaLangTask.setOption("--add-opens=java.base/java.lang=ALL-UNNAMED");
                addOpensJavaLangTask.setVm(true);
                jreSpecificTasks.getContents().add((Object)addOpensJavaLangTask);
                EclipseIniTask allowSecurityManagerTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                allowSecurityManagerTask.setOption("-Djava.security.manager");
                allowSecurityManagerTask.setValue("=allow");
                allowSecurityManagerTask.setVm(true);
                jreSpecificTasks.getContents().add((Object)allowSecurityManagerTask);
                p2Task.getAnnotations().add((Object)jreSpecificTasks);
            } else if (osgiVersion.getMajor() >= 17) {
                jreSpecificTasks = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/JRESpecificTasks");
                addOpensJavaLangTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                addOpensJavaLangTask.setOption("--add-opens=java.base/java.lang=ALL-UNNAMED");
                addOpensJavaLangTask.setVm(true);
                jreSpecificTasks.getContents().add((Object)addOpensJavaLangTask);
                p2Task.getAnnotations().add((Object)jreSpecificTasks);
            } else if (osgiVersion.getMajor() >= 16) {
                jreSpecificTasks = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/JRESpecificTasks");
                EclipseIniTask illegalAccessTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                illegalAccessTask.setOption("--illegal-access");
                illegalAccessTask.setValue("=permit");
                illegalAccessTask.setVm(true);
                jreSpecificTasks.getContents().add((Object)illegalAccessTask);
                p2Task.getAnnotations().add((Object)jreSpecificTasks);
            }
            jreMacro.getSetupTasks().add((Object)p2Task);
        }
        return jreMacro;
    }

    private IMetadataRepository findRepository(IMetadataRepository repository, IInstallableUnit iu) throws URISyntaxException, ProvisionException {
        if (repository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)repository;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository = this.manager.loadRepository(childURI = new java.net.URI(this.trimEmptyTrailingSegment(URI.createURI((String)childURI.toString())).toString()), null);
                if (childRepository.query(QueryUtil.createIUQuery((String)iu.getId(), (Version)iu.getVersion()), null).isEmpty()) continue;
                return this.findRepository(childRepository, iu);
            }
            throw new IllegalStateException("The iu " + String.valueOf(iu) + " is not found");
        }
        return repository;
    }

    private boolean isEPPInstallRootFilter(String filter) {
        return filter != null && EPP_INSTALL_ROOTS_FILTER_PATTERN.matcher(filter).matches();
    }

    public static class PackageLocationLoader
    extends WorkerPool<PackageLocationLoader, URI, LoadJob> {
        private ProductCatalogGenerator generator;

        public PackageLocationLoader(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected LoadJob createWorker(URI key, int workerID, boolean secondary) {
            return new LoadJob(this, key, workerID, secondary);
        }

        public class LoadJob
        extends WorkerPool.Worker<URI, PackageLocationLoader> {
            private LoadJob(PackageLocationLoader loader, URI uri, int id, boolean secondary) {
                super("Load " + String.valueOf(uri), (WorkerPool)loader, (Object)uri, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                PackageLocationLoader.this.generator.getGeneralPackageBrandingSites((URI)this.getKey());
                return Status.OK_STATUS;
            }
        }
    }

    public static class ProductGenerator
    extends WorkerPool<ProductGenerator, String, GenerateJob> {
        private ProductCatalogGenerator generator;

        public ProductGenerator(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected GenerateJob createWorker(String key, int workerID, boolean secondary) {
            return new GenerateJob(this, key, workerID, secondary);
        }

        public class GenerateJob
        extends WorkerPool.Worker<String, ProductGenerator> {
            private GenerateJob(ProductGenerator loader, String productID, int id, boolean secondary) {
                super("Load " + productID, (WorkerPool)loader, (Object)productID, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                try {
                    ProductGenerator.this.generator.generateProduct((String)this.getKey());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
    }

    public static class RepositoryLoader
    extends WorkerPool<RepositoryLoader, String, LoadJob> {
        private ProductCatalogGenerator generator;

        public RepositoryLoader(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected LoadJob createWorker(String key, int workerID, boolean secondary) {
            return new LoadJob(this, key, workerID, secondary);
        }

        public class LoadJob
        extends WorkerPool.Worker<String, RepositoryLoader> {
            private LoadJob(RepositoryLoader loader, String train, int id, boolean secondary) {
                super("Load " + train, (WorkerPool)loader, (Object)train, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                try {
                    RepositoryLoader.this.generator.generate((String)this.getKey());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
    }

    private static final class TrainAndVersion {
        private final String train;
        private final Version version;
        private final Map<String, Set<IInstallableUnit>> ius;
        private final URI trainURI;
        private URI eppURI;

        public TrainAndVersion(String train, Version version, URI trainURI, URI eppURI, Map<String, Set<IInstallableUnit>> ius) {
            this.train = train;
            this.version = version;
            this.trainURI = trainURI;
            this.eppURI = eppURI;
            this.ius = ius;
        }

        public String getTrain() {
            return this.train;
        }

        public Version getVersion() {
            return this.version;
        }

        public URI getTrainURI() {
            return this.trainURI;
        }

        public URI getEPPURI() {
            return this.eppURI;
        }

        public Map<String, Set<IInstallableUnit>> getIUs() {
            return this.ius;
        }

        public String toString() {
            return this.train + "->" + String.valueOf(this.version);
        }
    }
}

