/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.jface.menus.AbstractTrimWidget;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IWorkbenchWidget;

public class LegacyTrim {
    private IWorkbenchWidget widget;

    @PostConstruct
    void createWidget(IWorkbenchWindow iwbw, Composite parent, MToolControl toolControl) {
        IConfigurationElement ice = ((WorkbenchWindow)iwbw).getICEFor(toolControl);
        if (ice == null) {
            return;
        }
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new RowLayout());
        this.widget = (IWorkbenchWidget)Util.safeLoadExecutableExtension(ice, "class", IWorkbenchWidget.class);
        this.widget.init(iwbw);
        if (this.widget instanceof AbstractTrimWidget) {
            ((AbstractTrimWidget)this.widget).fill(parent, -1, this.getSide((MUIElement)toolControl));
        } else {
            this.widget.fill(parent);
        }
    }

    @PreDestroy
    void destroy() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
    }

    private int getSide(MUIElement element) {
        MElementContainer parent = element.getParent();
        if (parent instanceof MTrimBar) {
            switch (((MTrimBar)parent).getSide()) {
                case BOTTOM: {
                    return 1024;
                }
                case LEFT: {
                    return 16384;
                }
                case RIGHT: {
                    return 131072;
                }
                case TOP: {
                    return 128;
                }
            }
        }
        return parent == null ? -1 : this.getSide((MUIElement)parent);
    }
}

