/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.tablecombo.css;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.nebula.widgets.tablecombo.css.CSSEngineHelper;
import org.eclipse.nebula.widgets.tablecombo.css.TableComboElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class TableComboPropertyHandler
implements ICSSPropertyHandler {
    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        TableCombo tc = (TableCombo)((TableComboElement)((Object)element)).getNativeWidget();
        if ("tablecombo-show-table-lines".equals(property)) {
            boolean showTableLines = value == null ? false : Boolean.parseBoolean(value.getCssText());
            tc.setShowTableLines(showTableLines);
        }
        if ("tablecombo-show-table-header".equals(property)) {
            boolean showTableHeader = value == null ? false : Boolean.parseBoolean(value.getCssText());
            tc.setShowTableHeader(showTableHeader);
        }
        if ("tablecombo-border-color".equals(property)) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.setBorderColor(newColor);
        }
        if ("tablecombo-text-background-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.getTextControl().setBackground(newColor);
        }
        if ("tablecombo-text-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.getTextControl().setForeground(newColor);
        }
        if ("tablecombo-text-font".equals(property)) {
            this.applyCSSPropertyFont(element, (Control)tc.getTextControl(), value);
        }
        if ("tablecombo-text-font-style".equals(property)) {
            this.applyCSSPropertyStyle(element, (Control)tc.getTextControl(), value);
        }
        if ("tablecombo-text-font-size".equals(property)) {
            this.applyCSSPropertySize(element, (Control)tc.getTextControl(), value);
        }
        if ("tablecombo-text-font-weight".equals(property)) {
            this.applyCSSPropertyWeight(element, (Control)tc.getTextControl(), value);
        }
        if ("tablecombo-text-font-family".equals(property)) {
            this.applyCSSPropertyFamily(element, (Control)tc.getTextControl(), value);
        }
        if ("tablecombo-button-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.getArrowControl().setForeground(newColor);
        }
        if ("tablecombo-button-background-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.getArrowControl().setBackground(newColor);
        }
        if ("tablecombo-table-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.getTable().setForeground(newColor);
        }
        if ("tablecombo-table-background-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.getTable().setBackground(newColor);
        }
        if ("tablecombo-table-font".equals(property)) {
            this.applyCSSPropertyFont(element, (Control)tc.getTable(), value);
        }
        if ("tablecombo-table-font-style".equals(property)) {
            this.applyCSSPropertyStyle(element, (Control)tc.getTable(), value);
        }
        if ("tablecombo-table-font-size".equals(property)) {
            this.applyCSSPropertySize(element, (Control)tc.getTable(), value);
        }
        if ("tablecombo-table-font-weight".equals(property)) {
            this.applyCSSPropertyWeight(element, (Control)tc.getTable(), value);
        }
        if ("tablecombo-table-font-family".equals(property)) {
            this.applyCSSPropertyFamily(element, (Control)tc.getTable(), value);
        }
        if ("tablecombo-table-width-percentage".equals(property) && value.getCssValueType() == 1) {
            Measure m = (Measure)value;
            int width = Math.round(m.getFloatValue((short)0));
            tc.setTableWidthPercentage(width);
        }
        if ("tablecombo-table-odd-lines-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.setOddLinesForegroundColor(newColor);
        }
        if ("tablecombo-table-odd-lines-background-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.setOddLinesBackgroundColor(newColor);
        }
        if ("tablecombo-table-even-lines-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.setEvenLinesForegroundColor(newColor);
        }
        if ("tablecombo-table-even-lines-background-color".equals(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)tc.getDisplay());
            tc.setEvenLinesBackgroundColor(newColor);
        }
        return true;
    }

    private void applyCSSPropertyFont(Object element, Control widget, CSSValue value) throws Exception {
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            int i = 0;
            while (i < length) {
                CSSValue value2 = valueList.item(i);
                if (value2.getCssValueType() == 1) {
                    String cssProp = CSS2FontHelper.getCSSFontPropertyName((CSSPrimitiveValue)((CSSPrimitiveValue)value2));
                    if (cssProp.equals("font-family")) {
                        this.applyCSSPropertyFamily(element, widget, value2);
                    } else if (cssProp.equals("font-size")) {
                        this.applyCSSPropertySize(element, widget, value2);
                    } else if (cssProp.equals("font-weight") && ("bold".equals(value2.getCssText()) || "bolder".equals(value2.getCssText()))) {
                        this.applyCSSPropertyWeight(element, widget, value2);
                    } else if (cssProp.equals("font-style") && ("italic".equals(value2.getCssText()) || "oblique".equals(value2.getCssText()))) {
                        this.applyCSSPropertyStyle(element, widget, value2);
                    }
                }
                ++i;
            }
        }
    }

    private boolean applyCSSPropertyStyle(Object element, Control widget, CSSValue value) throws Exception {
        if (value.getCssValueType() == 1) {
            FontData fd = CSSEngineHelper.getFontData(widget);
            boolean modified = false;
            if ("italic".equals(value.getCssText()) || "oblique".equals(value.getCssText())) {
                boolean bl = modified = (fd.getStyle() & 2) != 2;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 2);
                }
            } else {
                boolean bl = modified = (fd.getStyle() & 2) == 2;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 0xFFFFFFFD);
                }
            }
            if (modified) {
                this.applyFont(widget, fd);
            }
        }
        return true;
    }

    private void applyFont(Control widget, FontData fd) {
        if (widget.getFont() != null && !widget.getFont().equals((Object)widget.getDisplay().getSystemFont())) {
            widget.getFont().dispose();
        }
        Font newFont = new Font((Device)widget.getDisplay(), fd);
        widget.setFont(newFont);
        widget.addListener(12, e -> {
            if (newFont != null && !newFont.isDisposed()) {
                newFont.dispose();
            }
        });
    }

    private boolean applyCSSPropertySize(Object element, Control widget, CSSValue value) throws Exception {
        if (value.getCssValueType() == 1) {
            boolean modified;
            FontData fd = CSSEngineHelper.getFontData(widget);
            Measure m = (Measure)value;
            int newSize = Math.round(m.getFloatValue((short)0));
            boolean bl = modified = fd.getHeight() != newSize;
            if (modified) {
                fd.setHeight(newSize);
                this.applyFont(widget, fd);
            }
        }
        return true;
    }

    private boolean applyCSSPropertyWeight(Object element, Control widget, CSSValue value) throws Exception {
        if (value.getCssValueType() == 1) {
            FontData fd = CSSEngineHelper.getFontData(widget);
            boolean modified = false;
            if ("bold".equals(value.getCssText()) || "bolder".equals(value.getCssText())) {
                boolean bl = modified = (fd.getStyle() & 1) != 1;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 1);
                }
            } else {
                boolean bl = modified = (fd.getStyle() & 1) == 1;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 0xFFFFFFFE);
                }
            }
            if (modified) {
                this.applyFont(widget, fd);
            }
        }
        return true;
    }

    private boolean applyCSSPropertyFamily(Object element, Control widget, CSSValue value) throws Exception {
        if (value.getCssValueType() == 1) {
            boolean modified;
            FontData fd = CSSEngineHelper.getFontData(widget);
            boolean bl = modified = !fd.getName().equals(value.getCssText());
            if (modified) {
                fd.setName(value.getCssText());
                this.applyFont(widget, fd);
            }
        }
        return true;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

