/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.roundedswitch;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.roundedswitch.RoundedSwitch;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

class RoundedSwitchConfiguration {
    Color borderColor;
    Color circleColor;
    Color backgroundColor;

    private RoundedSwitchConfiguration(Color borderColor, Color circleColor, Color backgroundColor) {
        this.borderColor = borderColor;
        this.circleColor = circleColor;
        this.backgroundColor = backgroundColor;
    }

    static RoundedSwitchConfiguration createCheckedEnabledConfiguration(RoundedSwitch parent) {
        Display display = parent.getDisplay();
        RoundedSwitchConfiguration config = new RoundedSwitchConfiguration(display.getSystemColor(2), display.getSystemColor(1), display.getSystemColor(2));
        return config;
    }

    static RoundedSwitchConfiguration createUncheckedEnabledConfiguration(RoundedSwitch parent) {
        Display display = parent.getDisplay();
        RoundedSwitchConfiguration config = new RoundedSwitchConfiguration(display.getSystemColor(2), display.getSystemColor(2), display.getSystemColor(1));
        return config;
    }

    static RoundedSwitchConfiguration createCheckedDisabledConfiguration(RoundedSwitch parent) {
        Display display = parent.getDisplay();
        Color lightGrey = new Color((Device)display, 233, 233, 233);
        Color darkGrey = new Color((Device)display, 208, 208, 208);
        SWTGraphicUtil.addDisposer((Widget)parent, (Resource[])new Resource[]{lightGrey, darkGrey});
        RoundedSwitchConfiguration config = new RoundedSwitchConfiguration(lightGrey, darkGrey, lightGrey);
        return config;
    }

    static RoundedSwitchConfiguration createUncheckedDisabledConfiguration(RoundedSwitch parent) {
        Display display = parent.getDisplay();
        Color lightGrey = new Color((Device)display, 233, 233, 233);
        Color darkGrey = new Color((Device)display, 208, 208, 208);
        SWTGraphicUtil.addDisposer((Widget)parent, (Resource[])new Resource[]{lightGrey, darkGrey});
        RoundedSwitchConfiguration config = new RoundedSwitchConfiguration(lightGrey, darkGrey, lightGrey);
        return config;
    }
}

