/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow.widgets;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.nebula.widgets.opal.preferencewindow.PreferenceWindow;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWText;

public class PWURLText
extends PWText {
    public PWURLText(String label, String propertyKey) {
        super(label, propertyKey);
        this.setWidth(200);
    }

    @Override
    public void addVerifyListeners() {
        this.text.addListener(16, event -> {
            try {
                new URL(this.text.getText());
            }
            catch (MalformedURLException e) {
                Dialog.error((String)ResourceManager.getLabel((String)"ApplicationError"), (String)ResourceManager.getLabel((String)"validURL"));
                event.doit = false;
                this.text.forceFocus();
            }
        });
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), "");
        } else {
            if (!(value instanceof String)) {
                throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a String because it is associated to a URL text box");
            }
            String str = (String)value;
            if (str.equals("")) {
                PreferenceWindow.getInstance().setValue(this.getPropertyKey(), "");
                return;
            }
            try {
                new URL(str);
            }
            catch (MalformedURLException e) {
                throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has a value (" + String.valueOf(value) + ") that is not an URL");
            }
        }
    }

    @Override
    public Object convertValue() {
        return this.text.getText();
    }

    @Override
    public int getStyle() {
        return 0;
    }
}

