/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.tiles;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.eclipse.nebula.widgets.tiles.Tiles;
import org.eclipse.swt.graphics.Device;

public class Gradient {
    private final Tiles<?> tiles;
    private final org.eclipse.swt.graphics.Color[] colors;

    public Gradient(Tiles<?> tiles, org.eclipse.swt.graphics.Color[] _colors) {
        this(tiles, _colors, 100);
    }

    public Gradient(Tiles<?> tiles, org.eclipse.swt.graphics.Color[] _colors, int steps) {
        this.tiles = tiles;
        this.colors = this.getGradient(_colors, steps);
    }

    public void dispose() {
        org.eclipse.swt.graphics.Color[] colorArray = this.colors;
        int n = this.colors.length;
        int n2 = 0;
        while (n2 < n) {
            org.eclipse.swt.graphics.Color c = colorArray[n2];
            if (!c.isDisposed()) {
                c.dispose();
            }
            ++n2;
        }
    }

    private final org.eclipse.swt.graphics.Color[] getGradient(org.eclipse.swt.graphics.Color[] colors, int steps) {
        Color[] awtcolor = new Color[colors.length];
        int i = 0;
        while (i < colors.length) {
            org.eclipse.swt.graphics.Color color = colors[i];
            awtcolor[i] = new Color(color.getRed(), color.getGreen(), color.getBlue());
            ++i;
        }
        return this.getGradient(awtcolor, steps);
    }

    private final org.eclipse.swt.graphics.Color[] getGradient(Color[] colors, int steps) {
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(1.0f, steps);
        float[] dist = new float[colors.length];
        int i = 0;
        while (i < dist.length) {
            dist[i] = 1.0f / (float)dist.length * (float)i;
            ++i;
        }
        LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
        BufferedImage legend = new BufferedImage(1, steps, 2);
        Graphics2D g2d = (Graphics2D)legend.getGraphics();
        g2d.setPaint(p);
        g2d.drawRect(0, 0, 1, steps);
        g2d.dispose();
        org.eclipse.swt.graphics.Color[] result = new org.eclipse.swt.graphics.Color[steps];
        int y = 0;
        while (y < steps) {
            int rgb = legend.getRGB(0, y);
            result[y] = new org.eclipse.swt.graphics.Color((Device)this.tiles.getDisplay(), rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
            ++y;
        }
        return result;
    }

    public org.eclipse.swt.graphics.Color getColor(double value) {
        int index = (int)Math.round((double)(this.colors.length - 1) * value);
        return this.colors[index];
    }
}

