/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PTDateEditor
extends PTEditor {
    @Override
    public ControlEditor render(PTWidget widget, Item item, PTProperty property) {
        Object editor = widget.getWidget() instanceof Table ? new TableEditor((Table)widget.getWidget()) : new TreeEditor((Tree)widget.getWidget());
        DateTime dateEditor = new DateTime(widget.getWidget(), 65572);
        Date date = (Date)property.getValue();
        Calendar c = Calendar.getInstance();
        if (date != null) {
            c.setTime(date);
            dateEditor.setDate(c.get(1), c.get(2), c.get(5));
        }
        dateEditor.addListener(13, e -> {
            c.setTime(new Date());
            c.clear();
            c.set(dateEditor.getYear(), dateEditor.getMonth(), dateEditor.getDay());
            property.setValue(c.getTime());
        });
        dateEditor.addListener(15, event -> widget.updateDescriptionPanel(property));
        editor.grabHorizontal = true;
        editor.horizontalAlignment = 16384;
        if (widget.getWidget() instanceof Table) {
            editor.setEditor((Control)dateEditor, (TableItem)item, 1);
        } else {
            ((TreeEditor)editor).setEditor((Control)dateEditor, (TreeItem)item, 1);
        }
        dateEditor.setEnabled(property.isEnabled());
        return editor;
    }
}

