/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.menu;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.columnCategories.ChooseColumnsFromCategoriesCommand;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommand;
import org.eclipse.nebula.widgets.nattable.columnRename.DisplayColumnRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.export.command.ExportTableCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearAllFiltersCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ToggleFilterRowCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeColumnCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezePositionCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeRowCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.UnFreezeGridCommand;
import org.eclipse.nebula.widgets.nattable.group.command.CreateColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.CreateRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.DisplayColumnGroupRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.group.command.DisplayRowGroupRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.group.command.OpenCreateColumnGroupDialog;
import org.eclipse.nebula.widgets.nattable.group.command.RemoveColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.RemoveRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.UngroupColumnCommand;
import org.eclipse.nebula.widgets.nattable.group.command.UngroupRowCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.gui.HeaderGroupNameDialog;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnShowCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowPositionHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowShowCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllRowsCommand;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.style.editor.command.DisplayColumnStyleEditorCommand;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;

public final class MenuItemProviders {
    public static final String NAT_EVENT_DATA_KEY = "natEventData";

    private MenuItemProviders() {
    }

    public static NatEventData getNatEventData(SelectionEvent selectionEvent) {
        Widget widget = selectionEvent.widget;
        if (!(widget instanceof MenuItem)) {
            return null;
        }
        MenuItem menuItem = (MenuItem)widget;
        Object data = null;
        for (Menu parentMenu = menuItem.getParent(); parentMenu != null; parentMenu = parentMenu.getParentMenu()) {
            if (parentMenu.getData(NAT_EVENT_DATA_KEY) == null) {
                continue;
            }
            data = parentMenu.getData(NAT_EVENT_DATA_KEY);
            break;
        }
        return data != null ? (NatEventData)data : null;
    }

    public static IMenuItemProvider hideColumnMenuItemProvider() {
        return MenuItemProviders.hideColumnMenuItemProvider("%MenuItemProviders.hideColumn");
    }

    public static IMenuItemProvider hideColumnMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setImage(GUIHelper.getDisplayImage("hide_column"));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int columnPosition = eventData.getColumnPosition();
                        natTable.doCommand(new ColumnHideCommand(natTable, columnPosition));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider showAllColumnsMenuItemProvider() {
        return MenuItemProviders.showAllColumnsMenuItemProvider("%MenuItemProviders.showAllColumns");
    }

    public static IMenuItemProvider showAllColumnsMenuItemProvider(String menuLabel) {
        return MenuItemProviders.showAllColumnsMenuItemProvider(menuLabel, GUIHelper.getDisplayImage("show_column"));
    }

    public static IMenuItemProvider showAllColumnsMenuItemProvider(String menuLabel, Image image) {
        return (natTable, popupMenu) -> {
            MenuItem showAllColumns = new MenuItem(popupMenu, 8);
            showAllColumns.setText(Messages.getLocalizedMessage(menuLabel));
            showAllColumns.setImage(image);
            showAllColumns.setEnabled(true);
            showAllColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new ShowAllColumnsCommand());
                }
            });
        };
    }

    public static IMenuItemProvider showColumnMenuItemProvider(boolean showAll) {
        return MenuItemProviders.showColumnMenuItemProvider(showAll, "%MenuItemProviders.showColumns");
    }

    public static IMenuItemProvider showColumnMenuItemProvider(boolean showAll, String menuLabel) {
        return MenuItemProviders.showColumnMenuItemProvider(showAll, menuLabel, GUIHelper.getDisplayImage("show_column"));
    }

    public static IMenuItemProvider showColumnMenuItemProvider(final boolean showAll, String menuLabel, Image image) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setImage(image);
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int diffToCellEnd;
                        int columnPosition;
                        int diffToCellStart = eventData.getOriginalEvent().x - natTable.getStartXOfColumnPosition(columnPosition = eventData.getColumnPosition());
                        natTable.doCommand(new ColumnShowCommand(natTable, columnPosition, diffToCellStart < (diffToCellEnd = natTable.getStartXOfColumnPosition(columnPosition) + natTable.getColumnWidthByPosition(columnPosition) - eventData.getOriginalEvent().x), showAll));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider hideRowMenuItemProvider() {
        return MenuItemProviders.hideRowMenuItemProvider("%MenuItemProviders.hideRow");
    }

    public static IMenuItemProvider hideRowMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setImage(GUIHelper.getDisplayImage("hide_row"));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int rowPosition = eventData.getRowPosition();
                        natTable.doCommand(new RowHideCommand(natTable, rowPosition));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider hideRowPositionMenuItemProvider() {
        return MenuItemProviders.hideRowPositionMenuItemProvider("%MenuItemProviders.hideRow");
    }

    public static IMenuItemProvider hideRowPositionMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setImage(GUIHelper.getDisplayImage("hide_row"));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int rowPosition = eventData.getRowPosition();
                        int columnPosition = eventData.getColumnPosition();
                        natTable.doCommand(new RowPositionHideCommand(natTable, columnPosition, rowPosition));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider showAllRowsMenuItemProvider() {
        return MenuItemProviders.showAllRowsMenuItemProvider("%MenuItemProviders.showAllRows");
    }

    public static IMenuItemProvider showAllRowsMenuItemProvider(String menuLabel) {
        return MenuItemProviders.showAllRowsMenuItemProvider(menuLabel, GUIHelper.getDisplayImage("show_row"));
    }

    public static IMenuItemProvider showAllRowsMenuItemProvider(String menuLabel, Image image) {
        return (natTable, popupMenu) -> {
            MenuItem showAllRows = new MenuItem(popupMenu, 8);
            showAllRows.setText(Messages.getLocalizedMessage(menuLabel));
            showAllRows.setImage(image);
            showAllRows.setEnabled(true);
            showAllRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new ShowAllRowsCommand());
                }
            });
        };
    }

    public static IMenuItemProvider showRowMenuItemProvider(boolean showAll) {
        return MenuItemProviders.showRowMenuItemProvider(showAll, "%MenuItemProviders.showRow");
    }

    public static IMenuItemProvider showRowMenuItemProvider(boolean showAll, String menuLabel) {
        return MenuItemProviders.showRowMenuItemProvider(showAll, menuLabel, GUIHelper.getDisplayImage("show_row"));
    }

    public static IMenuItemProvider showRowMenuItemProvider(final boolean showAll, String menuLabel, Image image) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setImage(image);
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int diffToCellEnd;
                        int rowPosition;
                        int diffToCellStart = eventData.getOriginalEvent().y - natTable.getStartYOfRowPosition(rowPosition = eventData.getRowPosition());
                        natTable.doCommand(new RowShowCommand(natTable, rowPosition, diffToCellStart < (diffToCellEnd = natTable.getStartYOfRowPosition(rowPosition) + natTable.getRowHeightByPosition(rowPosition) - eventData.getOriginalEvent().y), showAll));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider autoResizeColumnMenuItemProvider() {
        return MenuItemProviders.autoResizeColumnMenuItemProvider("%MenuItemProviders.autoResizeColumn");
    }

    public static IMenuItemProvider autoResizeColumnMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem autoResizeColumns = new MenuItem(popupMenu, 8);
            autoResizeColumns.setText(Messages.getLocalizedMessage(menuLabel));
            autoResizeColumns.setImage(GUIHelper.getDisplayImage("auto_resize"));
            autoResizeColumns.setEnabled(true);
            autoResizeColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int columnPosition = eventData.getColumnPosition();
                        natTable.doCommand(new InitializeAutoResizeColumnsCommand(natTable, columnPosition, natTable.getConfigRegistry(), new GCFactory((Drawable)natTable)));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider autoResizeRowMenuItemProvider() {
        return MenuItemProviders.autoResizeRowMenuItemProvider("%MenuItemProviders.autoResizeRow");
    }

    public static IMenuItemProvider autoResizeRowMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem autoResizeRows = new MenuItem(popupMenu, 8);
            autoResizeRows.setText(Messages.getLocalizedMessage(menuLabel));
            autoResizeRows.setImage(GUIHelper.getDisplayImage("auto_resize_row"));
            autoResizeRows.setEnabled(true);
            autoResizeRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int rowPosition = eventData.getRowPosition();
                        natTable.doCommand(new InitializeAutoResizeRowsCommand(natTable, rowPosition, natTable.getConfigRegistry(), new GCFactory((Drawable)natTable)));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider autoResizeAllSelectedColumnMenuItemProvider() {
        return MenuItemProviders.autoResizeAllSelectedColumnMenuItemProvider("%MenuItemProviders.autoResizeAllSelectedColumns");
    }

    public static IMenuItemProvider autoResizeAllSelectedColumnMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem autoResizeColumns = new MenuItem(popupMenu, 8);
            autoResizeColumns.setText(Messages.getLocalizedMessage(menuLabel));
            autoResizeColumns.setEnabled(true);
            autoResizeColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int columnPosition = eventData.getColumnPosition();
                        natTable.doCommand(new InitializeAutoResizeColumnsCommand(natTable, columnPosition, natTable.getConfigRegistry(), new GCFactory((Drawable)natTable)));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider columnChooserMenuItemProvider() {
        return MenuItemProviders.columnChooserMenuItemProvider("%MenuItemProviders.chooseColumns");
    }

    public static IMenuItemProvider columnChooserMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem columnChooser = new MenuItem(popupMenu, 8);
            columnChooser.setText(Messages.getLocalizedMessage(menuLabel));
            columnChooser.setImage(GUIHelper.getDisplayImage("column_chooser"));
            columnChooser.setEnabled(true);
            columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new DisplayColumnChooserCommand(natTable));
                }
            });
        };
    }

    public static IMenuItemProvider columnStyleEditorMenuItemProvider() {
        return MenuItemProviders.columnStyleEditorMenuItemProvider("%MenuItemProviders.editStyles");
    }

    public static IMenuItemProvider columnStyleEditorMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
            columnStyleEditor.setText(Messages.getLocalizedMessage(menuLabel));
            columnStyleEditor.setImage(GUIHelper.getDisplayImage("preferences"));
            columnStyleEditor.setEnabled(true);
            columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int rowPosition = eventData.getRowPosition();
                        int columnPosition = eventData.getColumnPosition();
                        natTable.doCommand(new DisplayColumnStyleEditorCommand(natTable, natTable.getConfigRegistry(), columnPosition, rowPosition));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider renameColumnMenuItemProvider() {
        return MenuItemProviders.renameColumnMenuItemProvider("%MenuItemProviders.renameColumn");
    }

    public static IMenuItemProvider renameColumnMenuItemProvider(String label) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(label));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        natTable.doCommand(new DisplayColumnRenameDialogCommand(natTable, eventData.getColumnPosition()));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider createColumnGroupMenuItemProvider() {
        return MenuItemProviders.createColumnGroupMenuItemProvider("%MenuItemProviders.createColumnGroup");
    }

    public static IMenuItemProvider createColumnGroupMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
            columnStyleEditor.setText(Messages.getLocalizedMessage(menuLabel));
            columnStyleEditor.setEnabled(true);
            columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new OpenCreateColumnGroupDialog(natTable.getShell()));
                }
            });
        };
    }

    public static IMenuItemProvider createPerformanceColumnGroupMenuItemProvider() {
        return MenuItemProviders.createPerformanceColumnGroupMenuItemProvider("%MenuItemProviders.createColumnGroup");
    }

    public static IMenuItemProvider createPerformanceColumnGroupMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem createColumnGroup = new MenuItem(popupMenu, 8);
            createColumnGroup.setText(Messages.getLocalizedMessage(menuLabel));
            createColumnGroup.setEnabled(true);
            createColumnGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HeaderGroupNameDialog dialog = new HeaderGroupNameDialog(natTable.getShell(), HeaderGroupNameDialog.HeaderGroupNameDialogLabels.CREATE_COLUMN_GROUP);
                    int result = dialog.open();
                    if (result == 0) {
                        natTable.doCommand(new CreateColumnGroupCommand(dialog.getGroupName()));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider ungroupColumnsMenuItemProvider() {
        return MenuItemProviders.ungroupColumnsMenuItemProvider("%MenuItemProviders.ungroupColumns");
    }

    public static IMenuItemProvider ungroupColumnsMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
            columnStyleEditor.setText(Messages.getLocalizedMessage(menuLabel));
            columnStyleEditor.setEnabled(true);
            columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new UngroupColumnCommand());
                }
            });
        };
    }

    public static IMenuItemProvider inspectLabelsMenuItemProvider() {
        return (natTable, popupMenu) -> {
            MenuItem inspectLabelsMenuItem = new MenuItem(popupMenu, 8);
            inspectLabelsMenuItem.setText(Messages.getString("MenuItemProviders.debugInfo"));
            inspectLabelsMenuItem.setEnabled(true);
            inspectLabelsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        NatTable natTable = eventData.getNatTable();
                        int columnPosition = eventData.getColumnPosition();
                        int rowPosition = eventData.getRowPosition();
                        String msg = "Display mode: " + String.valueOf((Object)natTable.getDisplayModeByPosition(columnPosition, rowPosition)) + "\nConfig labels: " + String.valueOf(natTable.getConfigLabelsByPosition(columnPosition, rowPosition)) + "\nData value: " + String.valueOf(natTable.getDataValueByPosition(columnPosition, rowPosition)) + "\n\nColumn position: " + columnPosition + "\nColumn index: " + natTable.getColumnIndexByPosition(columnPosition) + "\n\nRow position: " + rowPosition + "\nRow index: " + natTable.getRowIndexByPosition(rowPosition);
                        MessageBox messageBox = new MessageBox(natTable.getShell(), 34);
                        messageBox.setText(Messages.getString("MenuItemProviders.debugInformation"));
                        messageBox.setMessage(msg);
                        messageBox.open();
                    }
                }
            });
        };
    }

    public static IMenuItemProvider categoriesBasedColumnChooserMenuItemProvider() {
        return MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider("%MenuItemProviders.columnCategoriesChooser");
    }

    public static IMenuItemProvider categoriesBasedColumnChooserMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem columnChooser = new MenuItem(popupMenu, 8);
            columnChooser.setText(Messages.getLocalizedMessage(menuLabel));
            columnChooser.setImage(GUIHelper.getDisplayImage("column_categories_chooser"));
            columnChooser.setEnabled(true);
            columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new ChooseColumnsFromCategoriesCommand(natTable));
                }
            });
        };
    }

    public static IMenuItemProvider clearAllFiltersMenuItemProvider() {
        return MenuItemProviders.clearAllFiltersMenuItemProvider("%MenuItemProviders.clearAllFilters");
    }

    public static IMenuItemProvider clearAllFiltersMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setImage(GUIHelper.getDisplayImage("remove_filter"));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new ClearAllFiltersCommand());
                }
            });
        };
    }

    public static IMenuItemProvider clearToggleFilterRowMenuItemProvider() {
        return MenuItemProviders.clearToggleFilterRowMenuItemProvider("%MenuItemProviders.toggleFilterRow");
    }

    public static IMenuItemProvider clearToggleFilterRowMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setImage(GUIHelper.getDisplayImage("toggle_filter"));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new ToggleFilterRowCommand());
                }
            });
        };
    }

    public static IMenuItemProvider stateManagerMenuItemProvider() {
        return MenuItemProviders.stateManagerMenuItemProvider("%MenuItemProviders.stateManager");
    }

    public static IMenuItemProvider stateManagerMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem saveState = new MenuItem(popupMenu, 8);
            saveState.setText(Messages.getLocalizedMessage(menuLabel));
            saveState.setImage(GUIHelper.getDisplayImage("table_icon"));
            saveState.setEnabled(true);
            saveState.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new DisplayPersistenceDialogCommand(natTable));
                }
            });
        };
    }

    public static IMenuItemProvider separatorMenuItemProvider() {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 2);
        };
    }

    public static IMenuItemProvider renameColumnGroupMenuItemProvider() {
        return MenuItemProviders.renameColumnGroupMenuItemProvider("%ColumnGroups.renameColumnGroup");
    }

    public static IMenuItemProvider renameColumnGroupMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
            columnStyleEditor.setText(Messages.getLocalizedMessage(menuLabel));
            columnStyleEditor.setEnabled(true);
            columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int columnPosition = eventData.getColumnPosition();
                        natTable.doCommand(new DisplayColumnGroupRenameDialogCommand(natTable, columnPosition));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider removeColumnGroupMenuItemProvider() {
        return MenuItemProviders.removeColumnGroupMenuItemProvider("%ColumnGroups.removeColumnGroup");
    }

    public static IMenuItemProvider removeColumnGroupMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
            columnStyleEditor.setText(Messages.getLocalizedMessage(menuLabel));
            columnStyleEditor.setEnabled(true);
            columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int columnPosition = eventData.getColumnPosition();
                        int columnIndex = eventData.getNatTable().getColumnIndexByPosition(columnPosition);
                        natTable.doCommand(new RemoveColumnGroupCommand(columnIndex));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider exportToImageMenuItemProvider() {
        return MenuItemProviders.exportToImageMenuItemProvider("%MenuItemProviders.exportToImage");
    }

    public static IMenuItemProvider exportToImageMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem exportToImage = new MenuItem(popupMenu, 8);
            exportToImage.setText(Messages.getLocalizedMessage(menuLabel));
            exportToImage.setImage(GUIHelper.getDisplayImage("export_image"));
            exportToImage.setEnabled(true);
            exportToImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new ExportTableCommand(natTable.getConfigRegistry(), natTable.getShell()));
                }
            });
        };
    }

    public static IMenuItemProvider createRowGroupMenuItemProvider() {
        return MenuItemProviders.createRowGroupMenuItemProvider("%MenuItemProviders.createRowGroup");
    }

    public static IMenuItemProvider createRowGroupMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem createRowGroup = new MenuItem(popupMenu, 8);
            createRowGroup.setText(Messages.getLocalizedMessage(menuLabel));
            createRowGroup.setEnabled(true);
            createRowGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HeaderGroupNameDialog dialog = new HeaderGroupNameDialog(natTable.getShell(), HeaderGroupNameDialog.HeaderGroupNameDialogLabels.CREATE_ROW_GROUP);
                    int result = dialog.open();
                    if (result == 0) {
                        natTable.doCommand(new CreateRowGroupCommand(dialog.getGroupName()));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider ungroupRowsMenuItemProvider() {
        return MenuItemProviders.ungroupRowsMenuItemProvider("%MenuItemProviders.ungroupRows");
    }

    public static IMenuItemProvider ungroupRowsMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem ungroupRow = new MenuItem(popupMenu, 8);
            ungroupRow.setText(Messages.getLocalizedMessage(menuLabel));
            ungroupRow.setEnabled(true);
            ungroupRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new UngroupRowCommand());
                }
            });
        };
    }

    public static IMenuItemProvider renameRowGroupMenuItemProvider() {
        return MenuItemProviders.renameRowGroupMenuItemProvider("%RowGroups.renameRowGroup");
    }

    public static IMenuItemProvider renameRowGroupMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem renameRowGroup = new MenuItem(popupMenu, 8);
            renameRowGroup.setText(Messages.getLocalizedMessage(menuLabel));
            renameRowGroup.setEnabled(true);
            renameRowGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int rowPosition = eventData.getRowPosition();
                        natTable.doCommand(new DisplayRowGroupRenameDialogCommand(natTable, rowPosition));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider removeRowGroupMenuItemProvider() {
        return MenuItemProviders.removeRowGroupMenuItemProvider("%RowGroups.removeRowGroup");
    }

    public static IMenuItemProvider removeRowGroupMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int rowPosition = eventData.getRowPosition();
                        int rowIndex = eventData.getNatTable().getRowIndexByPosition(rowPosition);
                        natTable.doCommand(new RemoveRowGroupCommand(rowIndex));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider freezeColumnMenuItemProvider() {
        return MenuItemProviders.freezeColumnMenuItemProvider("%MenuItemProviders.freezeColumn");
    }

    public static IMenuItemProvider freezeColumnMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int columnPosition = eventData.getColumnPosition();
                        natTable.doCommand(new FreezeColumnCommand(natTable, columnPosition, false, true));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider freezeRowMenuItemProvider() {
        return MenuItemProviders.freezeRowMenuItemProvider("%MenuItemProviders.freezeRow");
    }

    public static IMenuItemProvider freezeRowMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int rowPosition = eventData.getRowPosition();
                        natTable.doCommand(new FreezeRowCommand(natTable, rowPosition, false, true));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider freezePositionMenuItemProvider(boolean include) {
        return MenuItemProviders.freezePositionMenuItemProvider("%MenuItemProviders.freezePosition", include);
    }

    public static IMenuItemProvider freezePositionMenuItemProvider(String menuLabel, final boolean include) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NatEventData eventData = MenuItemProviders.getNatEventData(event);
                    if (eventData != null) {
                        int columnPosition = eventData.getColumnPosition();
                        int rowPosition = eventData.getRowPosition();
                        natTable.doCommand(new FreezePositionCommand(natTable, columnPosition, rowPosition, false, true, include));
                    }
                }
            });
        };
    }

    public static IMenuItemProvider unfreezeMenuItemProvider() {
        return MenuItemProviders.unfreezeMenuItemProvider("%MenuItemProviders.unfreeze");
    }

    public static IMenuItemProvider unfreezeMenuItemProvider(String menuLabel) {
        return (natTable, popupMenu) -> {
            MenuItem menuItem = new MenuItem(popupMenu, 8);
            menuItem.setText(Messages.getLocalizedMessage(menuLabel));
            menuItem.setEnabled(true);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    natTable.doCommand(new UnFreezeGridCommand());
                }
            });
        };
    }
}

