/*******************************************************************************
 * Copyright (c) 2007 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import org.eclipse.jdt.core.IMember;

/**
 * Enumeration representing the code generation status of a Java type
 * {@link IMember member}.
 */
public enum CodeGenStatus {

	/**
	 * Value indicating that the member is not generated by EMF.
	 */
	NONE,

	/**
	 * Value indicating that the member is generated by EMF (i.e., has 
	 * {@code @generated} in its Javadoc comment).
	 */
	GENERATED,

	/**
	 * Value indicating that the member was originally generated by EMF but was
	 * subsequently customized (i.e., has {@code @generated NOT} in its Javadoc
	 * comment).
	 */
	GENERATED_NOT
}
