/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.property;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HbExtraLazyPersistableEList;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernatePersistableEList;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernatePersistableEMap;
import org.eclipse.emf.teneo.hibernate.mapping.elist.MapHibernatePersistableEMap;
import org.eclipse.emf.teneo.hibernate.mapping.property.EcoreAccess;
import org.eclipse.emf.teneo.mapping.elist.MapPersistableEMap;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;
import org.eclipse.emf.teneo.mapping.elist.PersistableEList;
import org.eclipse.emf.teneo.mapping.elist.PersistableEMap;
import org.eclipse.emf.teneo.type.PersistentStoreAdapter;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.eclipse.emf.teneo.util.FieldUtil;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EListPropertyHandler
implements Getter,
Setter,
PropertyAccessor,
ExtensionPoint,
ExtensionManagerAware {
    private static final long serialVersionUID = 2255108246093951341L;
    private static Log log = LogFactory.getLog(EListPropertyHandler.class);
    protected EStructuralFeature eFeature;
    private boolean extraLazy;
    private boolean newEMapMapping;
    private boolean isAMap;
    private ExtensionManager extensionManager;

    public void initialize(EStructuralFeature eFeature, boolean extraLazy, boolean newEMapMapping) {
        this.extraLazy = extraLazy;
        this.eFeature = eFeature;
        log.debug((Object)("Created getter/setter for " + StoreUtil.toString((EStructuralFeature)eFeature)));
        AssertUtil.assertTrue((String)("Many must be true but this isn't the case for " + StoreUtil.toString((EStructuralFeature)eFeature)), (boolean)eFeature.isMany());
        this.isAMap = StoreUtil.isMap((EStructuralFeature)eFeature);
        this.newEMapMapping = newEMapMapping;
    }

    public EStructuralFeature getEFeature() {
        return this.eFeature;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Object get(Object owner) throws HibernateException {
        InternalEObject.EStore eStore;
        PersistentStoreAdapter adapter = HbUtil.getPersistentStoreAdapter((EObject)owner);
        Object value = adapter.getStoreCollection(this.eFeature);
        if (value != null) {
            return value;
        }
        Object obj = ((EObject)owner).eGet(this.eFeature);
        if (StoreUtil.isEStoreList((Object)obj) && (eStore = ((InternalEObject)owner).eStore()).size((InternalEObject)owner, this.eFeature) != -1) {
            obj = eStore.get((InternalEObject)owner, this.eFeature, -1);
        }
        if (obj instanceof PersistableDelegateList) {
            return ((PersistableDelegateList)obj).getDelegate();
        }
        if (obj instanceof EcoreEMap && this.newEMapMapping) {
            return ((EcoreEMap)obj).map();
        }
        if (adapter.isTargetCreatedByORM() && obj instanceof BasicFeatureMap) {
            PersistableDelegateList pelist = (PersistableDelegateList)this.createPersistableList((InternalEObject)owner, this.eFeature, (List)obj);
            EObject eobj = (EObject)owner;
            if (!EcoreAccess.isStaticFeature(this.eFeature, (BasicEObjectImpl)eobj)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Dynamic elist, set using the esettings");
                }
                EcoreAccess.setManyEFeatureValue(this.eFeature, pelist, (BasicEObjectImpl)owner);
            } else {
                Field javaField = FieldUtil.getField(owner.getClass(), (String)this.getFieldName(owner));
                try {
                    javaField.set(owner, pelist);
                }
                catch (Exception e) {
                    throw new HbMapperException("The field " + javaField.getName() + " can not be set using object " + pelist.getClass().getName() + " on target " + owner.getClass().getName(), e);
                }
            }
        }
        if (obj instanceof EList) {
            return this.processList(obj);
        }
        return obj;
    }

    protected String getFieldName(Object owner) {
        return this.eFeature.getName();
    }

    public Object getForInsert(Object owner, Map mergeMap, SessionImplementor session) throws HibernateException {
        InternalEObject.EStore eStore;
        PersistentStoreAdapter adapter = HbUtil.getPersistentStoreAdapter((EObject)owner);
        Object value = adapter.getStoreCollection(this.eFeature);
        if (value != null) {
            return value;
        }
        Object obj = ((EObject)owner).eGet(this.eFeature);
        if (StoreUtil.isEStoreList((Object)obj) && (eStore = ((InternalEObject)owner).eStore()).size((InternalEObject)owner, this.eFeature) != -1) {
            obj = eStore.get((InternalEObject)owner, this.eFeature, -1);
        }
        if (obj instanceof PersistableDelegateList) {
            return ((PersistableDelegateList)obj).getDelegate();
        }
        if (obj instanceof EcoreEMap && this.newEMapMapping) {
            return ((EcoreEMap)obj).map();
        }
        if (obj instanceof EList) {
            return this.processList(obj);
        }
        return obj;
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return EList.class;
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        PersistentStoreAdapter adapter = HbUtil.getPersistentStoreAdapter((EObject)target);
        if (!adapter.isTargetCreatedByORM()) {
            adapter.addStoreCollection(this.eFeature, value);
            return;
        }
        if (!EcoreAccess.isStaticFeature(this.eFeature, (BasicEObjectImpl)target)) {
            InternalEObject.EStore eStore;
            Object currentValue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Dynamic elist, set using the esettings");
            }
            if (StoreUtil.isEStoreList(currentValue = EcoreAccess.getManyEFeatureValue(this.eFeature, (BasicEObjectImpl)target)) && (eStore = ((InternalEObject)target).eStore()).size((InternalEObject)target, this.eFeature) != -1) {
                currentValue = eStore.get((InternalEObject)target, this.eFeature, -1);
            }
            if (currentValue != null && currentValue instanceof PersistableEList) {
                ((PersistableEList)currentValue).replaceDelegate((List)value);
            } else if (value instanceof Map) {
                EcoreAccess.setManyEFeatureValue(this.eFeature, this.createPersistableMap((InternalEObject)target, this.eFeature, (Map)value), (BasicEObjectImpl)target);
            } else {
                EcoreAccess.setManyEFeatureValue(this.eFeature, this.createPersistableList((InternalEObject)target, this.eFeature, (List)value), (BasicEObjectImpl)target);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set value " + value.getClass().getName() + " for target " + target.getClass().getName() + " field " + this.getFieldName(target)));
            }
        } else {
            Field javaField = FieldUtil.getField(target.getClass(), (String)this.getFieldName(target));
            if (javaField == null) {
                adapter.addStoreCollection(this.eFeature, value);
                return;
            }
            try {
                Object currentValue = javaField.get(target);
                if (currentValue == value) {
                    return;
                }
                if (value instanceof EMap.InternalMapView && currentValue == ((EMap.InternalMapView)value).eMap()) {
                    return;
                }
                if (currentValue instanceof PersistableDelegateList && value == ((PersistableDelegateList)currentValue).getDelegate()) {
                    return;
                }
                if (currentValue != null && currentValue instanceof PersistableEList && value != ((PersistableEList)currentValue).getDelegate()) {
                    ((PersistableEList)currentValue).replaceDelegate((List)value);
                } else if (currentValue != null && currentValue instanceof PersistableEMap && value != ((PersistableEMap)currentValue).getDelegate()) {
                    ((PersistableEMap)currentValue).replaceDelegate(value);
                } else if (currentValue != null && currentValue instanceof MapPersistableEMap && value != ((MapPersistableEMap)currentValue).getORMMapDelegate()) {
                    ((PersistableEMap)currentValue).replaceDelegate(value);
                } else if (value instanceof Map) {
                    javaField.set(target, this.createPersistableMap((InternalEObject)target, this.eFeature, (Map)value));
                } else {
                    javaField.set(target, this.createPersistableList((InternalEObject)target, this.eFeature, (List)value));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set value " + value.getClass().getName() + " for target " + target.getClass().getName() + " field " + this.getFieldName(target)));
                }
            }
            catch (Exception e) {
                throw new HbMapperException("The field " + (javaField != null ? javaField.getName() : this.getFieldName(target)) + " can not be set using object " + value.getClass().getName() + " on target " + target.getClass().getName(), e);
            }
        }
    }

    protected EList<?> createPersistableMap(InternalEObject target, EStructuralFeature estruct, Map<?, ?> map) {
        EReference eref = (EReference)estruct;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Detected EMAP for " + estruct.getName()));
        }
        assert (this.isAMap);
        assert (this.newEMapMapping);
        return (EList)this.getExtensionManager().getExtension(MapHibernatePersistableEMap.class, new Object[]{target, eref, map});
    }

    protected EList<?> createPersistableList(InternalEObject target, EStructuralFeature estruct, List<?> list) {
        if (estruct instanceof EReference) {
            EReference eref = (EReference)estruct;
            if (StoreUtil.isMap((EStructuralFeature)estruct)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Detected EMAP for " + estruct.getName()));
                }
                return (EList)this.getExtensionManager().getExtension(HibernatePersistableEMap.class, new Object[]{target, eref, list});
            }
        }
        if (this.extraLazy) {
            return (EList)this.getExtensionManager().getExtension(HbExtraLazyPersistableEList.class, new Object[]{target, estruct, list});
        }
        return (EList)this.getExtensionManager().getExtension(HibernatePersistableEList.class, new Object[]{target, estruct, list});
    }

    protected List<Object> processList(Object list) {
        return new ArrayList<Object>((List)list);
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

