/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.ocl.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectSource;
import org.eclipse.emf.query.conditions.eobjects.IEObjectSource;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EStructuralFeatureValueGetter;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;

public class QueryOCLTest
extends TestCase {
    private Library library = null;

    public static Test suite() {
        return new TestSuite(QueryOCLTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.library == null) {
            this.library = EXTLibraryFactory.eINSTANCE.createLibrary();
            this.library.setName("foo");
            Book b = EXTLibraryFactory.eINSTANCE.createBook();
            b.setTitle("bar");
            this.library.getBooks().add((Object)b);
            Writer w = EXTLibraryFactory.eINSTANCE.createWriter();
            w.setName("aWriter");
            this.library.getWriters().add((Object)w);
            w.getBooks().add((Object)b);
        }
    }

    public void testTrivialOclCondition() throws ParserException {
        SELECT s = new SELECT(new FROM((IEObjectSource)new EObjectSource((EObject)this.library)), new WHERE((EObjectCondition)new BooleanOCLCondition(OCL.newInstance().getEnvironment(), "true", null, EStructuralFeatureValueGetter.getInstance())));
        IQueryResult result = s.execute();
        QueryOCLTest.assertNull((Object)result.getException());
        QueryOCLTest.assertEquals((int)3, (int)result.size());
    }

    public void testSimpleOclCondition() throws ParserException {
        SELECT s = new SELECT(new FROM((IEObjectSource)new EObjectSource((EObject)this.library)), new WHERE((EObjectCondition)new BooleanOCLCondition(OCL.newInstance().getEnvironment(), "title = 'bar'", null, EStructuralFeatureValueGetter.getInstance())));
        IQueryResult result = s.execute();
        QueryOCLTest.assertNull((Object)result.getException());
        QueryOCLTest.assertEquals((int)1, (int)result.size());
    }

    public void testOclCondition() throws ParserException {
        SELECT s = new SELECT(new FROM((IEObjectSource)new EObjectSource((EObject)this.library)), new WHERE((EObjectCondition)new BooleanOCLCondition(OCL.newInstance().getEnvironment(), "author.name = 'aWriter'", (Object)EXTLibraryPackage.eINSTANCE.getBook(), EStructuralFeatureValueGetter.getInstance())));
        IQueryResult result = s.execute();
        QueryOCLTest.assertNull((Object)result.getException());
        QueryOCLTest.assertEquals((int)1, (int)result.size());
    }

    protected void tearDown() throws Exception {
        this.library = null;
        super.tearDown();
    }
}

