/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.explorer.CDOExplorerElement;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.ShowInActionProvider;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Dependency;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.assembly.provider.AssemblyEditPlugin;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.LMManager;
import org.eclipse.emf.cdo.lm.modules.DependencyDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesFactory;
import org.eclipse.emf.cdo.lm.modules.provider.ModulesEditPlugin;
import org.eclipse.emf.cdo.lm.ui.actions.CheckoutAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.ui.decorators.AvailableUpdatesDecorator;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.OverlayImage;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.ui.shared.SharedIcons;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.ui.MenuFiller;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;

public class AssembliesView
extends ContainerView {
    public static final String ID = "org.eclipse.emf.cdo.lm.AssembliesView";
    public static final String SHOW_IN_MENU_ID = "org.eclipse.emf.cdo.lm.AssembliesView.ShowInMenu";
    private final InstallUpdatesAction installUpdatesAction = new InstallUpdatesAction();
    private Font bold;

    protected IAssemblyManager getContainer() {
        return IAssemblyManager.INSTANCE;
    }

    protected void initViewer() {
        this.bold = UIUtil.getBoldFont((Control)this.getViewer().getControl());
        super.initViewer();
    }

    public void dispose() {
        UIUtil.dispose((Font)this.bold);
        super.dispose();
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        IElementFilter rootElementFilter = this.getRootElementFilter();
        return new ContainerView.ContainerViewItemProvider(this, rootElementFilter){

            protected Object[] getContainerChildren(ContainerItemProvider.AbstractContainerNode containerNode, IContainer<?> container) {
                Object[] children = super.getContainerChildren(containerNode, container);
                children = AssembliesView.addNewModules(container, children);
                return children;
            }

            protected ContainerItemProvider.Node createNode(ContainerItemProvider.Node parent, Object element) {
                IAssemblyDescriptor descriptor;
                List errors;
                if (element instanceof IAssemblyDescriptor && !ObjectUtil.isEmpty((Collection)(errors = (descriptor = (IAssemblyDescriptor)element).getResolutionErrors()))) {
                    return new ContainerItemProvider.FixedChildrenNode((ContainerItemProvider)this, parent, element, (Iterable)errors);
                }
                if (element instanceof AssemblyModule) {
                    EList<DependencyDefinition> dependencies = AssembliesView.getDependencies(parent, (AssemblyModule)element);
                    return new ContainerItemProvider.FixedChildrenNode((ContainerItemProvider)this, parent, element, dependencies);
                }
                return super.createNode(parent, element);
            }
        };
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.installUpdatesAction);
        super.fillLocalToolBar(manager);
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            return;
        }
        IWorkbenchPage page = this.getSite().getPage();
        TreeViewer viewer = this.getViewer();
        MenuManager showInMenu = new MenuManager("Show In", SHOW_IN_MENU_ID);
        boolean[] showInFilled = new boolean[1];
        if (selectedElement instanceof AssemblyModule) {
            AssemblyModule module = (AssemblyModule)selectedElement;
            IAssemblyDescriptor descriptor = IAssemblyManager.INSTANCE.getDescriptor((EObject)module);
            if (descriptor != null) {
                ArrayList<CDOCheckout> checkouts = new ArrayList<CDOCheckout>();
                Baseline moduleBaseline = this.addCheckoutActions(manager, descriptor, module);
                if (moduleBaseline != null) {
                    IAssemblyManager.INSTANCE.forEachDescriptor(d -> {
                        if (d.getBaseline() == moduleBaseline) {
                            checkouts.add(d.getCheckout());
                        }
                    });
                }
                String moduleSystemName = module.getAssembly().getSystemName();
                CDOCheckout[] cDOCheckoutArray = CDOExplorerUtil.getCheckoutManager().getCheckouts();
                int n = cDOCheckoutArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOID baselineID;
                    String systemName;
                    Properties properties;
                    CDOCheckout checkout = cDOCheckoutArray[n2];
                    if (!checkout.isOpen() && (properties = LMManager.loadProperties((CDOExplorerElement)checkout)) != null && Objects.equals(systemName = properties.getProperty("systemName"), moduleSystemName) && Objects.equals(baselineID = CDOIDUtil.read((String)properties.getProperty("baselineID")), moduleBaseline.cdoID())) {
                        checkouts.add(checkout);
                    }
                    ++n2;
                }
                if (!checkouts.isEmpty()) {
                    showInMenu.add((IAction)new ShowInActionProvider.ShowInProjectExplorerAction(page, checkouts.toArray(new CDOCheckout[checkouts.size()])));
                    showInFilled[0] = showInFilled[0] | true;
                }
            }
        } else if (selectedElement instanceof IAssemblyDescriptor) {
            IAssemblyDescriptor descriptor = (IAssemblyDescriptor)selectedElement;
            showInMenu.add((IAction)new ShowInActionProvider.ShowInProjectExplorerAction(page, new CDOCheckout[]{descriptor.getCheckout()}));
            showInMenu.add((IAction)new ShowInActionProvider.ShowInSystemExplorerAction(descriptor.getCheckout().getStateFolder("lm")));
            showInFilled[0] = showInFilled[0] | true;
        }
        this.addMenuGroup((IContributionManager)manager, "show-in");
        IPluginContainer.INSTANCE.forEachElement("org.eclipse.net4j.util.ui.menuFillers", MenuFiller.class, filler -> {
            boolean bl = showInFilled[0] | filler.fillMenu(page, (StructuredViewer)viewer, (IMenuManager)showInMenu, selectedElement);
        });
        if (showInFilled[0]) {
            manager.add((IContributionItem)showInMenu);
        }
        this.addMenuGroupAdditions((IContributionManager)manager);
        IPluginContainer.INSTANCE.forEachElement("org.eclipse.net4j.util.ui.menuFillers", MenuFiller.class, filler -> {
            boolean bl = showInFilled[0] | filler.fillMenu(page, (StructuredViewer)viewer, manager, selectedElement);
        });
        this.addMenuGroup((IContributionManager)manager, "errors");
        super.fillContextMenu(manager, selection);
    }

    private Baseline addCheckoutActions(IMenuManager manager, final IAssemblyDescriptor descriptor, final AssemblyModule module) {
        IAssemblyDescriptor.Updates updates = descriptor.getAvailableUpdates();
        if (updates != null) {
            final String moduleName = module.getName();
            final AssemblyModule incomingModule = (AssemblyModule)updates.getModifications().get(moduleName);
            if (incomingModule != null) {
                Baseline baseline = this.addCheckoutAction(manager, descriptor, module);
                this.addCheckoutAction(manager, descriptor, incomingModule);
                manager.add((IAction)new Action("Preview Incoming Changes...", ImageDescriptor.createFromImage((Image)CDOCompareEditorUtil.compareImage())){

                    public void run() {
                        ISystemDescriptor systemDescriptor = descriptor.getSystemDescriptor();
                        CDORepository moduleRepository = systemDescriptor.getModuleRepository(moduleName);
                        CDOSession session = moduleRepository.acquireSession();
                        try {
                            CDOBranchManager branchManager = session.getBranchManager();
                            CDOBranchPoint leftPoint = module.getBranchPoint().resolve(branchManager);
                            CDOBranchPoint rightPoint = incomingModule.getBranchPoint().resolve(branchManager);
                            CDOCompareEditorUtil.openDialog((CDOSession)session, (CDOBranchPoint)leftPoint, (CDOBranchPoint)rightPoint);
                        }
                        finally {
                            moduleRepository.releaseSession();
                        }
                    }
                });
                return baseline;
            }
            AssemblyModule newModule = (AssemblyModule)updates.getAdditions().get(moduleName);
            if (newModule != null) {
                this.addCheckoutAction(manager, descriptor, newModule);
                return descriptor.getBaseline(module);
            }
        }
        if (!module.isRoot()) {
            return this.addCheckoutAction(manager, descriptor, module);
        }
        return descriptor.getBaseline(module);
    }

    private Baseline addCheckoutAction(IMenuManager manager, IAssemblyDescriptor descriptor, AssemblyModule module) {
        Baseline baseline = descriptor.getBaseline(module);
        if (baseline != null) {
            manager.add((IAction)new CheckoutAction(this.getSite().getPage(), baseline));
        }
        return baseline;
    }

    protected void doubleClicked(Object object) {
        super.doubleClicked(object);
        if (object instanceof DependencyDefinition) {
            AssemblyModule module;
            DependencyDefinition definition = (DependencyDefinition)object;
            ContainerItemProvider itemProvider = this.getItemProvider();
            IAssemblyDescriptor descriptor = (IAssemblyDescriptor)itemProvider.getParent((Object)(module = (AssemblyModule)itemProvider.getParent((Object)definition)));
            AssemblyModule target = descriptor.getModule(definition.getTargetName());
            if (target != null) {
                this.selectReveal((ISelection)new StructuredSelection((Object)target));
            }
        }
    }

    protected void selectionChanged(IActionBars bars, ITreeSelection selection) {
        this.installUpdatesAction.selectionChanged((ISelection)selection);
    }

    protected void handleElementEvent(IEvent event) {
        if (event instanceof IAssemblyDescriptor.UpdateStateChangedEvent) {
            UIUtil.asyncExec(() -> this.installUpdatesAction.selectionChanged(this.getSelection()));
        } else if (event instanceof IAssemblyDescriptor.AvailableUpdatesChangedEvent) {
            UIUtil.asyncExec(() -> this.refreshPressed());
        }
    }

    protected ViewerComparator createViewerComparator() {
        return new ViewerComparator(){

            public void sort(Viewer viewer, Object[] elements) {
                if (elements != null && elements.length != 0 && elements[0] instanceof AssemblyModule) {
                    return;
                }
                super.sort(viewer, elements);
            }
        };
    }

    protected String getElementText(Object element) {
        String text = AssembliesView.getText(element);
        if (text != null) {
            return text;
        }
        return super.getElementText(element);
    }

    protected Image getElementImage(Object element) {
        Image image = AssembliesView.getImage(element);
        if (image != null) {
            return image;
        }
        return super.getElementImage(element);
    }

    protected Font getElementFont(Object element) {
        Font font = AssembliesView.getFont(element, this.bold, (ContainerItemProvider<IContainer<Object>>)this.getItemProvider());
        if (font != null) {
            return font;
        }
        return super.getElementFont(element);
    }

    protected Color getElementForeground(Object element) {
        Color foreground = AssembliesView.getForeground(element, this.getDisplay());
        if (foreground != null) {
            return foreground;
        }
        return super.getElementForeground(element);
    }

    private static boolean isModuleAddition(Object element) {
        AssemblyModule module;
        IAssemblyDescriptor descriptor;
        return element instanceof AssemblyModule && (descriptor = IAssemblyManager.INSTANCE.getDescriptor((EObject)(module = (AssemblyModule)element))) != null && descriptor.getModule(module.getName()) == null;
    }

    public static Object[] addNewModules(IContainer<?> container, Object[] children) {
        Collection newModules;
        IAssemblyDescriptor descriptor;
        IAssemblyDescriptor.Updates updates;
        if (container instanceof IAssemblyDescriptor && (updates = (descriptor = (IAssemblyDescriptor)container).getAvailableUpdates()) != null && !(newModules = updates.getAdditions().values()).isEmpty()) {
            ArrayList<AssemblyModule> list = new ArrayList<AssemblyModule>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                list.add((AssemblyModule)child);
                ++n2;
            }
            for (AssemblyModule newModule : newModules) {
                list.add(newModule);
            }
            children = list.toArray(new AssemblyModule[list.size()]);
        }
        return children;
    }

    public static EList<DependencyDefinition> getDependencies(ContainerItemProvider.Node parent, AssemblyModule module) {
        IAssemblyDescriptor descriptor = IAssemblyManager.INSTANCE.getDescriptor((EObject)module);
        Baseline baseline = descriptor.getBaseline(module);
        if (baseline instanceof FixedBaseline) {
            EList dependencies = ((FixedBaseline)baseline).getDependencies();
            BasicEList definitions = new BasicEList(dependencies.size());
            for (Dependency dependency : dependencies) {
                DependencyDefinition definition = ModulesFactory.eINSTANCE.createDependencyDefinition(dependency.getTarget().getName(), dependency.getVersionRange());
                definitions.add((Object)definition);
            }
            return definitions;
        }
        Annotation annotation = module.getAnnotation("http://www.eclipse.org/CDO/LM");
        if (annotation != null) {
            EList contents = annotation.getContents();
            BasicEList definitions = new BasicEList(contents.size());
            for (EObject content : contents) {
                if (!(content instanceof DependencyDefinition)) continue;
                DependencyDefinition definition = (DependencyDefinition)content;
                definitions.add((Object)definition);
            }
            return definitions;
        }
        return ECollections.emptyEList();
    }

    public static String getText(Object element) {
        if (element instanceof IAssemblyDescriptor) {
            IAssemblyDescriptor descriptor = (IAssemblyDescriptor)element;
            return descriptor.getName() + " [" + descriptor.getAssembly().getSystemName() + "]";
        }
        if (element instanceof AssemblyModule) {
            AssemblyModule module = (AssemblyModule)element;
            return module.getName() + " " + AvailableUpdatesDecorator.getSuffix(module);
        }
        if (element instanceof DependencyDefinition) {
            DependencyDefinition dependency = (DependencyDefinition)element;
            VersionRange versionRange = dependency.getVersionRange();
            Object text = dependency.getTargetName();
            if (versionRange != null) {
                text = (String)text + " " + String.valueOf(versionRange);
            }
            return text;
        }
        return null;
    }

    public static Image getImage(Object element) {
        if (element instanceof IAssemblyDescriptor) {
            IAssemblyDescriptor descriptor = (IAssemblyDescriptor)element;
            Object imageKey = AssemblyEditPlugin.INSTANCE.getImage("full/obj16/Assembly");
            List resolutionErrors = descriptor.getResolutionErrors();
            if (!ObjectUtil.isEmpty((Collection)resolutionErrors)) {
                return ExtendedImageRegistry.INSTANCE.getImage((Object)new OverlayImage(imageKey, (Object)org.eclipse.emf.cdo.ui.shared.SharedIcons.getImage((String)"ovr16/error.gif"), 8, 8));
            }
            return ExtendedImageRegistry.INSTANCE.getImage(imageKey);
        }
        if (element instanceof AssemblyModule) {
            return ExtendedImageRegistry.INSTANCE.getImage(AssemblyEditPlugin.INSTANCE.getImage(AssembliesView.isModuleAddition(element) ? "full/obj16/AssemblyModuleDisabled" : "full/obj16/AssemblyModule"));
        }
        if (element instanceof DependencyDefinition) {
            return ExtendedImageRegistry.INSTANCE.getImage(ModulesEditPlugin.INSTANCE.getImage("full/obj16/DependencyDefinition"));
        }
        if (element instanceof String) {
            return SharedIcons.getImage((String)"obj16/error");
        }
        return null;
    }

    public static Font getFont(Object element, Font bold, ContainerItemProvider<IContainer<Object>> itemProvider) {
        DependencyDefinition definition;
        AssemblyModule module;
        AssemblyModule module2;
        if (element instanceof AssemblyModule && (module2 = (AssemblyModule)element).isRoot()) {
            return bold;
        }
        if (element instanceof DependencyDefinition && (module = (AssemblyModule)itemProvider.getParent((Object)(definition = (DependencyDefinition)element))).isRoot()) {
            return bold;
        }
        return null;
    }

    public static Color getForeground(Object element, Display display) {
        if (AssembliesView.isModuleAddition(element)) {
            return display.getSystemColor(16);
        }
        return null;
    }

    private static final class InstallUpdatesAction
    extends LongRunningAction {
        private IAssemblyDescriptor descriptor;

        public InstallUpdatesAction() {
            super("Install Updates...", OM.getImageDescriptor("icons/Update.gif"));
            this.setToolTipText("Install the available updates into the checkout");
            this.setEnabled(false);
        }

        public void selectionChanged(ISelection selection) {
            this.descriptor = (IAssemblyDescriptor)UIUtil.adaptElement((ISelection)selection, IAssemblyDescriptor.class);
            if (this.descriptor == null) {
                EObject assemblyElement = (EObject)UIUtil.adaptElement((ISelection)selection, EObject.class);
                this.descriptor = IAssemblyManager.INSTANCE.getDescriptor(assemblyElement);
            }
            this.setEnabled(this.descriptor != null && this.descriptor.hasUpdatesAvailable());
        }

        protected void doRun(IProgressMonitor progressMonitor) throws Exception {
            if (this.isEnabled()) {
                this.descriptor.update();
            }
        }
    }
}

