/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Process;
import org.eclipse.emf.cdo.lm.internal.server.bundle.OM;
import org.eclipse.emf.cdo.lm.server.XMLLifecycleManager;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.AppExtension;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryConfigurator;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.XMLUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.PropertiesFactory;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LMAppExtension
extends AppExtension {
    private static final String DEFAULT_LIFECYCLE_MANAGER_TYPE = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.lm.server.LMAppExtension.DEFAULT_LIFECYCLE_MANAGER_TYPE", "default");
    private static final Map<InternalRepository, XMLLifecycleManager> LIFECYCLE_MANAGERS = Collections.synchronizedMap(new HashMap());

    public String getName() {
        return "Lifecycle management";
    }

    protected void start(InternalRepository repository, Element repositoryConfig) throws Exception {
        NodeList lmElements = repositoryConfig.getElementsByTagName("lifecycleManager");
        int length = lmElements.getLength();
        if (length > 1) {
            throw new IllegalStateException("At most one lifecycle manager must be configured for repository " + repository.getName());
        }
        if (length == 1) {
            Element lmElement = (Element)lmElements.item(0);
            this.configureLifecycleManager(repository, lmElement);
        }
    }

    protected void stop(InternalRepository repository) throws Exception {
        XMLLifecycleManager lifecycleManager = LIFECYCLE_MANAGERS.remove(repository);
        if (lifecycleManager != null) {
            OM.LOG.info("Deactivating lifecycle manager of repository " + repository.getName());
            lifecycleManager.deactivate();
        }
    }

    private void configureLifecycleManager(InternalRepository repository, Element lmElement) {
        NodeList moduleTemplateElements;
        int length;
        String systemName = this.getAttribute(lmElement, "systemName");
        if (StringUtil.isEmpty((String)systemName)) {
            throw new IllegalStateException("A systemName must be specified for the lifecycle manager of repository " + repository.getName());
        }
        String moduleDefinitionPath = this.getAttribute(lmElement, "moduleDefinitionPath");
        if (StringUtil.isEmpty((String)moduleDefinitionPath)) {
            moduleDefinitionPath = "module.md";
        }
        if ((length = (moduleTemplateElements = lmElement.getElementsByTagName("moduleTemplate")).getLength()) != 1) {
            throw new IllegalStateException("Exactly one module template must be configured for the lifecycle manager of repository " + repository.getName());
        }
        Element moduleTemplateElement = (Element)moduleTemplateElements.item(0);
        XMLLifecycleManager lifecycleManager = this.createLifecycleManager(repository, lmElement);
        lifecycleManager.setSystemRepository(repository);
        lifecycleManager.setSystemName(systemName);
        lifecycleManager.setModuleDefinitionPath(moduleDefinitionPath);
        lifecycleManager.setModuleTemplateElement(moduleTemplateElement);
        IPasswordCredentials credentials = this.createCredentials(lmElement);
        lifecycleManager.setCredentials(credentials);
        Consumer<Process> processInitializer = this.createProcessInitializater(lmElement);
        lifecycleManager.setProcessInitializer(processInitializer);
        OM.LOG.info("Activating lifecycle manager of repository " + repository.getName());
        lifecycleManager.activate();
        LIFECYCLE_MANAGERS.put(repository, lifecycleManager);
    }

    protected String getDefaultLifecycleManagerType() {
        return DEFAULT_LIFECYCLE_MANAGER_TYPE;
    }

    protected XMLLifecycleManager createLifecycleManager(InternalRepository repository, Element lmElement) {
        IManagedContainer container = repository.getContainer();
        String lifecycleManagerType = this.getDefaultLifecycleManagerType();
        return (XMLLifecycleManager)((Object)this.getContainerElement(lmElement, lifecycleManagerType, "systemName", container));
    }

    protected IPasswordCredentials createCredentials(Element lmElement) {
        IPasswordCredentials[] credentials = new IPasswordCredentials[1];
        try {
            XMLUtil.handleChildElements((Element)lmElement, child -> {
                if ("credentials".equals(child.getTagName())) {
                    if (credentials[0] == null) {
                        String userID = this.getAttribute(child, "userId");
                        if (StringUtil.isEmpty((String)userID)) {
                            throw new IllegalStateException("userId not specified");
                        }
                        String password = this.getAttribute(child, "password");
                        if (StringUtil.isEmpty((String)password)) {
                            throw new IllegalStateException("Password not specified");
                        }
                        iPasswordCredentialsArray[0] = new PasswordCredentials(userID, password);
                    } else {
                        OM.LOG.info("Multiple credentials specified. Using first.");
                    }
                }
            });
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        return credentials[0];
    }

    protected Consumer<Process> createProcessInitializater(Element lmElement) {
        Collection<ModuleType> moduleTypes = this.getModuleTypes(lmElement);
        Collection<DropType> dropTypes = this.getDropTypes(lmElement);
        if (!ObjectUtil.isEmpty(moduleTypes) || !ObjectUtil.isEmpty(dropTypes)) {
            return process -> {
                process.getModuleTypes().addAll(moduleTypes);
                process.getDropTypes().addAll(dropTypes);
            };
        }
        return null;
    }

    protected Collection<ModuleType> getModuleTypes(Element lmElement) {
        return this.getNamedChildren(lmElement, "moduleType", (child, name) -> LMFactory.eINSTANCE.createModuleType(name));
    }

    protected Collection<DropType> getDropTypes(Element lmElement) {
        return this.getNamedChildren(lmElement, "dropType", (child, name) -> {
            boolean release = StringUtil.isTrue((String)this.getAttribute((Element)child, "release"));
            return LMFactory.eINSTANCE.createDropType(name, release);
        });
    }

    private <T> Collection<T> getNamedChildren(Element lmElement, String childTagName, BiFunction<Element, String, T> childCreator) {
        ArrayList<T> result = new ArrayList<T>();
        NodeList elements = lmElement.getElementsByTagName(childTagName);
        int i = 0;
        int length = elements.getLength();
        while (i < length) {
            Element element = (Element)elements.item(i);
            String name = this.getAttribute(element, "name");
            if (!StringUtil.isEmpty((String)name)) {
                T child = childCreator.apply(element, name);
                result.add(child);
            }
            ++i;
        }
        return result;
    }

    private <T> T getContainerElement(Element element, String defaultType, String descriptionAttribute, IManagedContainer container) {
        String description;
        String type = this.getAttribute(element, "type");
        if (StringUtil.isEmpty((String)type)) {
            type = defaultType;
        }
        if (StringUtil.isEmpty((String)descriptionAttribute)) {
            descriptionAttribute = "description";
        }
        if (StringUtil.isEmpty((String)(description = this.getAttribute(element, descriptionAttribute)))) {
            Map properties = RepositoryConfigurator.getProperties((Element)element, (int)1, null, (IManagedContainer)container);
            description = PropertiesFactory.createDescription((Map)properties);
        }
        Object containerElement = container.getElement("org.eclipse.emf.cdo.lm.server.lifecycleManagers", type, description, false);
        return (T)containerElement;
    }

    public static XMLLifecycleManager getLifecycleManager(IRepository repository) {
        return LIFECYCLE_MANAGERS.get(repository);
    }

    @Deprecated
    protected Map<String, String> initializeModuleTypesDefinition() {
        return Collections.emptyMap();
    }

    @Deprecated
    protected Map<String, Boolean> initializeDropTypesDefinition() {
        HashMap<String, Boolean> dropTypes = new HashMap<String, Boolean>();
        dropTypes.put("Tag", false);
        dropTypes.put("Milestone", false);
        dropTypes.put("Release", true);
        return dropTypes;
    }
}

