/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui;

import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.DropType;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.CommentStatus;
import org.eclipse.emf.cdo.lm.reviews.Commentable;
import org.eclipse.emf.cdo.lm.reviews.DeliveryReview;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewStatus;
import org.eclipse.emf.cdo.lm.reviews.provider.ReviewsEditPlugin;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.AbandonReviewAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.DeleteReviewAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.MergeFromSourceAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.NewCommentAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.NewDeliveryReviewAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.NewDropReviewAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.RebaseToTargetAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.ResolveCommentAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.RestoreReviewAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.SubmitReviewAction;
import org.eclipse.emf.cdo.lm.reviews.ui.actions.UnresolveCommentAction;
import org.eclipse.emf.cdo.lm.ui.actions.CheckoutAction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.ui.MenuFiller;
import org.eclipse.ui.IWorkbenchPage;

public class ReviewsMenuFiller
implements MenuFiller {
    public boolean fillMenu(IWorkbenchPage page, StructuredViewer viewer, IMenuManager menu, Object selectedElement) {
        Commentable commentable;
        Review review;
        if (selectedElement instanceof Stream) {
            Stream stream = (Stream)selectedElement;
            menu.add((IAction)new NewDeliveryReviewAction(page, viewer, stream, null));
        } else if (selectedElement instanceof Change) {
            Change change = (Change)selectedElement;
            for (Stream s : change.getModule().getStreams()) {
                if (change.getDeliveryPoint(s) != null) continue;
                menu.add((IAction)new NewDeliveryReviewAction(page, viewer, s, change));
            }
        } else if (selectedElement instanceof Delivery) {
            Delivery delivery = (Delivery)selectedElement;
            EList possibleDropTypes = delivery.getSystem().getProcess().getDropTypes();
            for (DropType dropType : possibleDropTypes) {
                menu.add((IAction)new NewDropReviewAction(page, viewer, delivery, dropType));
            }
        } else if (selectedElement instanceof Review) {
            Review review2 = (Review)selectedElement;
            menu.add((IAction)new CheckoutAction(page, (ResourceLocator)ReviewsEditPlugin.INSTANCE, null, (Baseline)review2));
            menu.add((IContributionItem)new Separator());
            ReviewStatus status = review2.getStatus();
            switch (status) {
                case NEW: {
                    this.addSubmitAction(page, viewer, menu, review2);
                    menu.add((IAction)new AbandonReviewAction(page, review2));
                    menu.add((IAction)new DeleteReviewAction(page, review2));
                    break;
                }
                case SOURCE_OUTDATED: {
                    menu.add((IAction)new MergeFromSourceAction(page, review2));
                    this.addSubmitAction(page, viewer, menu, review2);
                    menu.add((IAction)new AbandonReviewAction(page, review2));
                    menu.add((IAction)new DeleteReviewAction(page, review2));
                    break;
                }
                case TARGET_OUTDATED: {
                    menu.add((IAction)new RebaseToTargetAction(page, review2));
                    menu.add((IAction)new AbandonReviewAction(page, review2));
                    menu.add((IAction)new DeleteReviewAction(page, review2));
                    break;
                }
                case OUTDATED: {
                    menu.add((IAction)new MergeFromSourceAction(page, review2));
                    menu.add((IAction)new RebaseToTargetAction(page, review2));
                    menu.add((IAction)new AbandonReviewAction(page, review2));
                    menu.add((IAction)new DeleteReviewAction(page, review2));
                    break;
                }
                case ABANDONED: {
                    menu.add((IAction)new RestoreReviewAction(page, review2));
                    break;
                }
            }
        }
        if (selectedElement instanceof Commentable && ((review = (commentable = (Commentable)selectedElement).getReview()) == null || review.getStatus().isOpen())) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)new NewCommentAction(page, viewer, commentable, true));
            menu.add((IAction)new NewCommentAction(page, viewer, commentable, false));
            if (commentable instanceof Comment) {
                Comment comment = (Comment)commentable;
                CommentStatus status = comment.getStatus();
                if (status == CommentStatus.UNRESOLVED) {
                    menu.add((IContributionItem)new Separator());
                    menu.add((IAction)new ResolveCommentAction(page, comment));
                } else if (status == CommentStatus.NONE || status == CommentStatus.RESOLVED) {
                    menu.add((IContributionItem)new Separator());
                    menu.add((IAction)new UnresolveCommentAction(page, comment));
                }
            }
        }
        return false;
    }

    private void addSubmitAction(IWorkbenchPage page, StructuredViewer viewer, IMenuManager menu, Review review) {
        if (review.getUnresolvedCount() > 0) {
            return;
        }
        if (review instanceof DeliveryReview) {
            DeliveryReview deliveryReview = (DeliveryReview)review;
            Stream stream = deliveryReview.getStream();
            Change sourceChange = deliveryReview.getSourceChange();
            if (sourceChange.getDeliveryPoint(stream) != null) {
                return;
            }
        }
        menu.add((IAction)new SubmitReviewAction(page, viewer, review));
    }

    public static final class Factory
    extends MenuFiller.Factory {
        public static final String TYPE = "lm.reviews";

        public Factory() {
            super(TYPE);
        }

        public MenuFiller create(String description) throws ProductCreationException {
            return new ReviewsMenuFiller();
        }
    }
}

