/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.trace;

import java.util.Stack;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.trace.Element;
import org.eclipse.net4j.trace.Listener;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.om.OMPlatform;

public class BufferTracer {
    public static final Listener LISTENER = BufferTracer.createListener();
    private static final ThreadLocal<Stack<Call>> CALL_STACKS = new ThreadLocal<Stack<Call>>(){

        @Override
        protected Stack<Call> initialValue() {
            return new Stack<Call>();
        }
    };
    private static final ThreadLocal<Boolean> EXECUTION = new ThreadLocal();

    public static void setThreadName(Thread thread, String name) {
        Element element = Element.getOrNull(thread);
        if (element instanceof Element.ThreadElement) {
            Element.ThreadElement threadElement = (Element.ThreadElement)element;
            threadElement.setName(name);
        }
    }

    public static Stack<Call> execution(Object object, String method, Stack<Call> callStack) {
        if (EXECUTION.get() == null) {
            try {
                try {
                    EXECUTION.set(Boolean.TRUE);
                    if (callStack == null) {
                        Call lastCall;
                        callStack = CALL_STACKS.get();
                        Call call = lastCall = callStack.isEmpty() ? null : callStack.peek();
                        if (lastCall != null) {
                            Object owner = lastCall.getObject();
                            Element caller = Element.get(owner);
                            Element callee = Element.get(object);
                            if (object instanceof IBuffer) {
                                ((Element.BufferElement)callee).setOwner(owner);
                            }
                            LISTENER.methodCalled(caller, lastCall.getMethod(), callee, method);
                        }
                        callStack.push(new Call(object, method));
                    } else {
                        callStack.pop();
                        if (object instanceof IBuffer) {
                            IBuffer buffer = (IBuffer)object;
                            Call lastCall = callStack.peek();
                            if (lastCall != null) {
                                BufferTracer.handleBuffer(buffer, lastCall.getObject(), lastCall.getMethod(), method);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    EXECUTION.remove();
                }
            }
            finally {
                EXECUTION.remove();
            }
        }
        return callStack;
    }

    private static void handleBuffer(IBuffer buffer, Object caller, String callingMethod, String calledMethod) {
        Element.BufferElement element = Element.get(buffer);
        if ("setBufferProvider".equals(calledMethod)) {
            element.setProvider(buffer.getBufferProvider());
        } else {
            element.update(buffer.getState(), buffer.getPosition(), buffer.getLimit(), buffer.isEOS(), buffer.isCCAM());
        }
    }

    private static Listener createListener() {
        String type = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.trace.listenerType");
        if (type != null) {
            String description = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.trace.listenerDescription");
            return (Listener)IPluginContainer.INSTANCE.getElement("org.eclipse.net4j.trace.listeners", type, description);
        }
        return new DefaultListener();
    }

    public static final class Call {
        private final Object object;
        private final String method;

        public Call(Object object, String method) {
            this.object = object;
            this.method = method;
        }

        public Object getObject() {
            return this.object;
        }

        public String getMethod() {
            return this.method;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Call[object=");
            builder.append(this.object);
            builder.append(", method=");
            builder.append(this.method);
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class DefaultListener
    implements Listener {
        private DefaultListener() {
        }

        @Override
        public void methodCalled(Element caller, String callingMethod, Element callee, String calledMethod) {
        }

        @Override
        public void elementCreated(Element element) {
        }

        @Override
        public void ownerChanged(Element.BufferElement element, Element oldOwner, Element newOwner) {
        }

        @Override
        public void threadChanged(Element.BufferElement element, Element oldThread, Element newThread) {
        }

        @Override
        public void stateChanged(Element.BufferElement element, BufferState oldState, BufferState newState) {
        }

        @Override
        public void positionChanged(Element.BufferElement element, int oldPosition, int newPosition) {
        }

        @Override
        public void limitChanged(Element.BufferElement element, int oldLimit, int newLimit) {
        }

        @Override
        public void eosChanged(Element.BufferElement element, boolean newEOS) {
        }

        @Override
        public void ccamChanged(Element.BufferElement element, boolean newCCAM) {
        }
    }
}

