/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.editors.impl;

import java.util.List;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.event.IListener;

public abstract class DawnAbstractEditorSupport
implements IDawnEditorSupport {
    private final IDawnEditor editor;
    private CDOView view;
    private boolean dirty;

    @Override
    public CDOView getView() {
        return this.view;
    }

    @Override
    public void setView(CDOView view) {
        this.view = view;
    }

    public DawnAbstractEditorSupport(IDawnEditor editor) {
        this.editor = editor;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public IDawnEditor getEditor() {
        return this.editor;
    }

    @Override
    public void registerListeners() {
        BasicDawnListener lockingHandler;
        BasicDawnListener listener = this.getBasicHandler();
        CDOView view = this.getView();
        if (listener != null) {
            view.addListener((IListener)listener);
        }
        if ((lockingHandler = this.getLockingHandler()) != null) {
            view.addListener((IListener)lockingHandler);
            view.options().setLockNotificationEnabled(true);
        }
        if (view instanceof CDOTransaction) {
            CDOTransaction transaction = (CDOTransaction)view;
            CDOTransactionHandlerBase transactionHandler = this.getTransactionHandler();
            if (transactionHandler != null) {
                transaction.addTransactionHandler(transactionHandler);
            }
            transaction.options().addChangeSubscriptionPolicy(CDOAdapterPolicy.CDO);
            transaction.options().setAutoReleaseLocksEnabled(false);
        }
    }

    protected abstract BasicDawnListener getBasicHandler();

    protected abstract BasicDawnListener getLockingHandler();

    protected abstract CDOTransactionHandlerBase getTransactionHandler();

    @Override
    public void rollback() {
        CDOView view = this.getEditor().getView();
        if (view != null && view instanceof CDOTransaction) {
            ((CDOTransaction)view).rollback();
        }
    }

    @Override
    public void lockObjects(List<Object> objectsToBeLocked) {
        for (Object objectToBeLocked : objectsToBeLocked) {
            this.lockObject(objectToBeLocked);
        }
    }

    @Override
    public void unlockObjects(List<Object> objectsToBeLocked) {
        for (Object objectToBeUnlocked : objectsToBeLocked) {
            this.unlockObject(objectToBeUnlocked);
        }
    }
}

