/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessage;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessageEx;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.ITransformationMaker;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.QvtConfigurationProperty;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.QvtRuntimeUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.QvtTransformationConfigurationUI;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.ApplyTransformationData;
import org.eclipse.m2m.internal.qvt.oml.runtime.util.MiscUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class QvtTransformationConfigurationTab
extends AbstractLaunchConfigurationTab {
    private final ApplyTransformationData myData;
    private final QvtTransformationConfigurationUI myUI;
    private final ITransformationMaker myTransformationMaker;

    public QvtTransformationConfigurationTab(ITransformationMaker transformationMaker) {
        this.myTransformationMaker = transformationMaker;
        this.myData = new ApplyTransformationData();
        this.myUI = new QvtTransformationConfigurationUI(this.myData, (ISetMessage)new ISetMessageEx(){

            public void setErrorMessage(String message) {
                QvtTransformationConfigurationTab.this.setErrorMessage(message);
                QvtTransformationConfigurationTab.this.getLaunchConfigurationDialog().updateMessage();
            }

            public void setMessage(String message) {
                QvtTransformationConfigurationTab.this.setMessage(message);
                QvtTransformationConfigurationTab.this.getLaunchConfigurationDialog().updateMessage();
            }

            public void setWarningMessage(String message) {
                QvtTransformationConfigurationTab.this.setWarningMessage(message);
                QvtTransformationConfigurationTab.this.getLaunchConfigurationDialog().updateMessage();
            }
        });
        this.myUI.addPropertyChangeListener(new QvtTransformationConfigurationUI.PropertyChangeListener(){

            public void changePerformed(QvtConfigurationProperty property) {
                QvtTransformationConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.myUI.createControl(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String fileName = "";
        try {
            fileName = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", "");
        }
        catch (CoreException e) {
            QvtRuntimeUIPlugin.getDefault().getLog().log(MiscUtil.makeErrorStatus((Exception)((Object)e)));
        }
        QvtTransformation qvtTransformation = null;
        try {
            qvtTransformation = this.myTransformationMaker.makeTransformation(fileName);
        }
        catch (MdaException mdaException) {
            // empty catch block
        }
        this.myData.setTransformation(qvtTransformation);
        Map valueMap = Collections.emptyMap();
        try {
            valueMap = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties", Collections.emptyMap());
        }
        catch (CoreException e) {
            QvtRuntimeUIPlugin.getDefault().getLog().log(MiscUtil.makeErrorStatus((Exception)((Object)e)));
        }
        this.myData.getConfiguration().clear();
        this.myData.getConfiguration().putAll(valueMap);
        this.myUI.loadValues();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.myUI.performApply();
        HashMap<String, String> map = new HashMap<String, String>(this.myData.getConfiguration());
        configuration.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties", map);
    }

    public String getName() {
        return Messages.QvtTransformationConfigurationTab_Name;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.myUI.validate();
        return this.myUI.isValid();
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }
}

