/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.bigmde2016.tests.atl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.emf.EMFInjector;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.engine.emfvm.launch.EMFVMLauncher;
import org.eclipse.qvtd.doc.bigmde2016.tests.FamiliesGenerator;
import org.eclipse.qvtd.doc.bigmde2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.BigMDE2016CGTests;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Families.FamiliesPackage;
import org.eclipse.qvtd.doc.bigmde2016.tests.qvtc.Persons.PersonsPackage;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class BigMDE2016ATLTests
extends TestCase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testQVTcCompiler_Families2Persons_ATL() throws Exception {
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        EMFVMLauncher transformationLauncher = new EMFVMLauncher();
        EMFModelFactory modelFactory = new EMFModelFactory();
        ResourceSet resourceSet = modelFactory.getResourceSet();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Families", (Object)FamiliesPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Persons", (Object)PersonsPackage.eINSTANCE);
        EMFInjector injector = new EMFInjector();
        EMFReferenceModel familiesMetamodel = (EMFReferenceModel)modelFactory.newReferenceModel();
        injector.inject((IModel)familiesMetamodel, "http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Families");
        EMFReferenceModel personsMetamodel = (EMFReferenceModel)modelFactory.newReferenceModel();
        injector.inject((IModel)personsMetamodel, "http://www.eclipse.org/qvtd/xtext/qvtcore/tests/Upper2Lower/1.0/Persons");
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                EMFModel familiesModel = (EMFModel)modelFactory.newModel((IReferenceModel)familiesMetamodel);
                Resource familiesResource = resourceSet.createResource(URI.createURI((String)"src/org/eclipse/qvtd/doc/bigmde2016/tests/atl/samples-Families.xmi"));
                try {
                    familiesResource.load(new InputStream(){

                        @Override
                        public int read() {
                            return -1;
                        }

                        @Override
                        public int available() {
                            return 0;
                        }
                    }, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                injector.inject((IModel)familiesModel, "src/org/eclipse/qvtd/doc/bigmde2016/tests/atl/samples-Families.xmi");
                List<@NonNull ? extends EObject> rootObjects = FamiliesGenerator.createFamiliesModel(testSize, 9);
                familiesResource.getContents().clear();
                familiesResource.getContents().addAll(rootObjects);
                EMFModel personsModel = (EMFModel)modelFactory.newModel((IReferenceModel)personsMetamodel);
                transformationLauncher.initialize(new HashMap());
                transformationLauncher.addInModel((IModel)familiesModel, "IN", "Families");
                transformationLauncher.addOutModel((IModel)personsModel, "OUT", "Persons");
                logger.printf("%9d, ", 10 * testSize);
                BigMDE2016CGTests.garbageCollect();
                long startTime = System.nanoTime();
                transformationLauncher.launch("run", (IProgressMonitor)new NullProgressMonitor(), new HashMap(), new Object[]{new FileInputStream("src/org/eclipse/qvtd/doc/bigmde2016/tests/atl/Families2Persons.asm")});
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                Resource personsResource = personsModel.getResource();
                @NonNull EList rootObjects2 = personsResource.getContents();
                assert (rootObjects2.size() == 9 * testSize);
                modelFactory.unload(personsModel);
                modelFactory.unload(familiesModel);
                ++n2;
            }
        }
        finally {
            modelFactory.unload((EMFModel)familiesMetamodel);
            modelFactory.unload((EMFModel)personsMetamodel);
            logger.dispose();
        }
    }

    static class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

