/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElementNamespaceParser
extends DefaultHandler {
    public static final String XML_PREFIX_COLON = "xmlns:";
    protected Set<String> elementURIs = new HashSet<String>();
    protected Map<String, String> xmlnsMap = null;
    protected List<String> typePrefixes = new ArrayList<String>();

    public static String parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        Set<String> elementURIs = new XMLElementNamespaceParser().parseAll(inputStream);
        return elementURIs.size() > 0 ? elementURIs.iterator().next() : null;
    }

    public Set<String> parseAll(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        parser.parse(inputStream, (DefaultHandler)this);
        return this.elementURIs;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        int iMax;
        boolean atRoot;
        boolean bl = atRoot = this.xmlnsMap == null;
        if (atRoot) {
            this.xmlnsMap = new HashMap<String, String>();
            iMax = attributes.getLength();
            int i = 0;
            while (i < iMax) {
                String qName = attributes.getQName(i);
                if (qName.equals("xmlns")) {
                    this.xmlnsMap.put("", attributes.getValue(i));
                } else if (qName.startsWith(XML_PREFIX_COLON)) {
                    this.xmlnsMap.put(qName.substring(XML_PREFIX_COLON.length()), attributes.getValue(i));
                }
                ++i;
            }
            for (String key : this.xmlnsMap.keySet()) {
                String value = this.xmlnsMap.get(key);
                if ("http://www.w3.org/2001/XMLSchema-instance".equals(value)) {
                    this.typePrefixes.add(key);
                    continue;
                }
                if (!"http://www.omg.org/XMI".equals(value)) continue;
                this.typePrefixes.add(key);
            }
        }
        iMax = attributes.getLength();
        int i = 0;
        while (i < iMax) {
            int typeColonAt;
            String typeQName = attributes.getQName(i);
            if (typeQName.endsWith("type") && (typeColonAt = typeQName.indexOf(58)) + 5 == typeQName.length()) {
                String namespace;
                String string = namespace = typeColonAt >= 0 ? typeQName.substring(0, typeColonAt) : "";
                if (this.typePrefixes.contains(namespace)) {
                    String valueQName = attributes.getValue(i);
                    int valueColonAt = valueQName.indexOf(58);
                    if (valueColonAt >= 0) {
                        this.elementURIs.add(this.xmlnsMap.get(valueQName.substring(0, valueColonAt)));
                    } else if (atRoot) {
                        this.elementURIs.add(this.xmlnsMap.get(""));
                    }
                }
            }
            ++i;
        }
        int colonAt = name.indexOf(58);
        if (colonAt >= 0) {
            this.elementURIs.add(this.xmlnsMap.get(name.substring(0, colonAt)));
        } else if (atRoot) {
            this.elementURIs.add(this.xmlnsMap.get(""));
        }
    }
}

