/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import lpg.lpgjavaruntime.IToken;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.ITokenColorer;
import org.eclipse.imp.services.base.TokenColorerBase;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseController;
import org.eclipse.swt.widgets.Display;

public class CommonTokenColorer
extends TokenColorerBase
implements ITokenColorer {
    protected TextAttribute lineCommentAttribute;
    protected TextAttribute paragraphCommentAttribute;
    protected TextAttribute keywordAttribute;
    protected TextAttribute stringAttribute;
    protected TextAttribute integerAttribute;
    protected TextAttribute realAttribute;
    protected TextAttribute identifierAttribute;

    public CommonTokenColorer() {
        Display display = Display.getDefault();
        this.lineCommentAttribute = new TextAttribute(display.getSystemColor(4), null, 2);
        this.paragraphCommentAttribute = new TextAttribute(display.getSystemColor(4), null, 2);
        this.stringAttribute = new TextAttribute(display.getSystemColor(10), null, 1);
        this.identifierAttribute = new TextAttribute(display.getSystemColor(2), null, 0);
        this.realAttribute = new TextAttribute(display.getSystemColor(6), null, 1);
        this.integerAttribute = new TextAttribute(display.getSystemColor(8), null, 1);
        this.keywordAttribute = new TextAttribute(display.getSystemColor(12), null, 1);
    }

    public IRegion calculateDamageExtent(IRegion seed) {
        return seed;
    }

    public TextAttribute getColoring(IParseController controller, Object token) {
        CommonParseController.TokenKind tokenKind = ((CommonParseController)controller).getTokenKind(((IToken)token).getKind());
        switch (tokenKind) {
            case IDENTIFIER: {
                return this.identifierAttribute;
            }
            case INTEGER: {
                return this.integerAttribute;
            }
            case REAL: {
                return this.realAttribute;
            }
            case STRING: {
                return this.stringAttribute;
            }
            case KEYWORD: {
                return this.keywordAttribute;
            }
            case LINE_COMMENT: {
                return this.lineCommentAttribute;
            }
            case PARAGRAPH_COMMENT: {
                return this.paragraphCommentAttribute;
            }
        }
        return super.getColoring(controller, token);
    }
}

