/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.PreferencesUtilities;
import org.eclipse.imp.preferences.fields.FieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.osgi.service.prefs.BackingStoreException;

public class ComboFieldEditor
extends FieldEditor {
    private Combo fCombo = null;
    private String fValue = null;
    private String[][] fEntryNamesAndValues;

    public ComboFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, String[][] entryNamesAndValues, Composite parent, boolean isEnabled, boolean hasSpecialValue, String specialValue, boolean isRemovable) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.preferencesService = service;
        this.preferencesLevel = level;
        this.parent = parent;
        this.prefPage = page;
        this.setPage((DialogPage)this.prefPage);
        this.prefTab = tab;
        if (hasSpecialValue) {
            if (specialValue == null || specialValue.equals("")) {
                specialValue = "None selected";
            }
            this.fEntryNamesAndValues = new String[entryNamesAndValues.length + 1][2];
            this.fEntryNamesAndValues[0][0] = specialValue == null ? "" : specialValue;
            this.fEntryNamesAndValues[0][1] = specialValue == null ? "" : specialValue;
            int i = 0;
            while (i < entryNamesAndValues.length) {
                this.fEntryNamesAndValues[i + 1][0] = entryNamesAndValues[i][0];
                this.fEntryNamesAndValues[i + 1][1] = entryNamesAndValues[i][1];
                ++i;
            }
        } else {
            this.fEntryNamesAndValues = entryNamesAndValues;
        }
        this.createControl(parent);
        this.hasSpecialValue = hasSpecialValue;
        if (hasSpecialValue) {
            this.specialValue = specialValue;
        }
        this.isRemovable = isRemovable;
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.fCombo.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.fCombo != null) {
            String value = null;
            if (this.preferencesLevel != null) {
                value = this.preferencesService.getStringPreference(this.preferencesLevel, this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesLevel;
                this.setInherited(false);
            } else {
                value = this.preferencesService.getStringPreference(this.getPreferenceName());
                this.levelFromWhichLoaded = this.preferencesService.getApplicableLevel(this.getPreferenceName(), this.preferencesLevel);
                this.setInherited(true);
            }
            if ("default".equals(this.levelFromWhichLoaded)) {
                this.setPresentsDefaultValue(true);
            }
            this.previousValue = value;
            this.updateComboForValue(value);
        }
    }

    protected void doLoadDefault() {
        if (this.fCombo != null) {
            String value = this.preferencesService.getStringPreference("default", this.getPreferenceName());
            this.updateComboForValue(value);
        }
    }

    protected void doLoadLevel(String level) {
        if (this.fCombo != null) {
            String value = this.preferencesService.getStringPreference(level, this.getPreferenceName());
            this.updateComboForValue(value);
        }
    }

    protected String doLoadWithInheritance() {
        String levelLoaded = null;
        String[] levels = IPreferencesService.levels;
        int fieldLevelIndex = 0;
        String tmpPreferencesLevel = this.preferencesLevel == null ? levels[0] : this.preferencesLevel;
        int i = 0;
        while (i < levels.length) {
            if (tmpPreferencesLevel.equals(levels[i])) {
                fieldLevelIndex = i;
                break;
            }
            ++i;
        }
        String value = null;
        int levelAtWhichFound = -1;
        int level = fieldLevelIndex;
        while (level < levels.length) {
            value = this.preferencesService.getStringPreference(levels[level], this.getPreferenceName());
            if (value != null) {
                levelAtWhichFound = level;
                levelLoaded = levels[levelAtWhichFound];
                break;
            }
            ++level;
        }
        this.setInherited(fieldLevelIndex != levelAtWhichFound);
        this.updateComboForValue(value);
        this.fieldModified = false;
        this.previousValue = value;
        this.setFieldColors();
        return levelLoaded;
    }

    protected void setFieldColors() {
        Combo comboBox = this.getComboBoxControl(this.parent);
        Color color = this.isInherited() ? PreferencesUtilities.colorBluish : PreferencesUtilities.colorWhite;
        comboBox.setBackground(color);
    }

    protected void doStore() {
        String value = this.getStringValue();
        this.preferencesService.setStringPreference(this.preferencesLevel, this.getPreferenceName(), value);
        this.fieldModified = false;
        this.levelFromWhichLoaded = this.preferencesLevel;
        this.setFieldColors();
        IEclipsePreferences node = this.preferencesService.getNodeForLevel(this.preferencesLevel);
        try {
            if (node != null) {
                node.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            System.err.println("StringFieldEditor.\t():  BackingStoreException flushing node;  node may not have been flushed:\n\tnode path = " + node.absolutePath() + ", preferences level = " + this.preferencesLevel);
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
                ++i;
            }
            this.fCombo.setFont(parent.getFont());
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String name = ComboFieldEditor.this.fCombo.getText();
                    ComboFieldEditor.this.fValue = ComboFieldEditor.this.getValueForName(name);
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fieldModified = true;
                    ComboFieldEditor.this.setInherited(false);
                    ComboFieldEditor.this.valueChanged();
                }
            });
        }
        return this.fCombo;
    }

    protected String getValueForName(String name) {
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            String[] entry = this.fEntryNamesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return this.fEntryNamesAndValues[0][0];
    }

    protected void updateComboForValue(String value) {
        this.previousValue = this.getStringValue();
        this.setPreviousStringValue(this.getStringValue());
        this.fValue = null;
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            if (value.equals(this.fEntryNamesAndValues[i][1])) {
                this.fValue = this.fEntryNamesAndValues[i][1];
                this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
                break;
            }
            ++i;
        }
        if (this.fValue == null && this.fEntryNamesAndValues.length > 0) {
            this.fValue = this.fEntryNamesAndValues[0][1];
            this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
        }
        this.valueChanged();
    }

    protected boolean valueChanged() {
        return this.valueChanged(false);
    }

    protected boolean valueChanged(boolean assertChanged) {
        boolean valueChanged = assertChanged || this.inheritanceChanged();
        String prevValue = this.getPreviousStringValue();
        if (!valueChanged) {
            if (this.fValue != null && prevValue == null || this.fValue == null && prevValue != null) {
                valueChanged = true;
            }
            if (this.fValue != null && prevValue != null && !this.fValue.equals(prevValue)) {
                valueChanged = true;
            }
        }
        if (valueChanged) {
            this.fireValueChanged("field_editor_value", prevValue, this.fValue);
            this.fieldModified = true;
            this.setPreviousStringValue(this.fValue);
            this.setModifiedMarkOnLabel();
        }
        return valueChanged;
    }

    protected String getPreviousStringValue() {
        return (String)this.previousValue;
    }

    protected void setPreviousStringValue(String value) {
        this.previousValue = value;
    }

    public void setFieldValueFromOutside(String newValue) {
        this.setPreviousStringValue(this.getStringValue());
        this.setInherited(false);
        this.setPresentsDefaultValue(false);
        this.levelFromWhichLoaded = null;
        this.updateComboForValue(newValue);
    }

    public String getStringValue() {
        return this.fValue;
    }

    public String getSpecialStringValue() {
        if (!this.hasSpecialValue) {
            throw new IllegalStateException("ComboFieldEditor.getSpecialValue():  field does not have a special value");
        }
        return (String)this.specialValue;
    }

    public void setSpecialValue(String specialValue) {
        if (!this.hasSpecialValue()) {
            throw new IllegalStateException("ComboField.setSpecialValue(String):  field has no special value");
        }
        if (specialValue == null || specialValue == "") {
            throw new IllegalArgumentException("ComboFieldEditor.setSpecialValue(String):  special value cannot be null or empty");
        }
        this.fEntryNamesAndValues[0][0] = specialValue;
    }

    static /* synthetic */ String access$0(ComboFieldEditor comboFieldEditor) {
        return comboFieldEditor.fValue;
    }
}

