/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.debug;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.DSPStackFrame;
import org.eclipse.lsp4e.debug.debugmodel.DSPThread;
import org.eclipse.lsp4e.debug.debugmodel.TransportStreams;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DebugScopesAndVariablesTest
extends AbstractTestWithProject {
    private static final String LAUNCH_TYPE_ID = "org.eclipse.lsp4e.debug.launchType";

    private static ILaunch newLaunch(String mode) throws Exception {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_TYPE_ID);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, "ScopesAndVariablesTest-" + System.currentTimeMillis());
        return new Launch((ILaunchConfiguration)wc, mode, null);
    }

    @Test
    public void testScopesAndVariablesAreReturned() throws Exception {
        ILaunch launch = DebugScopesAndVariablesTest.newLaunch("run");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "mock");
        params.put("request", "launch");
        params.put("program", "dummy");
        MockDebugServer server = new MockDebugServer();
        TestDebugTarget target = new TestDebugTarget(launch, params, server);
        target.initialize((IProgressMonitor)new NullProgressMonitor());
        TestUtils.waitForAndAssertCondition(5000, () -> ((TestDebugTarget)target).isSuspended());
        DSPThread[] threads = target.getThreads();
        Assertions.assertTrue((threads.length > 0 ? 1 : 0) != 0, (String)"No threads reported by debug target");
        Assertions.assertEquals((int)1, (int)threads.length, (String)"Expected exactly one thread");
        Assertions.assertEquals((Object)"Main", (Object)threads[0].getName(), (String)"Thread name mismatch");
        Assertions.assertEquals((Integer)1, (Integer)threads[0].getId(), (String)"Thread id mismatch");
        IStackFrame[] frames = threads[0].getStackFrames();
        Assertions.assertTrue((frames.length > 0 ? 1 : 0) != 0, (String)"No stack frames available on stopped thread");
        Assertions.assertEquals((int)1, (int)frames.length, (String)"Expected exactly one frame");
        IStackFrame frame = frames[0];
        Assertions.assertEquals((Object)"func", (Object)frame.getName(), (String)"Frame name mismatch");
        Assertions.assertEquals((int)1, (int)frame.getLineNumber(), (String)"Frame line mismatch");
        Assertions.assertEquals((int)101, (int)((DSPStackFrame)frame).getFrameId(), (String)"Frame id mismatch");
        IVariable[] scopes = frame.getVariables();
        Assertions.assertTrue((scopes.length > 0 ? 1 : 0) != 0, (String)"Expected at least one scope");
        Assertions.assertEquals((int)1, (int)scopes.length, (String)"Expected exactly one scope");
        Assertions.assertArrayEquals((Object[])new String[]{"locals"}, (Object[])new String[]{scopes[0].getName()});
        Assertions.assertTrue((boolean)scopes[0].getValue().hasVariables(), (String)"Scope should advertise child variables");
        IValue value = scopes[0].getValue();
        IVariable[] vars = value.getVariables();
        Assertions.assertNotNull((Object)value, (String)"Scope value should not be null");
        Assertions.assertTrue((vars != null && vars.length > 0 ? 1 : 0) != 0, (String)"Expected at least one variable under 'locals'");
        Assertions.assertEquals((int)1, (int)vars.length, (String)"Expected exactly one local variable");
        Assertions.assertArrayEquals((Object[])new String[]{"x"}, (Object[])new String[]{vars[0].getName()});
        Assertions.assertEquals((Object)"42", (Object)vars[0].getValue().getValueString(), (String)"Variable value mismatch");
        Assertions.assertFalse((boolean)vars[0].getValue().hasVariables(), (String)"Leaf variable should not have children");
        Assertions.assertNotNull((Object)target.getCapabilities(), (String)"Capabilities should be available after initialize");
        Assertions.assertFalse((boolean)target.getCapabilities().getSupportsConfigurationDoneRequest(), (String)"supportsConfigurationDoneRequest should be false");
    }

    private static final class MockDebugServer
    implements IDebugProtocolServer {
        private static final int THREAD_ID = 1;
        private static final int FRAME_ID = 101;
        private static final int LOCALS_REF = 201;
        IDebugProtocolClient client;

        private MockDebugServer() {
        }

        public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
            EvaluateResponse r = new EvaluateResponse();
            r.setResult("n/a");
            r.setVariablesReference(0);
            return CompletableFuture.completedFuture(r);
        }

        public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
            Capabilities caps = new Capabilities();
            caps.setSupportsConfigurationDoneRequest(Boolean.valueOf(false));
            if (this.client != null) {
                this.client.initialized();
            }
            return CompletableFuture.completedFuture(caps);
        }

        public CompletableFuture<Void> launch(Map<String, Object> args) {
            if (this.client != null) {
                StoppedEventArguments stopped = new StoppedEventArguments();
                stopped.setReason("breakpoint");
                stopped.setThreadId(Integer.valueOf(1));
                this.client.stopped(stopped);
            }
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
            Scope scope = new Scope();
            scope.setName("locals");
            scope.setVariablesReference(201);
            ScopesResponse resp = new ScopesResponse();
            resp.setScopes(new Scope[]{scope});
            return CompletableFuture.completedFuture(resp);
        }

        public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
            StackFrame sf = new StackFrame();
            sf.setId(101);
            sf.setName("func");
            sf.setLine(1);
            StackTraceResponse resp = new StackTraceResponse();
            resp.setTotalFrames(Integer.valueOf(1));
            resp.setStackFrames(new StackFrame[]{sf});
            return CompletableFuture.completedFuture(resp);
        }

        public CompletableFuture<ThreadsResponse> threads() {
            ThreadsResponse r = new ThreadsResponse();
            Thread t = new Thread();
            t.setId(1);
            t.setName("Main");
            r.setThreads(new Thread[]{t});
            return CompletableFuture.completedFuture(r);
        }

        public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
            Variable v = new Variable();
            v.setName("x");
            v.setValue("42");
            v.setVariablesReference(0);
            VariablesResponse resp = new VariablesResponse();
            resp.setVariables(new Variable[]{v});
            return CompletableFuture.completedFuture(resp);
        }
    }

    private static final class TestDebugTarget
    extends DSPDebugTarget {
        private final IDebugProtocolServer server;

        TestDebugTarget(ILaunch launch, Map<String, Object> dspParameters, IDebugProtocolServer server) {
            super(launch, () -> new TransportStreams.DefaultTransportStreams(InputStream.nullInputStream(), OutputStream.nullOutputStream()), dspParameters);
            this.server = server;
        }

        protected Launcher<? extends IDebugProtocolServer> createLauncher(UnaryOperator<MessageConsumer> wrapper, InputStream in, OutputStream out, ExecutorService threadPool) {
            IDebugProtocolServer iDebugProtocolServer = this.server;
            if (iDebugProtocolServer instanceof MockDebugServer) {
                MockDebugServer m = (MockDebugServer)iDebugProtocolServer;
                m.client = this;
            }
            return new Launcher<IDebugProtocolServer>(){

                public RemoteEndpoint getRemoteEndpoint() {
                    return null;
                }

                public IDebugProtocolServer getRemoteProxy() {
                    return server;
                }

                public CompletableFuture<Void> startListening() {
                    return CompletableFuture.completedFuture(null);
                }
            };
        }
    }
}

