/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.presentation;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.text.TMPresentationReconciler;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.ITokenProvider;

abstract class SourceCodeEditor
extends Composite {
    static SourceCodeEditor create(Composite parent, int style) {
        if (Platform.getBundle((String)"org.eclipse.tm4e.ui") != null) {
            return new TMEditor(parent, style);
        }
        return new PlainEditor(parent, style);
    }

    private SourceCodeEditor(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo((Composite)this);
    }

    abstract StyledText getTextWidget();

    void configureForResource(@Nullable IResource resource) {
    }

    void setEditorLayoutData(GridDataFactory data) {
        data.applyTo((Control)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getTextWidget());
    }

    String getText() {
        return this.getTextWidget().getText();
    }

    void setText(String text) {
        this.getTextWidget().setText(text);
    }

    void addModifyListener(ModifyListener l) {
        this.getTextWidget().addModifyListener(l);
    }

    Point getSelection() {
        return this.getTextWidget().getSelection();
    }

    void setSelection(int caret) {
        this.getTextWidget().setSelection(caret);
    }

    public void setToolTipText(@Nullable String string) {
        this.getTextWidget().setToolTipText(string);
    }

    public void setEnabled(boolean enabled) {
        this.getTextWidget().setEnabled(enabled);
    }

    private static final class PlainEditor
    extends SourceCodeEditor {
        private final StyledText text = new StyledText((Composite)this, 2818);

        PlainEditor(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        StyledText getTextWidget() {
            return this.text;
        }
    }

    private static final class TMEditor
    extends SourceCodeEditor {
        private final TMPresentationReconciler reconciler = new TMPresentationReconciler();
        private final SourceViewer viewer = new SourceViewer((Composite)this, null, null, false, 2818);
        private final Document doc;

        TMEditor(Composite parent, int style) {
            super(parent, style);
            this.viewer.configure(new SourceViewerConfiguration(){

                public IPresentationReconciler getPresentationReconciler(@Nullable ISourceViewer sourceViewer) {
                    return reconciler;
                }
            });
            this.doc = new Document();
            this.viewer.setDocument((IDocument)this.doc);
        }

        @Override
        StyledText getTextWidget() {
            return this.viewer.getTextWidget();
        }

        @Override
        void setText(String text) {
            this.doc.set(text);
        }

        @Override
        String getText() {
            return this.viewer.getTextWidget().getText();
        }

        @Override
        void configureForResource(@Nullable IResource resource) {
            if (resource == null) {
                return;
            }
            IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(resource.getName());
            IGrammar grammar = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarFor(contentTypes);
            this.reconciler.setGrammar(grammar);
            if (grammar != null) {
                ITheme theme = TMUIPlugin.getThemeManager().getThemeForScope(grammar.getScopeName());
                StyledText styledText = this.viewer.getTextWidget();
                styledText.setFont(JFaceResources.getTextFont());
                styledText.setForeground(null);
                styledText.setBackground(null);
                theme.initializeViewerColors(styledText);
                this.reconciler.setTheme((ITokenProvider)theme);
            }
        }
    }
}

