/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.declaration;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.DocumentOffsetAsyncCache;
import org.eclipse.lsp4e.operations.declaration.DeferredOpenDeclarationHyperlink;
import org.eclipse.lsp4e.operations.declaration.DeferredOpenMultiDeclarationHyperlink;
import org.eclipse.lsp4e.operations.declaration.LSBasedHyperlink;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class OpenDeclarationHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final long UI_BLOCKING_BUDGET_MS = 200L;
    private static final DocumentOffsetAsyncCache<List<LSBasedHyperlink>> CACHE = new DocumentOffsetAsyncCache(Duration.ofSeconds(10L));

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public IHyperlink @Nullable [] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        TextDocumentPositionParams params;
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        try {
            params = LSPEclipseUtils.toTextDocumentPosistionParams(region.getOffset(), document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        int offset = region.getOffset();
        CompletableFuture<List<LSBasedHyperlink>> request = CACHE.computeIfAbsent(document, offset, () -> {
            CompletableFuture definitions = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getDefinitionProvider)).collectAll(ls -> ls.getTextDocumentService().definition(LSPEclipseUtils.toDefinitionParams(params)).thenApply(l -> new LabeledLocations(Messages.definitionHyperlinkLabel, (Either<List<? extends Location>, List<? extends LocationLink>>)l)));
            CompletableFuture declarations = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getDeclarationProvider)).collectAll(ls -> ls.getTextDocumentService().declaration(LSPEclipseUtils.toDeclarationParams(params)).thenApply(l -> new LabeledLocations(Messages.declarationHyperlinkLabel, (Either<List<? extends Location>, List<? extends LocationLink>>)l)));
            CompletableFuture typeDefinitions = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getTypeDefinitionProvider)).collectAll(ls -> ls.getTextDocumentService().typeDefinition(LSPEclipseUtils.toTypeDefinitionParams(params)).thenApply(l -> new LabeledLocations(Messages.typeDefinitionHyperlinkLabel, (Either<List<? extends Location>, List<? extends LocationLink>>)l)));
            CompletableFuture implementations = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getImplementationProvider)).collectAll(ls -> ls.getTextDocumentService().implementation(LSPEclipseUtils.toImplementationParams(params)).thenApply(l -> new LabeledLocations(Messages.implementationHyperlinkLabel, (Either<List<? extends Location>, List<? extends LocationLink>>)l)));
            CompletableFuture combined = LanguageServers.addAll(LanguageServers.addAll(LanguageServers.addAll(definitions, declarations), typeDefinitions), implementations);
            return combined.thenApply(locations -> OpenDeclarationHyperlinkDetector.toHyperlinks(document, region, locations));
        });
        try {
            List<LSBasedHyperlink> links2 = request.get(200L, TimeUnit.MILLISECONDS);
            return links2.isEmpty() ? null : (IHyperlink[])links2.toArray(IHyperlink[]::new);
        }
        catch (ExecutionException ex) {
            LanguageServerPlugin.logError(ex);
        }
        catch (InterruptedException ex) {
            LanguageServerPlugin.logError(ex);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException ex) {
            if (canShowMultipleHyperlinks) {
                return new IHyperlink[]{new DeferredOpenMultiDeclarationHyperlink(textViewer, document, OpenDeclarationHyperlinkDetector.findWord(document, region), request)};
            }
            @Nullable CompletionStage firstLink = request.thenApply(links -> !links.isEmpty() ? (IHyperlink)links.get(0) : null);
            return new IHyperlink[]{new DeferredOpenDeclarationHyperlink(textViewer, document, OpenDeclarationHyperlinkDetector.findWord(document, region), (CompletableFuture<IHyperlink>)firstLink)};
        }
        return null;
    }

    private static List<LSBasedHyperlink> toHyperlinks(IDocument doc, IRegion region, List<LabeledLocations> locations) {
        LinkedHashMap allLinks = new LinkedHashMap();
        for (LabeledLocations locs : locations) {
            Either<List<? extends Location>, List<? extends LocationLink>> either = locs.locations();
            if (either == null) continue;
            if (either.isLeft()) {
                ((List)either.getLeft()).stream().filter(Objects::nonNull).map(loc -> new LSBasedHyperlink((Location)loc, OpenDeclarationHyperlinkDetector.findWord(doc, region), locs.label())).forEach(h -> {
                    LSBasedHyperlink lSBasedHyperlink = allLinks.putIfAbsent(h.getLocation(), h);
                });
                continue;
            }
            ((List)either.getRight()).stream().filter(Objects::nonNull).map(locLink -> new LSBasedHyperlink((LocationLink)locLink, OpenDeclarationHyperlinkDetector.getSelectedRegion(doc, region, locLink), locs.label())).forEach(h -> {
                LSBasedHyperlink lSBasedHyperlink = allLinks.putIfAbsent(h.getLocation(), h);
            });
        }
        return allLinks.values().stream().toList();
    }

    private static IRegion getSelectedRegion(IDocument document, IRegion region, LocationLink locationLink) {
        Range originSelectionRange = locationLink.getOriginSelectionRange();
        if (originSelectionRange != null) {
            try {
                int offset = LSPEclipseUtils.toOffset(originSelectionRange.getStart(), document);
                int endOffset = LSPEclipseUtils.toOffset(originSelectionRange.getEnd(), document);
                return new Region(offset, endOffset - offset);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e.getMessage(), e);
            }
        }
        return OpenDeclarationHyperlinkDetector.findWord(document, region);
    }

    private static IRegion findWord(IDocument document, IRegion region) {
        int start = -2;
        int end = -1;
        int offset = region.getOffset();
        try {
            char c;
            int pos = offset;
            while (pos >= 0 && pos < document.getLength()) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException x) {
            LanguageServerPlugin.logWarning(x.getMessage(), x);
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return region;
    }

    @NonNullByDefault(value={})
    private record LabeledLocations(String label, @Nullable Either<List<? extends Location>, List<? extends LocationLink>> locations) {
    }
}

