/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.outline;

import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.junit.Assert;
import org.junit.Test;

public class SymbolsLabelProviderTest
extends AbstractTest {
    private static final Location LOCATION = new Location("path/to/foo", new Range(new Position(0, 0), new Position(1, 1)));
    private static final Location INVALID_LOCATION = new Location("file:://///invalid_location_uri", new Range(new Position(0, 0), new Position(1, 1)));

    @Test
    public void testShowKind() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, true);
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, LOCATION);
        Assert.assertEquals((Object)"Foo :Class", (Object)labelProvider.getText((Object)info));
    }

    @Test
    public void testShowKindLocation() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(true, true);
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, LOCATION);
        Assert.assertEquals((Object)"Foo :Class path/to/foo", (Object)labelProvider.getText((Object)info));
    }

    @Test
    public void testShowLocation() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(true, false);
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, LOCATION);
        Assert.assertEquals((Object)"Foo path/to/foo", (Object)labelProvider.getText((Object)info));
    }

    @Test
    public void testShowNeither() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, false);
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, LOCATION);
        Assert.assertEquals((Object)"Foo", (Object)labelProvider.getText((Object)info));
    }

    @Test
    public void testGetStyledTextInalidLocationURI() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, false);
        SymbolInformation info = new SymbolInformation("Foo", SymbolKind.Class, INVALID_LOCATION);
        Assert.assertEquals((Object)"Foo", (Object)labelProvider.getStyledText((Object)info).getString());
    }

    @Test
    public void testDocumentSymbolDetail() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, false);
        DocumentSymbol info = new DocumentSymbol("Foo", SymbolKind.Class, new Range(new Position(1, 0), new Position(1, 2)), new Range(new Position(1, 0), new Position(1, 2)), ": additional detail");
        Assert.assertEquals((Object)"Foo : additional detail", (Object)labelProvider.getStyledText((Object)info).getString());
    }

    @Test
    public void testDocumentSymbolDetailWithKind() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, true);
        DocumentSymbol info = new DocumentSymbol("Foo", SymbolKind.Class, new Range(new Position(1, 0), new Position(1, 2)), new Range(new Position(1, 0), new Position(1, 2)), ": additional detail");
        Assert.assertEquals((Object)"Foo : additional detail :Class", (Object)labelProvider.getStyledText((Object)info).getString());
    }

    @Test
    public void testDocumentSymbolWithUriDetail() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, false);
        DocumentSymbol info = new DocumentSymbol("Foo", SymbolKind.Class, new Range(new Position(1, 0), new Position(1, 2)), new Range(new Position(1, 0), new Position(1, 2)), ": additional detail");
        SymbolsModel.DocumentSymbolWithURI symbolWithURI = new SymbolsModel.DocumentSymbolWithURI(info, null);
        Assert.assertEquals((Object)"Foo : additional detail", (Object)labelProvider.getStyledText((Object)symbolWithURI).getString());
    }

    @Test
    public void testDocumentSymbolDetailWithFileWithKind() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, true);
        DocumentSymbol info = new DocumentSymbol("Foo", SymbolKind.Class, new Range(new Position(1, 0), new Position(1, 2)), new Range(new Position(1, 0), new Position(1, 2)), ": additional detail");
        SymbolsModel.DocumentSymbolWithURI symbolWithURI = new SymbolsModel.DocumentSymbolWithURI(info, null);
        Assert.assertEquals((Object)"Foo : additional detail :Class", (Object)labelProvider.getStyledText((Object)symbolWithURI).getString());
    }

    @Test
    public void testDocumentSymbolDetailWithFileWithKindDeprecated() {
        SymbolsLabelProvider labelProvider = new SymbolsLabelProvider(false, true);
        DocumentSymbol info = new DocumentSymbol("Foo", SymbolKind.Class, new Range(new Position(1, 0), new Position(1, 2)), new Range(new Position(1, 0), new Position(1, 2)), ": additional detail");
        info.setDeprecated(Boolean.valueOf(true));
        SymbolsModel.DocumentSymbolWithURI symbolWithURI = new SymbolsModel.DocumentSymbolWithURI(info, null);
        Assert.assertEquals((Object)"Foo : additional detail :Class", (Object)labelProvider.getStyledText((Object)symbolWithURI).getString());
        Assert.assertTrue((boolean)labelProvider.getStyledText((Object)symbolWithURI).getStyleRanges()[0].strikeout);
    }
}

