/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.common.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.lsat.common.emf.common.util.BufferedDiagnosticChain;
import org.slf4j.Logger;

public class DiagnosticUtil {
    private DiagnosticUtil() {
    }

    public static void logFull(Iterable<Diagnostic> aDiagnostics, Logger aLogger) {
        if (aDiagnostics == null || aLogger == null) {
            return;
        }
        for (Diagnostic diagnostic : aDiagnostics) {
            DiagnosticUtil.logFull(diagnostic, aLogger);
        }
    }

    public static void logFull(Diagnostic aDiagnostic, Logger aLogger) {
        if (aDiagnostic == null || aLogger == null) {
            return;
        }
        switch (aDiagnostic.getSeverity()) {
            case 4: 
            case 8: {
                aLogger.error(aDiagnostic.getMessage(), aDiagnostic.getException());
                break;
            }
            case 2: {
                aLogger.warn(aDiagnostic.getMessage(), aDiagnostic.getException());
                break;
            }
            case 1: {
                aLogger.info(aDiagnostic.getMessage(), aDiagnostic.getException());
                break;
            }
            case 0: {
                aLogger.debug(aDiagnostic.getMessage(), aDiagnostic.getException());
                break;
            }
            default: {
                aLogger.error("Unknown severity " + aDiagnostic.getSeverity() + ": " + aDiagnostic.getMessage(), aDiagnostic.getException());
            }
        }
        DiagnosticUtil.logFull(aDiagnostic.getChildren(), aLogger);
    }

    public static String getFullMessage(BufferedDiagnosticChain diagnosticsChain) {
        return DiagnosticUtil.getFullMessage(diagnosticsChain.getDiagnostics());
    }

    public static String getFullMessage(Iterable<Diagnostic> diagnostics) {
        StringBuffer str = new StringBuffer();
        Iterator<Diagnostic> i = diagnostics.iterator();
        while (i.hasNext()) {
            str.append(DiagnosticUtil.getFullMessage(i.next(), "- "));
            if (!i.hasNext()) continue;
            str.append('\n');
        }
        return str.toString();
    }

    public static String getFullMessage(Diagnostic aDiagnostic) {
        return DiagnosticUtil.getFullMessage(aDiagnostic, "");
    }

    private static String getFullMessage(Diagnostic aDiagnostic, String aPrefix) {
        StringBuffer str = new StringBuffer();
        str.append(aPrefix);
        str.append(DiagnosticUtil.getSeverity(aDiagnostic)).append(": ");
        str.append(aDiagnostic.getMessage());
        Object childPrefix = aPrefix.length() == 0 ? "- " : "  " + aPrefix;
        LinkedHashSet<String> childMessages = new LinkedHashSet<String>();
        for (Diagnostic child : aDiagnostic.getChildren()) {
            childMessages.add(DiagnosticUtil.getFullMessage(child, (String)childPrefix));
        }
        for (String childMsg : childMessages) {
            str.append('\n').append(childMsg);
        }
        return str.toString();
    }

    public static String getSeverity(Diagnostic aDiagnostic) {
        switch (aDiagnostic.getSeverity()) {
            case 8: {
                return "CANCEL";
            }
            case 4: {
                return "ERROR";
            }
            case 1: {
                return "INFO";
            }
            case 0: {
                return "OK";
            }
            case 2: {
                return "WARNING";
            }
        }
        return "Unknown";
    }

    public static IStatus toIStatus(Diagnostic diagnostic) {
        return new DiagnosticStatus(diagnostic);
    }

    private static class DiagnosticStatus
    implements IStatus {
        final int severity;
        final int code;
        final String pluginId;
        final String message;
        final Throwable exception;
        final IStatus[] children;

        private DiagnosticStatus(Diagnostic diagnostic) {
            this.severity = diagnostic.getSeverity();
            this.code = diagnostic.getCode();
            this.pluginId = diagnostic.getSource();
            this.message = diagnostic.getMessage();
            this.exception = diagnostic.getException();
            List diagnosticChildren = diagnostic.getChildren();
            this.children = new IStatus[diagnosticChildren.size()];
            int i = 0;
            while (i < this.children.length) {
                this.children[i] = new DiagnosticStatus((Diagnostic)diagnosticChildren.get(i));
                ++i;
            }
        }

        public int getCode() {
            return this.code;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.message;
        }

        public String getPlugin() {
            return this.pluginId;
        }

        public int getSeverity() {
            return this.severity;
        }

        public boolean isMultiStatus() {
            return this.children.length > 0;
        }

        public IStatus[] getChildren() {
            return this.children;
        }

        public boolean isOK() {
            return this.severity == 0;
        }

        public boolean matches(int severityMask) {
            return (this.severity & severityMask) != 0;
        }
    }
}

