/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.common.ludus.backend.games.meanpayoff;

import org.eclipse.lsat.common.ludus.backend.datastructures.weights.SingleWeightFunction;
import org.eclipse.lsat.common.ludus.backend.games.GameGraph;

/**
 * Mean-payoff game is a game graph with a single weight function.
 *
 * @author Bram van der Sanden
 * @param <V> vertex type
 * @param <E> edge type
 * @param <T> edge weight type
 */
public interface MeanPayoffGame<V, E, T> extends GameGraph<V, E>, SingleWeightFunction<T, E> {

}
