/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.impl;

import org.eclipse.gmf.runtime.emf.type.core.AbstractElementTypeFactory;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;

public class HintedTypeFactory
extends AbstractElementTypeFactory {
    public static final String HINTED_TYPE_KIND = "org.eclipse.gmf.runtime.emf.core.internal.util.IHintedType";
    private static final String SEMANTIC_HINT_PARAM_NAME = "semanticHint";

    @Override
    public ISpecializationType createSpecializationType(ISpecializationTypeDescriptor descriptor) {
        String semanticHint = descriptor.getParamValue(SEMANTIC_HINT_PARAM_NAME);
        return new HintedSpecializationType(descriptor, semanticHint);
    }

    @Override
    public IMetamodelType createMetamodelType(IMetamodelTypeDescriptor descriptor) {
        String semanticHint = descriptor.getParamValue(SEMANTIC_HINT_PARAM_NAME);
        return new HintedMetamodelType(descriptor, semanticHint);
    }

    private static final class HintedMetamodelType
    extends MetamodelType
    implements IHintedType {
        private final String semanticHint;

        public HintedMetamodelType(IMetamodelTypeDescriptor descriptor, String semanticHint) {
            super(descriptor);
            this.semanticHint = semanticHint;
        }

        @Override
        public String getSemanticHint() {
            return this.semanticHint;
        }
    }

    private static final class HintedSpecializationType
    extends SpecializationType
    implements IHintedType {
        private final String semanticHint;

        public HintedSpecializationType(ISpecializationTypeDescriptor descriptor, String semanticHint) {
            super(descriptor);
            this.semanticHint = semanticHint;
        }

        @Override
        public String getSemanticHint() {
            return this.semanticHint;
        }
    }
}

