/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public abstract class AbstractPartitionAction
extends AbstractTraceViewAction {
    AbstractPartitionAction(TraceView view) {
        super(view);
    }

    AbstractPartitionAction(TraceView view, String imgPath) {
        super(view, imgPath);
    }

    @Override
    protected void doRun() throws TraceException {
        ArrayList<String> input = new ArrayList<String>();
        input.addAll(this.view.getAttributeNames(this.getPart()));
        Collections.sort(input);
        ArrayList<String> selection = new ArrayList<String>();
        Collection<String> selectedAtts = this.getSelectedAttributes();
        if (selectedAtts != null) {
            selection.addAll(selectedAtts);
        }
        ListSelectionDialog dialog = ListSelectionDialog.of(input).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).labelProvider((ILabelProvider)new LabelProvider()).message(this.getDialogMessage()).create(this.view.getEditorSite().getShell());
        dialog.setInitialElementSelections(selection);
        dialog.open();
        if (dialog.getResult() != null) {
            ArrayList<String> newSelection = new ArrayList<String>();
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                newSelection.add(o.toString());
                ++n2;
            }
            this.updateSelection(newSelection);
            this.view.update();
        }
    }

    protected abstract TracePart getPart();

    protected abstract String getDialogMessage();

    protected abstract Collection<String> getSelectedAttributes() throws TraceException;

    protected abstract void updateSelection(Collection<String> var1) throws TraceException;
}

