/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.ElimTypeDecls;
import org.eclipse.escet.cif.cif2cif.LinearizeMerge;
import org.eclipse.escet.cif.cif2cif.MergeEnums;
import org.eclipse.escet.cif.cif2cif.PrintFileIntoDecls;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2cif.RemoveCifSvgDecls;
import org.eclipse.escet.cif.cif2cif.RemovePositionInfo;
import org.eclipse.escet.cif.cif2cif.SimplifyOthers;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesNoRefsOptimized;
import org.eclipse.escet.cif.cif2cif.SvgFileIntoDecls;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.CodeGenPreChecker;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.SvgCodeGen;
import org.eclipse.escet.cif.codegen.TypeCodeGen;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.options.CodePrefixOption;
import org.eclipse.escet.cif.codegen.options.TargetLanguage;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.AlgDerInvalidations;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.codegen.updates.tree.SingleVariableAssignment;
import org.eclipse.escet.cif.codegen.updates.tree.UpdateData;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifExecSchemeUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.ConstantOrderer;
import org.eclipse.escet.cif.common.StateInitVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.TypeDecl;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.print.Print;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class CodeGen {
    private static final int DEFAULT_INDENT = 4;
    protected final TargetLanguage language;
    protected final int indent;
    protected ExprCodeGen exprCodeGen;
    protected TypeCodeGen typeCodeGen;
    public Map<String, String> replacements;
    protected Map<Declaration, String> origDeclNames;
    private Map<PositionObject, String> targetNameMap;
    private Set<String> targetNames;
    protected Specification spec;
    protected List<DiscVariable> lpVariables;
    protected List<Constant> constants;
    protected List<Event> events;
    protected Map<Event, Integer> eventMap;
    protected Map<SvgIn, Event> environmentEvents;
    protected List<Declaration> stateVars;
    protected List<ContVariable> contVars;
    protected List<AlgVariable> algVars;
    protected List<InputVariable> inputVars;
    protected List<InternalFunction> functions;
    protected List<Print> printDecls;
    protected List<IoDecl> svgDecls;
    protected List<Edge> svgInEdges;
    protected List<Edge> uncontrollableEdges;
    protected List<Edge> controllableEdges;
    protected List<Integer> reservedTmpvarRanges = Lists.list();
    protected int tmpvarNumber = 1;
    AlgDerInvalidations invalidations = null;

    protected CodeGen(TargetLanguage language) {
        this(language, 4);
    }

    protected CodeGen(TargetLanguage language, int indent) {
        this.language = language;
        this.indent = indent;
    }

    public MemoryCodeBox makeCodeBox() {
        return this.makeCodeBox(0);
    }

    public MemoryCodeBox makeCodeBox(int numIndents) {
        MemoryCodeBox code = new MemoryCodeBox(this.indent);
        int i = 0;
        while (i < numIndents) {
            code.indent();
            ++i;
        }
        return code;
    }

    protected abstract ExprCodeGen getExpressionCodeGenerator();

    protected abstract TypeCodeGen getTypeCodeGenerator();

    public String getTargetRef(PositionObject obj) {
        return this.getTargetVariableName(obj);
    }

    public String getTargetVariableName(PositionObject obj) {
        Object targetName = this.targetNameMap.get(obj);
        if (targetName != null) {
            return targetName;
        }
        targetName = this.origDeclNames.get(obj);
        if (targetName == null) {
            targetName = CifTextUtils.getName((PositionObject)obj);
        }
        targetName = ((String)targetName).replace('.', '_');
        if (this.targetNames.contains(targetName = (String)targetName + "_")) {
            Object oldName = targetName;
            targetName = CifScopeUtils.getUniqueName((String)targetName, this.targetNames, Collections.emptySet());
            String origName = this.origDeclNames.get(obj);
            if (origName == null) {
                origName = CifTextUtils.getName((PositionObject)obj);
            }
            OutputProvider.warn((String)"%s identifier \"%s\" is renamed to \"%s\" for CIF object \"%s\".", (Object[])new Object[]{this.language.readableName, oldName, targetName, origName});
        }
        this.targetNames.add((String)targetName);
        this.targetNameMap.put(obj, (String)targetName);
        return targetName;
    }

    public void generate(Specification spec, String cifSpecFileDir, String absSpecPath, String outputPath, Termination termination) {
        this.init();
        this.prepare(spec, absSpecPath, termination);
        CodeContext ctxt = new CodeContext(this);
        this.generateCode(ctxt, spec, cifSpecFileDir);
        this.postGenerate(ctxt);
        this.write(outputPath);
        this.cleanup();
    }

    protected void init() {
        this.replacements = Maps.map();
        this.replacements.put("prefix", CodePrefixOption.getPrefix());
        this.origDeclNames = Maps.map();
        this.targetNameMap = Maps.map();
        this.targetNames = Sets.copy(this.getReservedTargetNames());
        this.constants = Lists.list();
        this.events = Lists.list();
        this.eventMap = Maps.map();
        this.environmentEvents = Maps.map();
        this.stateVars = Lists.list();
        this.contVars = Lists.list();
        this.algVars = Lists.list();
        this.inputVars = Lists.list();
        this.functions = Lists.list();
        this.printDecls = Lists.list();
        this.svgDecls = Lists.list();
        this.svgInEdges = Lists.list();
        this.uncontrollableEdges = Lists.list();
        this.controllableEdges = Lists.list();
        this.exprCodeGen = this.getExpressionCodeGenerator();
        this.typeCodeGen = this.getTypeCodeGenerator();
        this.typeCodeGen.init();
    }

    public String getPrefix() {
        return this.replacements.get("prefix");
    }

    protected abstract Set<String> getReservedTargetNames();

    protected VariableInformation getVarInfo(Declaration decl, CodeContext ctxt) {
        String targetVarName = this.getTargetVariableName((PositionObject)decl);
        String targetRef = this.getTargetRef((PositionObject)decl);
        String origName = this.origDeclNames.get(decl);
        if (origName == null) {
            origName = decl.getName();
        }
        if (decl instanceof AlgVariable) {
            AlgVariable algVar = (AlgVariable)decl;
            TypeInfo ti = this.typeCodeGen.typeToTarget(algVar.getType(), ctxt);
            return new VariableInformation(ti, origName, targetVarName, targetRef, false);
        }
        if (decl instanceof Constant) {
            Constant constVar = (Constant)decl;
            TypeInfo ti = this.typeCodeGen.typeToTarget(constVar.getType(), ctxt);
            return new VariableInformation(ti, origName, targetVarName, targetRef, false);
        }
        if (decl instanceof ContVariable) {
            TypeInfo ti = this.typeCodeGen.typeToTarget((CifType)CifConstructors.newRealType(), ctxt);
            return new VariableInformation(ti, origName, targetVarName, targetRef, false);
        }
        if (decl instanceof EnumDecl) {
            EnumDecl enumDecl = (EnumDecl)decl;
            TypeInfo ti = this.typeCodeGen.typeToTarget((CifType)CifConstructors.newEnumType((EnumDecl)enumDecl, null), ctxt);
            return new VariableInformation(ti, origName, targetVarName, targetRef, false);
        }
        if (decl instanceof InputVariable) {
            InputVariable inputVar = (InputVariable)decl;
            TypeInfo ti = this.typeCodeGen.typeToTarget(inputVar.getType(), ctxt);
            return new VariableInformation(ti, origName, targetVarName, targetRef, false);
        }
        if (decl instanceof DiscVariable) {
            DiscVariable discVar = (DiscVariable)decl;
            TypeInfo ti = this.typeCodeGen.typeToTarget(discVar.getType(), ctxt);
            return new VariableInformation(ti, origName, targetVarName, targetRef, false);
        }
        throw new RuntimeException("Unexpected kind of declaration encountered: " + Strings.str((Object)decl));
    }

    public VariableInformation makeTempVariable(VariableInformation varInfo) {
        String targetName = Strings.fmt((String)"%stmp%d", (Object[])new Object[]{varInfo.targetVariableName, this.tmpvarNumber});
        ++this.tmpvarNumber;
        return new VariableInformation(varInfo.typeInfo, varInfo.name, targetName, targetName, true);
    }

    public VariableInformation makeTempVariable(TypeInfo ti, String name) {
        String targetName = Strings.fmt((String)"%s%d", (Object[])new Object[]{name, this.tmpvarNumber});
        ++this.tmpvarNumber;
        return new VariableInformation(ti, name, targetName, targetName, true);
    }

    public int countCreatedTempVariables() {
        if (this.reservedTmpvarRanges.isEmpty()) {
            return this.tmpvarNumber - 1;
        }
        return this.tmpvarNumber - (Integer)Lists.last(this.reservedTmpvarRanges);
    }

    public int reserveTempVariables() {
        this.reservedTmpvarRanges.add(this.tmpvarNumber);
        return this.tmpvarNumber;
    }

    public void unreserveTempVariables(int reservedValue) {
        int last = this.reservedTmpvarRanges.size() - 1;
        Assert.check((this.reservedTmpvarRanges.get(last) == reservedValue ? 1 : 0) != 0);
        this.reservedTmpvarRanges.remove(last);
        this.tmpvarNumber = reservedValue;
    }

    public abstract Destination makeDestination(VariableInformation var1);

    public abstract DataValue makeDataValue(String var1);

    public abstract void performSingleAssign(CodeBox var1, SingleVariableAssignment var2, Expression var3, CodeContext var4, CodeContext var5);

    public abstract void performAssign(CodeBox var1, SingleVariableAssignment var2, String var3, CodeContext var4, CodeContext var5);

    public Set<VariableWrapper> getAffectedAlgebraicDerivativeExpressions(VariableWrapper v) {
        if (this.invalidations == null) {
            this.invalidations = new AlgDerInvalidations();
            this.invalidations.computeAffects(this.algVars, this.contVars);
        }
        return this.invalidations.getAffecting(v);
    }

    protected void cleanup() {
        this.typeCodeGen.cleanup();
        this.exprCodeGen = null;
        this.typeCodeGen = null;
        this.replacements = null;
        this.origDeclNames = null;
        this.targetNameMap = null;
        this.targetNames = null;
        this.spec = null;
        this.lpVariables = null;
        this.constants = null;
        this.events = null;
        this.eventMap = null;
        this.environmentEvents = null;
        this.stateVars = null;
        this.contVars = null;
        this.algVars = null;
        this.inputVars = null;
        this.functions = null;
        this.printDecls = null;
        this.svgDecls = null;
        this.svgInEdges = null;
        this.uncontrollableEdges = null;
        this.controllableEdges = null;
        this.reservedTmpvarRanges = null;
    }

    private void initOrigDeclNames(Specification spec) {
        InitOrigDeclNamesWalker walker = new InitOrigDeclNamesWalker();
        walker.initOrigDeclNames(spec);
    }

    private void prepare(Specification spec, String absSpecPath, Termination termination) {
        new RemovePositionInfo().transform(spec);
        if (this.language != TargetLanguage.HTML) {
            RemoveCifSvgDecls removeCifSvgDecls = new RemoveCifSvgDecls();
            removeCifSvgDecls.transform(spec);
            if (removeCifSvgDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
                OutputProvider.warn((String)"The specification contains CIF/SVG input declarations. These will be ignored.");
            }
        }
        new RemoveAnnotations(new String[]{"doc"}).transform(spec);
        new ElimComponentDefInst().transform(spec);
        new ElimStateEvtExclInvs().transform(spec);
        this.initOrigDeclNames(spec);
        new SimplifyValuesNoRefsOptimized().transform(spec);
        new SimplifyOthers().transform(spec);
        CodeGenPreChecker checker = new CodeGenPreChecker(this.language, termination);
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF code generator");
        LinearizeMerge linearize = new LinearizeMerge(true);
        linearize.transform(spec);
        this.lpVariables = linearize.getLPVariables();
        for (Map.Entry entry : linearize.getLpVarToAbsAutNameMap().entrySet()) {
            String prev = this.origDeclNames.put((Declaration)entry.getKey(), (String)entry.getValue());
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        new ElimTypeDecls().transform(spec);
        new PrintFileIntoDecls().transform(spec);
        new SvgFileIntoDecls().transform(spec);
        new MergeEnums().transform(spec);
        new SimplifyValuesNoRefsOptimized().transform(spec);
        new AddDefaultInitialValues().transform(spec);
    }

    private void generateCode(CodeContext ctxt, Specification spec, String cifSpecFileDir) {
        this.spec = spec;
        Assert.check((boolean)spec.getDefinitions().isEmpty());
        List automata = Lists.listc((int)1);
        CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)automata);
        Assert.check((automata.size() == 1 ? 1 : 0) != 0);
        Automaton aut = (Automaton)Lists.first((List)automata);
        List decls = Lists.list();
        CifCollectUtils.collectDeclarations((ComplexComponent)spec, (Collection)decls);
        List enumDecls = Lists.list();
        for (Declaration decl : decls) {
            if (decl instanceof Constant) {
                this.constants.add((Constant)decl);
                continue;
            }
            if (decl instanceof Event) {
                this.events.add((Event)decl);
                continue;
            }
            if (decl instanceof DiscVariable) {
                this.stateVars.add(decl);
                continue;
            }
            if (decl instanceof ContVariable) {
                this.stateVars.add(decl);
                this.contVars.add((ContVariable)decl);
                continue;
            }
            if (decl instanceof AlgVariable) {
                this.algVars.add((AlgVariable)decl);
                continue;
            }
            if (decl instanceof InputVariable) {
                this.inputVars.add((InputVariable)decl);
                continue;
            }
            if (decl instanceof InternalFunction) {
                this.functions.add((InternalFunction)decl);
                continue;
            }
            if (decl instanceof EnumDecl) {
                enumDecls.add((EnumDecl)decl);
                continue;
            }
            if (decl instanceof TypeDecl) continue;
            throw new RuntimeException("Unexpected decl: " + String.valueOf(decl));
        }
        this.constants = new ConstantOrderer().computeOrder(this.constants);
        this.stateVars = new StateInitVarOrderer().computeOrder(this.stateVars);
        List ioDecls = Lists.list();
        CifCollectUtils.collectIoDeclarations((ComplexComponent)spec, (Collection)ioDecls);
        this.printDecls.addAll(ioDecls.stream().filter(Print.class::isInstance).map(Print.class::cast).toList());
        this.svgDecls.addAll(ioDecls.stream().filter(d -> d instanceof SvgCopy || d instanceof SvgMove || d instanceof SvgOut || d instanceof SvgIn).toList());
        List<SvgIn> svgIns = this.svgDecls.stream().filter(SvgIn.class::isInstance).map(SvgIn.class::cast).toList();
        this.environmentEvents = SvgCodeGen.createEnvironmentEvents(svgIns, cifSpecFileDir);
        CifExecSchemeUtils.orderEvents(this.events);
        this.events = Lists.concat(new ArrayList<Event>(this.environmentEvents.values()), this.events);
        this.events = Collections.unmodifiableList(this.events);
        this.eventMap = IntStream.range(0, this.events.size()).boxed().collect(Collectors.toUnmodifiableMap(this.events::get, i -> i));
        Assert.check((enumDecls.size() <= 1 ? 1 : 0) != 0);
        EnumDecl enumDecl = enumDecls.isEmpty() ? CifConstructors.newEnumDecl(null, (List)Lists.list((Object)CifConstructors.newEnumLiteral(null, (String)"__some_dummy_enum_literal", null)), (String)"__some_dummy_enum_name", null) : (EnumDecl)Lists.first((List)enumDecls);
        this.addConstants(ctxt);
        this.addEvents(ctxt);
        this.addStateVars(ctxt);
        this.addContVars(ctxt);
        this.addAlgVars(ctxt);
        this.addInputVars(ctxt);
        this.addFunctions(ctxt);
        this.addEnum(enumDecl, ctxt);
        this.addPrints(ctxt);
        this.addSvgDecls(ctxt, cifSpecFileDir);
        Assert.check((aut.getLocations().size() == 1 ? 1 : 0) != 0);
        Location loc = (Location)Lists.first((List)aut.getLocations());
        EList edges = loc.getEdges();
        Set seenEvents = Sets.setc((int)edges.size());
        for (Edge edge2 : edges) {
            Assert.check((edge2.getGuards().size() <= 1 ? 1 : 0) != 0);
            Assert.check((!edge2.isUrgent() ? 1 : 0) != 0);
            Assert.check((edge2.getTarget() == null ? 1 : 0) != 0);
            Assert.check((edge2.getEvents().size() == 1 ? 1 : 0) != 0);
            EdgeEvent edgeEvent = (EdgeEvent)edge2.getEvents().get(0);
            Assert.check((!(edgeEvent instanceof EdgeSend) ? 1 : 0) != 0);
            Assert.check((!(edgeEvent instanceof EdgeReceive) ? 1 : 0) != 0);
            Assert.check((boolean)(edgeEvent.getEvent() instanceof EventExpression));
            Event event = ((EventExpression)edgeEvent.getEvent()).getEvent();
            boolean eventAdded = seenEvents.add(event);
            Assert.check((boolean)eventAdded);
        }
        Set<Event> svgInEvents = SvgCodeGen.getSvgInEvents(svgIns);
        this.svgInEdges = edges.stream().filter(e -> svgInEvents.contains(CifEventUtils.getEvent((Edge)e))).toList();
        this.uncontrollableEdges = edges.stream().filter(edge -> {
            Event evt = CifEventUtils.getEvent((Edge)edge);
            return evt.getControllable() == false && !svgInEvents.contains(evt);
        }).toList();
        this.controllableEdges = edges.stream().filter(edge -> {
            Event evt = CifEventUtils.getEvent((Edge)edge);
            return evt.getControllable() != false && !svgInEvents.contains(evt);
        }).toList();
        Assert.areEqual((Object)edges.size(), (Object)(this.svgInEdges.size() + this.uncontrollableEdges.size() + this.controllableEdges.size()));
        this.addEdges(ctxt, cifSpecFileDir);
        this.addSpec(ctxt);
    }

    protected abstract void addConstants(CodeContext var1);

    protected abstract void addEvents(CodeContext var1);

    protected abstract void addStateVars(CodeContext var1);

    protected abstract void addContVars(CodeContext var1);

    protected abstract void addAlgVars(CodeContext var1);

    protected abstract void addInputVars(CodeContext var1);

    protected abstract void addFunctions(CodeContext var1);

    protected abstract void addEnum(EnumDecl var1, CodeContext var2);

    protected abstract void addPrints(CodeContext var1);

    protected abstract void addSvgDecls(CodeContext var1, String var2);

    protected abstract void addEdges(CodeContext var1, String var2);

    protected void addUpdates(List<Update> updates, CodeBox code, CodeContext ctxt) {
        Assert.check((!updates.isEmpty() ? 1 : 0) != 0);
        UpdateData.generateAssignment(updates, code, ctxt);
    }

    protected abstract IfElseGenerator getIfElseUpdateGenerator();

    protected abstract void addUpdatesBeginScope(CodeBox var1);

    protected abstract void addUpdatesEndScope(CodeBox var1);

    protected abstract void addSpec(CodeContext var1);

    protected abstract Map<String, String> getTemplates();

    protected void postGenerate(CodeContext ctxt) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(String path) {
        Map<String, String> templates = this.getTemplates();
        String absPath = org.eclipse.escet.common.app.framework.Paths.resolve((String)path);
        Path nioAbsPath = Paths.get(absPath, new String[0]);
        if (!Files.isDirectory(nioAbsPath, new LinkOption[0])) {
            try {
                Files.createDirectories(nioAbsPath, new FileAttribute[0]);
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create output directory \"%s\" for the generated code.", (Object[])new Object[]{path});
                throw new InputOutputException(msg, (Throwable)ex);
            }
        }
        boolean[] used = new boolean[this.replacements.size()];
        Iterator<Map.Entry<String, String>> iterator = templates.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            Map.Entry<String, String> template = iterator.next();
            Object fileName = template.getValue();
            fileName = this.getPrefix() + (String)fileName;
            String filePath = path + File.separator + (String)fileName;
            String absFilePath = org.eclipse.escet.common.app.framework.Paths.resolve((String)filePath);
            String resName = this.getResourceName(template.getKey());
            Set<Map.Entry<String, String>> replaces = this.replacements.entrySet();
            ClassLoader classLoader = this.getClass().getClassLoader();
            try {
                Throwable throwable = null;
                Object var15_20 = null;
                try {
                    InputStream fstream = classLoader.getResourceAsStream(resName);
                    try {
                        block33: {
                            BufferedInputStream istream = new BufferedInputStream(fstream);
                            try {
                                try (FileAppStream ostream = new FileAppStream(filePath, absFilePath);){
                                    LineIterator lines = IOUtils.lineIterator((InputStream)istream, (String)"UTF-8");
                                    while (lines.hasNext()) {
                                        String line = lines.nextLine();
                                        if (!line.isEmpty()) {
                                            block15: while (true) {
                                                boolean anythingReplaced = false;
                                                int i = 0;
                                                Iterator<Map.Entry<String, String>> iterator2 = replaces.iterator();
                                                while (true) {
                                                    if (!iterator2.hasNext()) {
                                                        if (anythingReplaced) continue block15;
                                                        break block15;
                                                    }
                                                    Map.Entry<String, String> replace = iterator2.next();
                                                    String name = replace.getKey();
                                                    String text = replace.getValue();
                                                    String marker = Strings.fmt((String)"${%s}", (Object[])new Object[]{name});
                                                    if (!used[i] && line.contains(marker)) {
                                                        used[i] = true;
                                                        anythingReplaced = true;
                                                    }
                                                    ++i;
                                                    line = line.replace(marker, text);
                                                }
                                                break;
                                            }
                                        }
                                        ostream.println(line);
                                    }
                                }
                                if (istream == null) break block33;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (istream == null) throw throwable;
                                ((InputStream)istream).close();
                                throw throwable;
                            }
                            ((InputStream)istream).close();
                        }
                        if (fstream == null) continue;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fstream == null) throw throwable;
                        fstream.close();
                        throw throwable;
                    }
                    fstream.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (IOException ex) {
                String msg = "Template read error: " + resName;
                throw new RuntimeException(msg, ex);
            }
        }
        int i = 0;
        Iterator<Map.Entry<String, String>> iterator3 = this.replacements.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<String, String> replace = iterator3.next();
            if (!used[i]) {
                String msg = "Unused replacement: " + replace.getKey();
                throw new RuntimeException(msg);
            }
            ++i;
        }
        return;
    }

    protected String getResourceName(String templateFileName) {
        Object resName = this.getClass().getPackage().getName();
        resName = ((String)resName).replace(".", "/");
        resName = (String)resName + Strings.fmt((String)"/templates/%s", (Object[])new Object[]{templateFileName});
        return resName;
    }

    /*
     * Loose catch block
     */
    protected List<String> readTemplate(String templateFileName) {
        String resName = this.getResourceName(templateFileName);
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                List list;
                BufferedInputStream istream;
                InputStream rstream;
                block18: {
                    block17: {
                        rstream = classLoader.getResourceAsStream(resName);
                        istream = new BufferedInputStream(rstream);
                        list = IOUtils.readLines((InputStream)istream, (Charset)StandardCharsets.UTF_8);
                        if (istream == null) break block17;
                        ((InputStream)istream).close();
                    }
                    if (rstream == null) break block18;
                    rstream.close();
                }
                return list;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (istream != null) {
                                ((InputStream)istream).close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (rstream != null) {
                                rstream.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Template read error: " + resName, ex);
        }
    }

    private final class InitOrigDeclNamesWalker
    extends CifWalker {
        private InitOrigDeclNamesWalker() {
        }

        public void initOrigDeclNames(Specification spec) {
            this.walkSpecification(spec);
        }

        protected void preprocessDeclaration(Declaration decl) {
            CodeGen.this.origDeclNames.put(decl, CifTextUtils.getAbsName((PositionObject)decl, (boolean)false));
        }
    }
}

